/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.RetentionIndexExtractor;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io.StandardsReader;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.support.ui.wizards.AbstractExtendedWizardPage;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.ExtendedRetentionIndexListUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.RetentionIndexTableViewerUI;
import org.eclipse.chemclipse.ux.extension.xxd.ui.custom.ChromatogramPeakChart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PageCalibrationTable
extends AbstractExtendedWizardPage {
    private IRetentionIndexWizardElements wizardElements;
    private Button checkBoxValidateRetentionIndices;
    private ChromatogramPeakChart chromatogramPeakChart;
    private ExtendedRetentionIndexListUI extendedRetentionIndexTableViewerUI;

    public PageCalibrationTable(IRetentionIndexWizardElements wizardElements) {
        super(PageCalibrationTable.class.getName());
        this.setTitle("Calibration Table");
        this.setDescription("Please verify the calibration table.");
        this.wizardElements = wizardElements;
    }

    public boolean canFinish() {
        return this.wizardElements.isRetentionIndexDataValidated();
    }

    public void setDefaultValues() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IChromatogramSelection chromatogramSelection = this.wizardElements.getChromatogramSelection();
            if (chromatogramSelection != null && chromatogramSelection.getChromatogram() != null) {
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                this.updateChromatogramChart(chromatogramSelection);
                RetentionIndexExtractor retentionIndexExtractor = new RetentionIndexExtractor();
                ISeparationColumnIndices separationColumnIndices = retentionIndexExtractor.extract(chromatogram);
                this.wizardElements.setSeparationColumnIndices(separationColumnIndices);
                this.extendedRetentionIndexTableViewerUI.setInput(separationColumnIndices);
            }
            this.validateSelection();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createCheckBoxField(composite);
        this.createChromatogramField(composite);
        this.createTableField(composite);
        this.validateSelection();
        this.setControl((Control)composite);
    }

    private void createCheckBoxField(Composite composite) {
        this.checkBoxValidateRetentionIndices = new Button(composite, 32);
        this.checkBoxValidateRetentionIndices.setText("Retention indices are valid.");
        this.checkBoxValidateRetentionIndices.setSelection(false);
        this.checkBoxValidateRetentionIndices.setLayoutData((Object)new GridData(768));
        this.checkBoxValidateRetentionIndices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PageCalibrationTable.this.wizardElements.setRetentionIndexDataIsValidated(PageCalibrationTable.this.checkBoxValidateRetentionIndices.getSelection());
                PageCalibrationTable.this.validateSelection();
            }
        });
    }

    private void createChromatogramField(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new FillLayout());
        this.chromatogramPeakChart = new ChromatogramPeakChart(parent, 2048);
    }

    private void createTableField(Composite composite) {
        this.extendedRetentionIndexTableViewerUI = new ExtendedRetentionIndexListUI(composite, 0);
        this.extendedRetentionIndexTableViewerUI.addRetentionIndexEntries(new StandardsReader().getStandardsList());
        this.extendedRetentionIndexTableViewerUI.setLayoutData((Object)new GridData(1808));
        final RetentionIndexTableViewerUI retentionIndexTableViewerUI = this.extendedRetentionIndexTableViewerUI.getRetentionIndexTableViewerUI();
        retentionIndexTableViewerUI.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                Table table = retentionIndexTableViewerUI.getTable();
                TableItem tableItem = table.getItem(index = table.getSelectionIndex());
                Object object = tableItem.getData();
                if (object instanceof IRetentionIndexEntry) {
                    IChromatogram chromatogram;
                    IPeak selectedPeak;
                    IRetentionIndexEntry retentionIndexEntry = (IRetentionIndexEntry)object;
                    int retentionTime = retentionIndexEntry.getRetentionTime();
                    IChromatogramSelection chromatogramSelection = PageCalibrationTable.this.wizardElements.getChromatogramSelection();
                    if (chromatogramSelection != null && chromatogramSelection.getChromatogram() != null && (selectedPeak = PageCalibrationTable.this.getSelectedPeak((IChromatogram<? extends IPeak>)(chromatogram = chromatogramSelection.getChromatogram()), retentionTime)) != null) {
                        chromatogramSelection.setSelectedPeak(selectedPeak);
                        ArrayList<IPeak> selectedPeaks = new ArrayList<IPeak>();
                        selectedPeaks.add(selectedPeak);
                        PageCalibrationTable.this.updateSelectedPeaksInChart(selectedPeaks);
                    }
                }
            }
        });
    }

    private IPeak getSelectedPeak(IChromatogram<? extends IPeak> chromatogram, int retentionTime) {
        for (IPeak peak : chromatogram.getPeaks()) {
            if (peak.getPeakModel().getRetentionTimeAtPeakMaximum() != retentionTime) continue;
            return peak;
        }
        return null;
    }

    private void validateSelection() {
        String message = null;
        if (!this.checkBoxValidateRetentionIndices.getSelection()) {
            message = "Please verify the data and activate the check box.";
        }
        this.updateStatus(message);
    }

    private void updateChromatogramChart(IChromatogramSelection chromatogramSelection) {
        this.chromatogramPeakChart.updateChromatogram(chromatogramSelection);
    }

    private void updateSelectedPeaksInChart(List<IPeak> selectedPeaks) {
        this.chromatogramPeakChart.updatePeaks(selectedPeaks);
    }
}

