/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudApplicationURL;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.cft.server.ui.internal.WizardPartChangeEvent;
import org.eclipse.cft.server.ui.internal.wizards.CloudUIEvent;
import org.eclipse.cft.server.ui.internal.wizards.HostnameValidationResult;
import org.eclipse.cft.server.ui.internal.wizards.IReservedURLTracker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CloudApplicationUrlPart
extends UIPart {
    protected final ApplicationUrlLookupService lookupService;
    private String currentUrl;
    private Control validationSource;
    private Text subDomainText;
    private Text fullURLText;
    private Combo domainCombo;
    private Button validateButton;
    private IWizardPage page;
    private boolean visited = false;

    public CloudApplicationUrlPart(ApplicationUrlLookupService lookupService) {
        this.lookupService = lookupService;
        this.visited = false;
    }

    public Composite createPart(Composite parent) {
        Composite subDomainComp = parent;
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(subDomainComp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subDomainComp);
        Label label = new Label(subDomainComp, 0);
        label.setText(Messages.CloudApplicationUrlPart_TEXT_SUBDOMAIN_LABEL);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.subDomainText = new Text(subDomainComp, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.subDomainText);
        this.subDomainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CloudApplicationUrlPart.this.notifyChange(new PartChangeEvent(CloudApplicationUrlPart.this.subDomainText, Status.OK_STATUS, CloudUIEvent.VALIDATE_HOST_TAKEN_EVENT, 1004));
                CloudApplicationUrlPart.this.notifyChange(new PartChangeEvent(CloudApplicationUrlPart.this.subDomainText, Status.OK_STATUS, CloudUIEvent.VALIDATE_SUBDOMAIN_EVENT, 1003));
                CloudApplicationUrlPart.this.resolveUrlFromSubdomain((Control)CloudApplicationUrlPart.this.subDomainText);
            }
        });
        label = new Label(subDomainComp, 0);
        label.setText(Messages.COMMONTXT_DOMAIN);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.domainCombo = new Combo(subDomainComp, 2056);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.domainCombo);
        this.domainCombo.setEnabled(true);
        this.domainCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CloudApplicationUrlPart.this.resolveUrlFromSubdomain((Control)CloudApplicationUrlPart.this.domainCombo);
            }
        });
        label = new Label(subDomainComp, 0);
        label.setText(Messages.CloudApplicationUrlPart_TEXT_DEPLOYURL_LABEL);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.fullURLText = new Text(subDomainComp, 2048);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.fullURLText);
        this.fullURLText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CloudApplicationUrlPart.this.currentUrl = CloudApplicationUrlPart.this.fullURLText.getText();
                CloudApplicationUrlPart.this.validate(null, (Control)CloudApplicationUrlPart.this.fullURLText);
            }
        });
        this.validateButton = new Button(subDomainComp, 8);
        this.validateButton.setText(Messages.CloudApplicationUrlPart_BUTTON_VALIDATE_LABEL);
        this.validateButton.setToolTipText(Messages.CloudApplicationUrlPart_BUTTON_VALIDATE_LABEL_HOVERHELP);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.validateButton);
        this.validateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                CloudApplicationURL appUrl = null;
                try {
                    appUrl = CloudApplicationUrlPart.this.lookupService.getCloudApplicationURL(CloudApplicationUrlPart.this.fullURLText.getText());
                }
                catch (CoreException coreException) {
                    return;
                }
                if (appUrl != null) {
                    CloudApplicationUrlPart.this.validateHostNameChecker(appUrl);
                }
            }
        });
        return subDomainComp;
    }

    public String getCurrentSubDomain() {
        return this.subDomainText.getText();
    }

    public String getCurrentDomain() {
        if (this.isActive((Control)this.domainCombo)) {
            int selectionIndex = this.domainCombo.getSelectionIndex();
            String[] domains = this.domainCombo.getItems();
            if (selectionIndex >= 0 && selectionIndex < domains.length) {
                return domains[selectionIndex];
            }
        }
        return null;
    }

    public void refreshDomains() {
        if (this.isActive((Control)this.domainCombo)) {
            String existingSelection = this.getCurrentDomain();
            List<String> domains = this.getDomains();
            this.domainCombo.setItems(domains.toArray(new String[0]));
            this.updateDomainSelection(existingSelection);
        }
    }

    public void setUrl(String url) {
        this.currentUrl = url;
        this.setTextValue(this.fullURLText, this.currentUrl);
    }

    public void setSubdomain(String subdomain) {
        this.setTextValue(this.subDomainText, subdomain);
    }

    protected void setTextValue(Text textControl, String value) {
        if (value == null) {
            value = "";
        }
        if (this.isActive((Control)textControl) && !textControl.getText().equals(value)) {
            textControl.setText(value);
        }
    }

    protected void resolveUrlFromSubdomain(Control source) {
        String subdomain = this.subDomainText.getText();
        String domain = this.getCurrentDomain();
        CloudApplicationURL suggestedUrl = new CloudApplicationURL(subdomain, domain);
        this.validate(suggestedUrl, source);
    }

    protected boolean isActive(Control control) {
        return control != null && !control.isDisposed();
    }

    protected void validate(CloudApplicationURL appUrl, Control source) {
        String subDomain;
        if (this.validationSource != null) {
            return;
        }
        this.validationSource = source;
        IStatus status = Status.OK_STATUS;
        if (appUrl == null) {
            if (this.currentUrl != null) {
                try {
                    appUrl = this.lookupService.getCloudApplicationURL(this.currentUrl);
                }
                catch (CoreException ce) {
                    status = ce.getStatus();
                }
            }
        } else {
            try {
                appUrl = this.lookupService.validateCloudApplicationUrl(appUrl);
            }
            catch (CoreException ce) {
                status = ce.getStatus();
            }
        }
        if (appUrl != null) {
            this.currentUrl = appUrl.getUrl();
        }
        if (this.validationSource != this.fullURLText) {
            this.setTextValue(this.fullURLText, this.currentUrl);
        }
        if (this.validationSource != this.domainCombo) {
            String domain = appUrl != null ? appUrl.getDomain() : null;
            this.updateDomainSelection(domain);
        }
        String string = subDomain = appUrl != null ? appUrl.getSubdomain() : null;
        if (this.validationSource != this.subDomainText) {
            this.setTextValue(this.subDomainText, subDomain);
        }
        if (subDomain != null && subDomain.contains("_")) {
            status = CloudFoundryPlugin.getErrorStatus((String)Messages.CloudApplicationUrlPart_ERROR_INVALID_UNDERSCORE_CHAR);
        }
        this.validateButton.setEnabled(status.isOK());
        this.validationSource = null;
        this.notifyChange(new PartChangeEvent(this.currentUrl, status, CloudUIEvent.APPLICATION_URL_CHANGED));
    }

    protected List<String> getDomains() {
        ArrayList<String> domains = new ArrayList<String>();
        List cloudDomains = this.lookupService.getDomains();
        if (cloudDomains != null) {
            for (CloudDomain cldm : cloudDomains) {
                domains.add(cldm.getName());
            }
        }
        return domains;
    }

    protected void updateDomainSelection(String domain) {
        if (this.isActive((Control)this.domainCombo)) {
            int selectionIndex;
            List<String> domains;
            if (this.getSelectionIndex(domain) < 0 && this.getCurrentDomain() == null && !(domains = this.getDomains()).isEmpty()) {
                domain = domains.get(0);
            }
            if (domain != null && (selectionIndex = this.getSelectionIndex(domain)) > -1) {
                this.domainCombo.select(selectionIndex);
            }
        }
    }

    protected int getSelectionIndex(String domain) {
        int selectionIndex = -1;
        String[] domains = this.domainCombo.getItems();
        if (domains != null) {
            int i = 0;
            while (i < domains.length) {
                if (domains[i].equals(domain)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
        }
        return selectionIndex;
    }

    public void setPage(IWizardPage page) {
        this.page = page;
    }

    public void doInitialValidate() {
        if (!this.visited) {
            IReservedURLTracker reservedURLTracker;
            IWizard wizard;
            this.visited = true;
            CloudApplicationURL appUrl = null;
            try {
                appUrl = this.lookupService.getCloudApplicationURL(this.currentUrl);
            }
            catch (CoreException coreException) {
                return;
            }
            if (appUrl != null && (wizard = this.page.getWizard()) instanceof IReservedURLTracker && !(reservedURLTracker = (IReservedURLTracker)wizard).isReserved(appUrl)) {
                HostnameValidationResult validationResult = reservedURLTracker.validateURL(appUrl);
                if (validationResult.getStatus().isOK()) {
                    reservedURLTracker.addToReserved(appUrl, validationResult.isRouteCreated());
                }
                this.notifyChange(new WizardPartChangeEvent((Object)appUrl, validationResult.getStatus(), CloudUIEvent.VALIDATE_HOST_TAKEN_EVENT, 1004, true));
            }
        }
    }

    private void validateHostNameChecker(CloudApplicationURL appUrl) {
        CloudApplicationURL cloudAppURL = appUrl;
        Shell activeShell = Display.getDefault().getActiveShell();
        IWizard wizard = this.page.getWizard();
        if (wizard instanceof IReservedURLTracker) {
            IReservedURLTracker reservedURLTracker = (IReservedURLTracker)wizard;
            if (!reservedURLTracker.isReserved(cloudAppURL)) {
                HostnameValidationResult validationResult = reservedURLTracker.validateURL(cloudAppURL);
                if (validationResult.getStatus().isOK()) {
                    reservedURLTracker.addToReserved(cloudAppURL, validationResult.isRouteCreated());
                    MessageDialog.openInformation((Shell)activeShell, (String)Messages.CloudApplicationUrlPart_DIALOG_TITLE_HOSTNAME_VALIDATION, (String)Messages.bind((String)Messages.CloudApplicationUrlPart_DIALOG_MESSAGE_HOSTNAME_AVAILABLE, (Object)cloudAppURL.getSubdomain()));
                } else {
                    MessageDialog.openError((Shell)activeShell, (String)Messages.CloudApplicationUrlPart_DIALOG_TITLE_HOSTNAME_VALIDATION, (String)Messages.bind((String)Messages.CloudApplicationUrlPart_ERROR_HOSTNAME_TAKEN, (Object)cloudAppURL.getUrl()));
                }
                this.notifyChange(new WizardPartChangeEvent((Object)appUrl, validationResult.getStatus(), CloudUIEvent.VALIDATE_HOST_TAKEN_EVENT, 1004, true));
            } else {
                MessageDialog.openInformation((Shell)activeShell, (String)Messages.CloudApplicationUrlPart_DIALOG_TITLE_HOSTNAME_VALIDATION, (String)Messages.bind((String)Messages.CloudApplicationUrlPart_DIALOG_MESSAGE_HOSTNAME_AVAILABLE, (Object)cloudAppURL.getSubdomain()));
                this.notifyChange(new WizardPartChangeEvent((Object)appUrl, Status.OK_STATUS, CloudUIEvent.VALIDATE_HOST_TAKEN_EVENT, 1004, true));
            }
        }
    }
}

