/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.information;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PassingMode implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    BY_REF(1, "BY_REF", "BY_REF"),
    BY_VALUE(2, "BY_VALUE", "BY_VALUE");

    public static final int UNSET_VALUE = 0;
    public static final int BY_REF_VALUE = 1;
    public static final int BY_VALUE_VALUE = 2;
    private static final PassingMode[] VALUES_ARRAY;
    public static final List<PassingMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PassingMode[]{UNSET, BY_REF, BY_VALUE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PassingMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PassingMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PassingMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PassingMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PassingMode get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return BY_REF;
            }
            case 2: {
                return BY_VALUE;
            }
        }
        return null;
    }

    private PassingMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

