/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.extraction.extraction;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.xmlpivot.extraction.extraction.IMMMarker;
import org.polarsys.capella.xmlpivot.extraction.extraction.MMExtractionSimplifiedMetadata;
import org.polarsys.capella.xmlpivot.extraction.mapping.HashIterableInvertibleBinaryRelation;

public class MMMarker
implements IMMMarker {
    private final HashIterableInvertibleBinaryRelation _invertibleRelationMapping;
    private final MMExtractionSimplifiedMetadata _meta;

    public MMMarker(HashIterableInvertibleBinaryRelation invertibleRelationMapping_p, MMExtractionSimplifiedMetadata meta_p) {
        this._invertibleRelationMapping = invertibleRelationMapping_p;
        this._meta = meta_p;
    }

    @Override
    public void markMModel() {
        this.markAllClassesTypesOfNavigableAttributesAndReferences();
        this.rebuildTypeHierarchy(this._invertibleRelationMapping.getValues(EClass.class));
        this.removeAllDuplicatesInInheritancesIterative();
    }

    private void markAllClassesTypesOfNavigableAttributesAndReferences() {
        for (EStructuralFeature feature : this._invertibleRelationMapping.getValues(EStructuralFeature.class)) {
            if (!this._meta.isNavigable(feature)) continue;
            this._meta.setMarked((EModelElement)feature.getEType());
            this._meta.setMarked((EModelElement)feature.getEContainingClass());
        }
    }

    private void removeAllDuplicatesInInheritancesIterative() {
        boolean moreToRemove = true;
        while (moreToRemove) {
            moreToRemove = false;
            for (EClass cls : this._invertibleRelationMapping.getValues(EClass.class)) {
                if (!this._meta.isConserved((EClassifier)cls)) continue;
                moreToRemove |= this.removeClassDuplicatesInInheritances(cls);
            }
        }
    }

    private boolean removeClassDuplicatesInInheritances(EClass cls_p) {
        boolean moreToRemove = false;
        Iterator superclsit = cls_p.getESuperTypes().iterator();
        while (superclsit.hasNext()) {
            EClass supercls = (EClass)superclsit.next();
            int duplicates = 0;
            for (EClass currentSupercls : cls_p.getESuperTypes()) {
                if (!currentSupercls.getName().equals(supercls.getName())) continue;
                ++duplicates;
            }
            if (duplicates <= true) continue;
            superclsit.remove();
            --duplicates;
            moreToRemove = true;
        }
        return moreToRemove;
    }

    private void rebuildTypeHierarchy(Collection<EClass> classes) {
        for (EClass cls : classes) {
            if (!this._meta.isConserved((EClassifier)cls)) continue;
            this.rebuildTypeHierarchy(cls, classes);
        }
    }

    private void rebuildTypeHierarchy(EClass cls_p, Collection<EClass> scope) {
        boolean change = true;
        block0: while (change) {
            change = false;
            Iterator superit = cls_p.getESuperTypes().iterator();
            while (superit.hasNext()) {
                EClass supercls = (EClass)superit.next();
                if (!scope.contains(supercls) || this._meta.isConserved((EClassifier)supercls)) continue;
                superit.remove();
                cls_p.getESuperTypes().addAll((Collection)supercls.getESuperTypes());
                change = true;
                continue block0;
            }
        }
    }
}

