/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.transition.common.transposer.SharedWorkflowActivityParameter;
import org.polarsys.capella.transition.system2subsystem.crossphases.commands.CrossPhasesCommand;
import org.polarsys.capella.transition.system2subsystem.interphases.commands.InterPhasesCommand;
import org.polarsys.capella.transition.system2subsystem.multiphases.commands.HeadlessMultiphasesCommand;
import org.polarsys.capella.transition.system2subsystem.tests.AbstractSystem2SubsystemTest;

public abstract class System2SubsystemTest
extends AbstractSystem2SubsystemTest {
    protected Kind kind;

    public static Collection<System2SubsystemTest> testsFor(Class<? extends System2SubsystemTest> clazz) {
        ArrayList<System2SubsystemTest> result = new ArrayList<System2SubsystemTest>();
        try {
            System2SubsystemTest test;
            if (Crossphase.class.isAssignableFrom(clazz)) {
                test = clazz.newInstance();
                test.setKind(Kind.CROSS_PHASES);
                result.add(test);
            }
            if (Interphase.class.isAssignableFrom(clazz)) {
                test = clazz.newInstance();
                test.setKind(Kind.INTER_PHASES);
                result.add(test);
            }
            if (Multiphase.class.isAssignableFrom(clazz)) {
                test = clazz.newInstance();
                test.setKind(Kind.MULTI_PHASES);
                result.add(test);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String getName() {
        return String.valueOf(super.getName()) + " [" + (Object)((Object)this.kind) + "]";
    }

    public final void performTest() {
        throw new UnsupportedOperationException();
    }

    protected void executeTransition() {
        this.executeCommand(this.getTransitionCommand());
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.getProject();
    }

    public void test() throws Exception {
        this.executeTransition();
        this.traceability = this.initTraceability(this.modelResource, this.getOutputModelResource());
        this.verify();
    }

    protected void verify() throws Exception {
    }

    protected ICommand getTransitionCommand() {
        return this.kind.getCommand(this.getProjectionElements(), this.getHeadlessParameters());
    }

    protected abstract Collection<?> getProjectionElements();

    public List<String> getRequiredTestModels() {
        return Arrays.asList("Project_test_01", "output");
    }

    public static interface Crossphase {
    }

    public static interface Interphase {
    }

    public static enum Kind {
        INTER_PHASES,
        CROSS_PHASES,
        MULTI_PHASES;


        public ICommand getCommand(Collection<?> selection, SharedWorkflowActivityParameter parameters) {
            HeadlessMultiphasesCommand command = null;
            switch (this) {
                case INTER_PHASES: {
                    command = new InterPhasesCommand(selection, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                case CROSS_PHASES: {
                    command = new CrossPhasesCommand(selection, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                case MULTI_PHASES: {
                    command = new HeadlessMultiphasesCommand(selection);
                }
            }
            command.addParameters(parameters);
            return command;
        }
    }

    public static interface Multiphase {
    }
}

