/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.crossphases.rules.pa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.transition.system2subsystem.crossphases.handlers.attachment.CrossPhasesAttachmentHelper;
import org.polarsys.capella.transition.system2subsystem.crossphases.rules.pa.Component2SARule;
import org.polarsys.kitalpha.transposer.rules.handler.business.premises.ContainmentPremise;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IPremise;

public class PhysicalComponentRule
extends Component2SARule {
    protected EClass getSourceType() {
        return PaPackage.Literals.PHYSICAL_COMPONENT;
    }

    protected void premicesContainement(EObject element, ArrayList<IPremise> needed) {
        ContainmentPremise defaultPremise = this.createDefaultContainementPremice(element);
        if (defaultPremise != null) {
            ContainmentPremise currentPremise;
            needed.add((IPremise)defaultPremise);
            IContext context = this.getCurrentContext();
            Component bestContainer = CrossPhasesAttachmentHelper.getInstance(context).getRelatedComponent((Component)element, context);
            if (!bestContainer.equals(element) && !((EObject)defaultPremise.getFirstElement()).equals(bestContainer) && (currentPremise = this.createContainmentPremice((EObject)bestContainer)) != null) {
                needed.add((IPremise)currentPremise);
            }
        }
    }

    @Override
    protected void premicesRelated(EObject element, ArrayList<IPremise> needed) {
        super.premicesRelated(element, needed);
        AbstractPhysicalComponent physicalElement = (AbstractPhysicalComponent)element;
        for (Partition partition : physicalElement.getRepresentingPartitions()) {
            Collection es = ComponentExt.getPartAncestors((Part)((Part)partition), (boolean)true);
            needed.addAll(this.createDefaultPrecedencePremices(es, "part"));
        }
        needed.addAll(this.createDefaultPrecedencePremices(element, CsPackage.Literals.COMPONENT__ALLOCATING_COMPONENTS));
    }

    public IStatus transformRequired(EObject source, IContext context) {
        AbstractPhysicalComponent element = (AbstractPhysicalComponent)source;
        Collection transfoSources = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (transfoSources.contains(element)) {
            return Status.OK_STATUS;
        }
        Component src = CrossPhasesAttachmentHelper.getInstance(context).getRelatedComponent((Component)element, context);
        if (src != element) {
            return new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Component ''{0}'' will be merged into ''{1}''", (Object)LogHelper.getInstance().getText((Object)element), (Object)LogHelper.getInstance().getText((Object)src)));
        }
        return super.transformRequired(source, context);
    }

    protected void retrieveGoDeep(EObject source, List<EObject> result, IContext context) {
        super.retrieveGoDeep(source, result, context);
        if (ContextScopeHandlerHelper.getInstance((IContext)context).contains("S_S", source, context) && source instanceof Component) {
            Component element = (Component)source;
            for (Partition part : element.getOwnedPartitions()) {
                if (!(part instanceof Part)) continue;
                result.add((EObject)part);
                ContextScopeHandlerHelper.getInstance((IContext)context).add("S_S", (EObject)part, context);
            }
        }
    }
}

