/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.vp.requirements.docgen.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.kitalpha.doc.gen.business.core.preference.helper.DocgenDiagramPreferencesHelper;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.scope.ScopeReferencesStrategy;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.EscapeChars;
import org.polarsys.kitalpha.doc.gen.business.core.util.IFileNameService;
import org.polarsys.kitalpha.doc.gen.business.core.util.LabelProviderHelper;
import org.polarsys.kitalpha.vp.requirements.Requirements.Folder;
import org.polarsys.kitalpha.vp.requirements.Requirements.Module;
import org.polarsys.kitalpha.vp.requirements.Requirements.ReqIFElement;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;
import org.polarsys.kitalpha.vp.requirements.docgen.utils.RequirementFileNameService;

public class RequirementsServices {
    public static final String H1_OPEN = "<h1>";
    public static final String H1_CLOSE = "</h1>";
    public static final String H2_OPEN = "<h2>";
    public static final String H2_CLOSE = "</h2>";
    public static final String TABLE_OPEN = "<table>";
    public static final String TABLE_CLOSE = "</table>";
    public static final String TABLE_ROW_OPEN = "<tr>";
    public static final String TABLE_ROW_CLOSE = "</tr>";
    public static final String TABLE_TH_OPEN = "<th>";
    public static final String TABLE_TH_CLOSE = "</th>";
    public static final String TABLE_TD_OPEN = "<td>";
    public static final String TABLE_TD_CLOSE = "</td>";
    public static final String LIST_OPEN = "<ul>";
    public static final String LIST_CLOSE = "</ul>";
    public static final String LIST_ITEM_OPEN = "<li>";
    public static final String LIST_ITEM_CLOSE = "</li>";
    protected static final String HYPERLINK_OPEN = "<a href=\"";
    protected static final String HYPERLINK_SEPARATOR = "/";
    protected static final String HYPERLINK_COMPLETE = "\">";
    protected static final String HYPERLINK_CLOSE = "</a>";
    private static final String PATH_OPEN = "../";
    private static final String PATH_COMPLETE = ".html";
    public static final String LINE_BREAK = "<br/>";
    public static final String NO_SOURCE_DEFINED = "No source defined";
    public static final String NO_TARGET_DEFINED = "No target defined";

    public static Set<DSemanticDiagram> getDiagramContainingObject(ReqIFElement element) {
        HashSet<DSemanticDiagram> diagrams = new HashSet<DSemanticDiagram>();
        if (!DocgenDiagramPreferencesHelper.getExportDiagram()) {
            return diagrams;
        }
        if (GenerationGlobalScope.getInstance().getReferencesStrategy().equals((Object)ScopeReferencesStrategy.DONT_EXPORT)) {
            element = (ReqIFElement)GenerationGlobalScope.getInstance().getOriginalModelElement((EObject)element);
        }
        for (DRepresentation representation : DiagramSessionHelper.getSessionDRepresentation()) {
            if (!(representation instanceof DSemanticDiagram)) continue;
            DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)representation;
            EObject semanticTarget = ((DSemanticDiagram)representation).getTarget();
            boolean copyInScope = GenerationGlobalScope.getInstance().isCopyInScope(semanticTarget);
            if (!copyInScope) continue;
            for (DDiagramElement diagramElement : dSemanticDiagram.getDiagramElements()) {
                EObject target = diagramElement.getTarget();
                if (!diagramElement.isVisible() || !EcoreUtil.equals((EObject)element, (EObject)target) || EcoreUtil.equals((EObject)semanticTarget, (EObject)target)) continue;
                diagrams.add((DSemanticDiagram)representation);
            }
        }
        return diagrams;
    }

    public static boolean hasChildren(ReqIFElement element) {
        if (element instanceof Module) {
            return !((Module)element).getOwnedRequirements().isEmpty();
        }
        if (element instanceof Folder) {
            return !((Folder)element).getOwnedRequirements().isEmpty();
        }
        return false;
    }

    public static String getElementPath(EObject element, IFileNameService fileNameService) {
        StringBuffer buffer = new StringBuffer();
        Iterator<EObject> iterator = RequirementsServices.getFullElementPath(element).iterator();
        while (iterator.hasNext()) {
            EObject model = iterator.next();
            IFileNameService usedFileNameService = null;
            if (!(model instanceof ReqIFElement)) {
                usedFileNameService = fileNameService;
            }
            buffer.append(RequirementsServices.getHyperlinkFromElement(model, usedFileNameService));
            if (!iterator.hasNext()) continue;
            buffer.append(" > ");
        }
        return buffer.toString();
    }

    private static List<EObject> getFullElementPath(EObject element) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        EObject parent = element.eContainer();
        if (parent instanceof EObject) {
            eObjects.addAll(RequirementsServices.getFullElementPath(parent));
        }
        eObjects.add(element);
        return eObjects;
    }

    public static String getHyperlinkFromElement(EObject element) {
        return RequirementsServices.getHyperlinkFromElement(element, LabelProviderHelper.getText((EObject)element), RequirementFileNameService.SERVICE);
    }

    public static String getHyperlinkFromElement(EObject element, IFileNameService service) {
        return RequirementsServices.getHyperlinkFromElement(element, LabelProviderHelper.getText((EObject)element), service);
    }

    private static String getHyperlinkFromElement(EObject element, String label, IFileNameService service) {
        if (element instanceof DSemanticDiagram) {
            return RequirementsServices.getHyperlinkFromDiagram((DSemanticDiagram)element, service);
        }
        int linked = RequirementsServices.isLinkable(element, service);
        String text = label;
        text = EscapeChars.forHTML((String)text);
        StringBuffer buffer = new StringBuffer();
        if (linked != -1) {
            buffer.append(HYPERLINK_OPEN);
            if (linked == 1) {
                buffer.append(RequirementsServices.getPathFromElement(element.eContainer(), service));
                buffer.append("#");
                buffer.append(RequirementsServices.getAnchorId(element));
            } else {
                buffer.append(RequirementsServices.getPathFromElement(element, service));
            }
            buffer.append(HYPERLINK_COMPLETE);
        }
        buffer.append(text);
        if (linked != -1) {
            buffer.append(HYPERLINK_CLOSE);
        }
        return buffer.toString();
    }

    private static String getHyperlinkFromDiagram(DSemanticDiagram diagram, IFileNameService service) {
        String text = LabelProviderHelper.getText((EObject)diagram);
        text = EscapeChars.forHTML((String)text);
        StringBuffer buffer = new StringBuffer();
        buffer.append(HYPERLINK_OPEN);
        buffer.append(RequirementsServices.getPathFromElement(diagram.getTarget(), service));
        buffer.append("#");
        buffer.append(diagram.getUid());
        buffer.append(HYPERLINK_COMPLETE);
        buffer.append(text);
        buffer.append(HYPERLINK_CLOSE);
        return buffer.toString();
    }

    public static String getAnchorId(EObject element) {
        String id = "id" + EcoreUtil.getURI((EObject)element).fragment();
        return id;
    }

    public static int isLinkable(EObject element, IFileNameService service) {
        if (!GenerationGlobalScope.getInstance().inScope(element, true)) {
            return -1;
        }
        if (element instanceof ReqIFElement) {
            return RequirementsServices.isLinkableWithoutScope(element);
        }
        String fileName = service.getFileName(element);
        if (fileName != null && !fileName.isEmpty()) {
            return 0;
        }
        return -1;
    }

    public static int isLinkableWithoutScope(EObject element) {
        if (element instanceof Requirement || element instanceof Module) {
            return 0;
        }
        return -1;
    }

    public static String getPathFromElement(EObject element, IFileNameService fileNameService) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PATH_OPEN);
        buffer.append(DocGenHtmlUtil.getModelName((EObject)element));
        buffer.append(HYPERLINK_SEPARATOR);
        buffer.append(fileNameService != null ? fileNameService.getFileName(element) : RequirementFileNameService.SERVICE.getFileName(element));
        buffer.append(PATH_COMPLETE);
        return buffer.toString();
    }

    public static String getImageLinkFromElement(EObject element, String projectName, String outputFolder) {
        String imageFileName = LabelProviderHelper.getImageFileName((EObject)element, (String)projectName, (String)outputFolder);
        StringBuffer buffer = new StringBuffer();
        return RequirementsServices.appendRelativePath(element, imageFileName, buffer, "../icon/");
    }

    private static String appendRelativePath(EObject element, String imageFileName, StringBuffer buffer, String relativePath) {
        buffer.append("<img src=\"");
        buffer.append(relativePath);
        buffer.append(imageFileName);
        buffer.append("\" alt=\"");
        buffer.append(element.eClass().getName());
        buffer.append("\" />");
        return buffer.toString();
    }
}

