/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.extension;

import java.util.ArrayList;
import java.util.Collection;

public class AttributeSet {
    private String name;
    private String description;
    private boolean defaultValue = false;
    private boolean mandatory = false;
    private boolean selected = false;
    private AttributeSet parent = null;
    private final Collection<AttributeSet> children;

    public AttributeSet(String name) {
        this.name = name;
        this.children = new ArrayList<AttributeSet>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean defaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    public AttributeSet getParent() {
        return this.parent;
    }

    public void setParent(AttributeSet parent) {
        this.parent = parent;
    }

    public Collection<AttributeSet> getChildren() {
        return this.children;
    }

    public boolean hasChildrenSelected() {
        for (AttributeSet node : this.children) {
            if (!node.selected) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllChildrenSelected() {
        for (AttributeSet node : this.children) {
            if (node.selected) continue;
            return false;
        }
        return true;
    }

    public void addChild(AttributeSet node) {
        this.children.add(node);
        node.setParent(this);
    }

    public String toString() {
        return "AttributeSet [name=" + this.name + ", parent=" + this.parent + "]";
    }
}

