/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.view.task.TaskView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

abstract class SelectionDependentHandler
extends AbstractHandler {
    SelectionDependentHandler() {
    }

    public void setEnabled(Object evaluationContext) {
        boolean enabled;
        TaskView taskView = this.getTaskView();
        if (taskView != null) {
            NodeSelection selectionHistory = taskView.getSelection();
            enabled = this.isEnabledFor(selectionHistory);
        } else {
            enabled = false;
        }
        this.setBaseEnabled(enabled);
    }

    protected NodeSelection getSelectionHistory(ExecutionEvent event) {
        TaskView taskView = this.getTaskView(event);
        if (taskView == null) {
            throw new IllegalStateException(String.format("Cannot execute command '%s' in current window.", this.getCommandName(event)));
        }
        NodeSelection selectionHistory = taskView.getSelection();
        if (!this.isEnabledFor(selectionHistory)) {
            throw new IllegalStateException(String.format("Cannot execute command '%s' for current selection.", this.getCommandName(event)));
        }
        return selectionHistory;
    }

    protected abstract boolean isEnabledFor(NodeSelection var1);

    protected TaskView getTaskView() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            return (TaskView)workbenchWindow.getActivePage().findView("org.eclipse.buildship.ui.views.taskview");
        }
        return null;
    }

    protected TaskView getTaskView(ExecutionEvent event) {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (workbenchWindow != null) {
            return (TaskView)workbenchWindow.getActivePage().findView("org.eclipse.buildship.ui.views.taskview");
        }
        return null;
    }

    protected String getCommandName(ExecutionEvent event) {
        Command command = event.getCommand();
        try {
            return command.getName();
        }
        catch (NotDefinedException e) {
            return "Unknown";
        }
    }
}

