/*
 * Copyright (c) 2017 the original author or authors.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */

package org.eclipse.buildship.ui.internal.wizard.project;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.CoreException;

import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;

/**
 * Helper method for the import wizards.
 *
 * @author Donat Csikos
 */
public class WizardHelper {

    private WizardHelper() {
    }

    /**
     * Converts the target {@link InvocationTargetException} generated by {@code IWizardContainer} into a {@code ToolingApiStatus}.
     *
     * @param exception the target exception
     * @return the new status object
     */
    static ToolingApiStatus containerExceptionToToolingApiStatus(InvocationTargetException exception) {
        Throwable target = exception.getTargetException() == null ? exception : exception.getTargetException();
        if (target instanceof CoreException && ((CoreException) target).getStatus() instanceof ToolingApiStatus) {
           return (ToolingApiStatus) ((CoreException) target).getStatus();
        } else {
            return ToolingApiStatus.from("Project import", target);
        }
    }
}
