/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.adapter;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.impldep.com.google.common.base.Optional;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.typeconversion.EnumFromCharSequenceNotationParser;
import org.gradle.internal.typeconversion.NotationConverterToNotationParserAdapter;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.tooling.internal.adapter.CollectionMapper;
import org.gradle.tooling.internal.adapter.MethodInvocation;
import org.gradle.tooling.internal.adapter.MethodInvoker;
import org.gradle.tooling.internal.adapter.NoOpMethodInvoker;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.adapter.TargetTypeProvider;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.internal.Exceptions;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolToModelAdapter
implements Serializable {
    private static final MethodInvoker NO_OP_HANDLER;
    private static final Action<SourceObjectMapping> NO_OP_MAPPER;
    private static final TargetTypeProvider IDENTITY_TYPE_PROVIDER;
    private static final Object[] EMPTY;
    private static final Pattern IS_SUPPORT_METHOD;
    private final TargetTypeProvider targetTypeProvider;
    private final CollectionMapper collectionMapper = new CollectionMapper();
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;

    public ProtocolToModelAdapter() {
        this(IDENTITY_TYPE_PROVIDER);
    }

    public ProtocolToModelAdapter(TargetTypeProvider targetTypeProvider) {
        this.targetTypeProvider = targetTypeProvider;
    }

    public <T, S> T adapt(Class<T> targetType, S sourceObject) {
        return this.adapt(targetType, sourceObject, NO_OP_MAPPER);
    }

    public <T, S> T adapt(Class<T> targetType, final S sourceObject, final Class<?> mixInClass) {
        return this.adapt(targetType, sourceObject, (Action<? super SourceObjectMapping>)new Action<SourceObjectMapping>(){

            @Override
            public void execute(SourceObjectMapping mapping) {
                if (mapping.getSourceObject() == sourceObject) {
                    mapping.mixIn(mixInClass);
                }
            }
        });
    }

    public <T, S> T adapt(Class<T> targetType, S sourceObject, Action<? super SourceObjectMapping> mapper) {
        if (sourceObject == null) {
            return null;
        }
        Class<T> wrapperType = this.targetTypeProvider.getTargetType(targetType, sourceObject);
        DefaultSourceObjectMapping mapping = new DefaultSourceObjectMapping(sourceObject, targetType, wrapperType);
        mapper.execute(mapping);
        wrapperType = mapping.wrapperType.asSubclass(targetType);
        if (wrapperType.isInstance(sourceObject)) {
            return wrapperType.cast(sourceObject);
        }
        if (targetType.isEnum()) {
            return ProtocolToModelAdapter.adaptToEnum(targetType, sourceObject);
        }
        MixInMethodInvoker mixInMethodInvoker = null;
        if (mapping.mixInType != null) {
            mixInMethodInvoker = new MixInMethodInvoker(mapping.mixInType, new AdaptingMethodInvoker(mapper, new ReflectionMethodInvoker()));
        }
        MethodInvoker overrideInvoker = this.chainInvokers(mixInMethodInvoker, mapping.overrideInvoker);
        Object proxy = Proxy.newProxyInstance(wrapperType.getClassLoader(), new Class[]{wrapperType}, (InvocationHandler)new InvocationHandlerImpl(sourceObject, overrideInvoker, mapper));
        if (mixInMethodInvoker != null) {
            mixInMethodInvoker.setProxy(proxy);
        }
        return wrapperType.cast(proxy);
    }

    private MethodInvoker chainInvokers(MixInMethodInvoker mixInMethodInvoker, MethodInvoker overrideInvoker) {
        if (mixInMethodInvoker == null) {
            return overrideInvoker;
        }
        if (overrideInvoker == NO_OP_HANDLER) {
            return mixInMethodInvoker;
        }
        return new ChainedMethodInvoker(new MethodInvoker[]{mixInMethodInvoker, overrideInvoker});
    }

    private static <T, S> T adaptToEnum(Class<T> targetType, S sourceObject) {
        try {
            String literal = sourceObject instanceof Enum ? ((Enum)sourceObject).name() : (sourceObject instanceof String ? (String)sourceObject : sourceObject.toString());
            NotationConverterToNotationParserAdapter parser = new NotationConverterToNotationParserAdapter(new EnumFromCharSequenceNotationParser<T>(targetType));
            Object parsedLiteral = parser.parseNotation(literal);
            return targetType.cast(parsedLiteral);
        }
        catch (TypeConversionException e) {
            throw new IllegalArgumentException(String.format("Can't convert '%s' to enum type '%s'", sourceObject, targetType.getSimpleName()), e);
        }
    }

    private Object convert(Type targetType, Object sourceObject, Action<? super SourceObjectMapping> mapping) {
        ParameterizedType parameterizedTargetType;
        if (targetType instanceof ParameterizedType && (parameterizedTargetType = (ParameterizedType)targetType).getRawType() instanceof Class) {
            Class rawClass = (Class)parameterizedTargetType.getRawType();
            if (Iterable.class.isAssignableFrom(rawClass)) {
                Type targetElementType = this.getElementType(parameterizedTargetType, 0);
                return this.convertCollectionInternal(rawClass, targetElementType, (Iterable)sourceObject, mapping);
            }
            if (Map.class.isAssignableFrom(rawClass)) {
                Type targetKeyType = this.getElementType(parameterizedTargetType, 0);
                Type targetValueType = this.getElementType(parameterizedTargetType, 1);
                return this.convertMap(rawClass, targetKeyType, targetValueType, (Map)sourceObject, mapping);
            }
        }
        if (targetType instanceof Class) {
            if (((Class)targetType).isPrimitive()) {
                return sourceObject;
            }
            return this.adapt((Class)targetType, sourceObject, mapping);
        }
        throw new UnsupportedOperationException(String.format("Cannot convert object of %s to %s.", sourceObject.getClass(), targetType));
    }

    private Map<Object, Object> convertMap(Class<?> mapClass, Type targetKeyType, Type targetValueType, Map<?, ?> sourceObject, Action<? super SourceObjectMapping> mapping) {
        Map<Object, Object> convertedElements = this.collectionMapper.createEmptyMap(mapClass);
        for (Map.Entry<?, ?> entry : sourceObject.entrySet()) {
            convertedElements.put(this.convert(targetKeyType, entry.getKey(), mapping), this.convert(targetValueType, entry.getValue(), mapping));
        }
        return convertedElements;
    }

    private Object convertCollectionInternal(Class<?> collectionClass, Type targetElementType, Iterable<?> sourceObject, Action<? super SourceObjectMapping> mapping) {
        Collection<Object> convertedElements = this.collectionMapper.createEmptyCollection(collectionClass);
        this.convertCollectionInternal(convertedElements, targetElementType, sourceObject, mapping);
        if (collectionClass.equals(DomainObjectSet.class)) {
            return new ImmutableDomainObjectSet<Object>(convertedElements);
        }
        return convertedElements;
    }

    private void convertCollectionInternal(Collection<Object> targetCollection, Type targetElementType, Iterable<?> sourceObject, Action<? super SourceObjectMapping> mapping) {
        for (Object element : sourceObject) {
            targetCollection.add(this.convert(targetElementType, element, mapping));
        }
    }

    private Type getElementType(ParameterizedType type, int index) {
        Type elementType = type.getActualTypeArguments()[index];
        if (elementType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)elementType;
            return wildcardType.getUpperBounds()[0];
        }
        return elementType;
    }

    public Object unpack(Object viewObject) {
        if (!Proxy.isProxyClass(viewObject.getClass()) || !(Proxy.getInvocationHandler(viewObject) instanceof InvocationHandlerImpl)) {
            throw new IllegalArgumentException("The given object is not a view object");
        }
        InvocationHandlerImpl handler = (InvocationHandlerImpl)Proxy.getInvocationHandler(viewObject);
        return handler.delegate;
    }

    static {
        Method hashCodeMethod;
        Method equalsMethod;
        NO_OP_HANDLER = new NoOpMethodInvoker();
        NO_OP_MAPPER = new NoOpMapping();
        IDENTITY_TYPE_PROVIDER = new TargetTypeProvider(){

            @Override
            public <T> Class<? extends T> getTargetType(Class<T> initialTargetType, Object protocolObject) {
                return initialTargetType;
            }
        };
        EMPTY = new Object[0];
        IS_SUPPORT_METHOD = Pattern.compile("is(\\w+)Supported");
        try {
            equalsMethod = Object.class.getMethod("equals", Object.class);
            hashCodeMethod = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        EQUALS_METHOD = equalsMethod;
        HASHCODE_METHOD = hashCodeMethod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AdaptingMethodInvoker
    implements MethodInvoker {
        private final Action<? super SourceObjectMapping> mapping;
        private final MethodInvoker next;

        private AdaptingMethodInvoker(Action<? super SourceObjectMapping> mapping, MethodInvoker next) {
            this.mapping = mapping;
            this.next = next;
        }

        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            this.next.invoke(invocation);
            if (invocation.found() && invocation.getResult() != null) {
                invocation.setResult(ProtocolToModelAdapter.this.convert(invocation.getGenericReturnType(), invocation.getResult(), this.mapping));
            }
        }
    }

    private static class ChainedMethodInvoker
    implements MethodInvoker {
        private final MethodInvoker[] invokers;

        private ChainedMethodInvoker(MethodInvoker ... invokers) {
            this.invokers = invokers;
        }

        public void invoke(MethodInvocation method) throws Throwable {
            for (int i = 0; !method.found() && i < this.invokers.length; ++i) {
                MethodInvoker invoker = this.invokers[i];
                invoker.invoke(method);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSourceObjectMapping
    implements SourceObjectMapping {
        private final Object protocolObject;
        private final Class<?> targetType;
        private Class<?> wrapperType;
        private Class<?> mixInType;
        private MethodInvoker overrideInvoker = ProtocolToModelAdapter.access$800();

        public DefaultSourceObjectMapping(Object protocolObject, Class<?> targetType, Class<?> wrapperType) {
            this.protocolObject = protocolObject;
            this.targetType = targetType;
            this.wrapperType = wrapperType;
        }

        @Override
        public Object getSourceObject() {
            return this.protocolObject;
        }

        @Override
        public Class<?> getTargetType() {
            return this.targetType;
        }

        @Override
        public void mapToType(Class<?> type) {
            if (!this.targetType.isAssignableFrom(type)) {
                throw new IllegalArgumentException(String.format("requested wrapper type '%s' is not assignable to target type '%s'.", type.getSimpleName(), this.targetType.getSimpleName()));
            }
            this.wrapperType = type;
        }

        @Override
        public void mixIn(Class<?> mixInBeanType) {
            if (this.mixInType != null) {
                throw new UnsupportedOperationException("Mixing in multiple beans is currently not supported.");
            }
            this.mixInType = mixInBeanType;
        }

        @Override
        public void mixIn(MethodInvoker invoker) {
            if (this.overrideInvoker != NO_OP_HANDLER) {
                throw new UnsupportedOperationException("Mixing in multiple invokers is currently not supported.");
            }
            this.overrideInvoker = invoker;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvocationHandlerImpl
    implements InvocationHandler,
    Serializable {
        private final Object delegate;
        private final MethodInvoker overrideMethodInvoker;
        private final Action<? super SourceObjectMapping> mapper;
        private transient MethodInvoker invoker;

        public InvocationHandlerImpl(Object delegate, MethodInvoker overrideMethodInvoker, Action<? super SourceObjectMapping> mapper) {
            this.delegate = delegate;
            this.overrideMethodInvoker = overrideMethodInvoker;
            this.mapper = mapper;
            this.setup();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.setup();
        }

        private void setup() {
            this.invoker = new SupportedPropertyInvoker(new SafeMethodInvoker(new PropertyCachingMethodInvoker(new AdaptingMethodInvoker(this.mapper, new ChainedMethodInvoker(new MethodInvoker[]{this.overrideMethodInvoker, new ReflectionMethodInvoker()})))));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            InvocationHandlerImpl other = (InvocationHandlerImpl)o;
            return this.delegate.equals(other.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public Object invoke(Object target, Method method, Object[] params) throws Throwable {
            if (EQUALS_METHOD.equals(method)) {
                Object param = params[0];
                if (param == null || !Proxy.isProxyClass(param.getClass())) {
                    return false;
                }
                InvocationHandler other = Proxy.getInvocationHandler(param);
                return this.equals(other);
            }
            if (HASHCODE_METHOD.equals(method)) {
                return this.hashCode();
            }
            MethodInvocation invocation = new MethodInvocation(method.getName(), method.getReturnType(), method.getGenericReturnType(), method.getParameterTypes(), this.delegate, params);
            this.invoker.invoke(invocation);
            if (!invocation.found()) {
                String methodName = method.getDeclaringClass().getSimpleName() + "." + method.getName() + "()";
                throw Exceptions.unsupportedMethod(methodName);
            }
            return invocation.getResult();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInvocationCache {
        private final Map<MethodInvocationKey, Optional<Method>> store = new HashMap<MethodInvocationKey, Optional<Method>>();
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private static final long MINIMAL_CLEANUP_INTERVAL = 30000L;
        private int cacheMiss;
        private int cacheHit;
        private int evict;
        private long lastCleanup = System.currentTimeMillis();

        private MethodInvocationCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Method get(MethodInvocation invocation) {
            Class<?> owner = invocation.getDelegate().getClass();
            String name = invocation.getName();
            Class[] parameterTypes = invocation.getParameterTypes();
            MethodInvocationKey key = new MethodInvocationKey(owner, name, parameterTypes);
            this.lock.readLock().lock();
            Optional<Method> cached = this.store.get(key);
            if (cached == null) {
                ++this.cacheMiss;
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    cached = this.store.get(key);
                    if (cached == null) {
                        cached = MethodInvocationCache.lookup(owner, name, parameterTypes);
                        if (this.cacheMiss % 10 == 0) {
                            this.removeDirtyEntries();
                        }
                        this.store.put(key, cached);
                    }
                    this.lock.readLock().lock();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            } else {
                ++this.cacheHit;
            }
            try {
                Method method = cached.orNull();
                return method;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeDirtyEntries() {
            long now = System.currentTimeMillis();
            if (now - this.lastCleanup < 30000L) {
                return;
            }
            this.lock.writeLock().lock();
            try {
                for (MethodInvocationKey key : new LinkedList<MethodInvocationKey>(this.store.keySet())) {
                    if (!key.isDirty()) continue;
                    ++this.evict;
                    this.store.remove(key);
                }
            }
            finally {
                this.lastCleanup = now;
                this.lock.writeLock().unlock();
            }
        }

        private static Optional<Method> lookup(Class<?> sourceClass, String methodName, Class<?>[] parameterTypes) {
            Method match;
            try {
                match = sourceClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return Optional.absent();
            }
            LinkedList queue = new LinkedList();
            queue.add(sourceClass);
            while (!queue.isEmpty()) {
                Class c = (Class)queue.removeFirst();
                try {
                    match = c.getMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                for (Class<?> interfaceType : c.getInterfaces()) {
                    queue.addFirst(interfaceType);
                }
                if (c.getSuperclass() == null) continue;
                queue.addFirst(c.getSuperclass());
            }
            match.setAccessible(true);
            return Optional.of(match);
        }

        public String toString() {
            return "Cache size: " + this.store.size() + " Hits: " + this.cacheHit + " Miss: " + this.cacheMiss + " Evicted: " + this.evict;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class MethodInvocationKey {
            private final SoftReference<Class<?>> lookupClass;
            private final String methodName;
            private final SoftReference<Class<?>[]> parameterTypes;
            private final int hashCode;

            private MethodInvocationKey(Class<?> lookupClass, String methodName, Class<?>[] parameterTypes) {
                this.lookupClass = new SoftReference(lookupClass);
                this.methodName = methodName;
                this.parameterTypes = new SoftReference<Class<?>[]>(parameterTypes);
                int result = lookupClass != null ? lookupClass.hashCode() : 0;
                result = 31 * result + (methodName != null ? methodName.hashCode() : 0);
                this.hashCode = result = 31 * result + Arrays.hashCode(parameterTypes);
            }

            public boolean isDirty() {
                return this.lookupClass.get() == null || this.parameterTypes.get() == null;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                MethodInvocationKey that = (MethodInvocationKey)o;
                if (this.isDirty() && that.isDirty()) {
                    return true;
                }
                if (!MethodInvocationKey.eq(this.lookupClass, that.lookupClass)) {
                    return false;
                }
                if (!this.methodName.equals(that.methodName)) {
                    return false;
                }
                return MethodInvocationKey.eq(this.parameterTypes, that.parameterTypes);
            }

            private static boolean eq(SoftReference<?> aRef, SoftReference<?> bRef) {
                Object a = aRef.get();
                Object b = bRef.get();
                return MethodInvocationKey.eq(a, b);
            }

            private static boolean eq(Object a, Object b) {
                if (a == b) {
                    return true;
                }
                if (a == null) {
                    return false;
                }
                if (a.getClass().isArray()) {
                    return Arrays.equals((Object[])a, (Object[])b);
                }
                return a.equals(b);
            }

            public int hashCode() {
                return this.hashCode;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MixInMethodInvoker
    implements MethodInvoker {
        private Object proxy;
        private Object instance;
        private final Class<?> mixInClass;
        private final MethodInvoker next;
        private final ThreadLocal<MethodInvocation> current = new ThreadLocal();

        public MixInMethodInvoker(Class<?> mixInClass, MethodInvoker next) {
            this.mixInClass = mixInClass;
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(MethodInvocation invocation) throws Throwable {
            if (this.current.get() != null) {
                return;
            }
            if (this.instance == null) {
                this.instance = DirectInstantiator.INSTANCE.newInstance(this.mixInClass, this.proxy);
            }
            MethodInvocation beanInvocation = new MethodInvocation(invocation.getName(), invocation.getReturnType(), invocation.getGenericReturnType(), invocation.getParameterTypes(), this.instance, invocation.getParameters());
            this.current.set(beanInvocation);
            try {
                this.next.invoke(beanInvocation);
            }
            finally {
                this.current.set(null);
            }
            if (beanInvocation.found()) {
                invocation.setResult(beanInvocation.getResult());
            }
        }

        public void setProxy(Object proxy) {
            this.proxy = proxy;
        }

        public Object getProxy() {
            return this.proxy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoOpMapping
    implements Action<SourceObjectMapping>,
    Serializable {
        private NoOpMapping() {
        }

        @Override
        public void execute(SourceObjectMapping mapping) {
        }
    }

    private static class PropertyCachingMethodInvoker
    implements MethodInvoker {
        private final Map<String, Object> properties = new HashMap<String, Object>();
        private final Set<String> unknown = new HashSet<String>();
        private final MethodInvoker next;

        private PropertyCachingMethodInvoker(MethodInvoker next) {
            this.next = next;
        }

        public void invoke(MethodInvocation method) throws Throwable {
            if (method.isGetter()) {
                if (this.properties.containsKey(method.getName())) {
                    method.setResult(this.properties.get(method.getName()));
                    return;
                }
                if (this.unknown.contains(method.getName())) {
                    return;
                }
                this.next.invoke(method);
                if (!method.found()) {
                    this.unknown.add(method.getName());
                    return;
                }
                Object value = method.getResult();
                this.properties.put(method.getName(), value);
                return;
            }
            this.next.invoke(method);
        }
    }

    private static class ReflectionMethodInvoker
    implements MethodInvoker {
        private static final MethodInvocationCache LOOKUP_CACHE = new MethodInvocationCache();

        private ReflectionMethodInvoker() {
        }

        public void invoke(MethodInvocation invocation) throws Throwable {
            Object returnValue;
            Method targetMethod = ReflectionMethodInvoker.locateMethod(invocation);
            if (targetMethod == null) {
                return;
            }
            try {
                returnValue = targetMethod.invoke(invocation.getDelegate(), invocation.getParameters());
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            invocation.setResult(returnValue);
        }

        private static Method locateMethod(MethodInvocation invocation) {
            return LOOKUP_CACHE.get(invocation);
        }
    }

    private static class SafeMethodInvoker
    implements MethodInvoker {
        private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
        private final MethodInvoker next;

        private SafeMethodInvoker(MethodInvoker next) {
            this.next = next;
        }

        public void invoke(MethodInvocation invocation) throws Throwable {
            this.next.invoke(invocation);
            if (invocation.found() || invocation.getParameterTypes().length != 1) {
                return;
            }
            if (!invocation.isIsOrGet()) {
                return;
            }
            MethodInvocation getterInvocation = new MethodInvocation(invocation.getName(), invocation.getReturnType(), invocation.getGenericReturnType(), EMPTY_CLASS_ARRAY, invocation.getDelegate(), EMPTY);
            this.next.invoke(getterInvocation);
            if (getterInvocation.found() && getterInvocation.getResult() != null) {
                invocation.setResult(getterInvocation.getResult());
            } else {
                invocation.setResult(invocation.getParameters()[0]);
            }
        }
    }

    private static class SupportedPropertyInvoker
    implements MethodInvoker {
        private final MethodInvoker next;

        private SupportedPropertyInvoker(MethodInvoker next) {
            this.next = next;
        }

        public void invoke(MethodInvocation invocation) throws Throwable {
            Matcher matcher = IS_SUPPORT_METHOD.matcher(invocation.getName());
            if (!matcher.matches()) {
                this.next.invoke(invocation);
                return;
            }
            String getterName = String.format("get%s", matcher.group(1));
            MethodInvocation getterInvocation = new MethodInvocation(getterName, invocation.getReturnType(), invocation.getGenericReturnType(), new Class[0], invocation.getDelegate(), EMPTY);
            this.next.invoke(getterInvocation);
            invocation.setResult(getterInvocation.found());
        }
    }
}

