/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.view.TreeViewerState;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public final class ToggleShowTreeHeaderAction
extends Action {
    private final TreeViewer treeViewer;
    private final TreeViewerState treeViewerState;

    public ToggleShowTreeHeaderAction(TreeViewer treeViewer, TreeViewerState treeViewerState) {
        super(null, 2);
        this.treeViewer = (TreeViewer)Preconditions.checkNotNull((Object)treeViewer);
        this.treeViewerState = (TreeViewerState)Preconditions.checkNotNull((Object)treeViewerState);
        this.setText(UiMessages.Action_ShowTreeHeader_Text);
        this.setChecked(this.treeViewerState.isShowTreeHeader());
        this.updateHeaderVisibility();
    }

    public void run() {
        this.treeViewerState.setShowTreeHeader(this.isChecked());
        this.updateHeaderVisibility();
    }

    private void updateHeaderVisibility() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Tree tree = ToggleShowTreeHeaderAction.this.treeViewer.getTree();
                tree.setHeaderVisible(ToggleShowTreeHeaderAction.this.treeViewerState.isShowTreeHeader());
            }
        });
    }
}

