/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.TaskView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public final class WorkbenchSelectionListener
implements ISelectionListener {
    private final TaskView taskView;

    public WorkbenchSelectionListener(TaskView taskView) {
        this.taskView = (TaskView)Preconditions.checkNotNull((Object)taskView);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection structuredSelection;
        if (this.taskView.getState().isLinkToSelection() && part != this.taskView && selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
            this.selectionChanged(structuredSelection);
        }
    }

    private void selectionChanged(IStructuredSelection structuredSelection) {
        ImmutableList<IProject> projects = this.convertToProjects((List<Object>)ImmutableList.copyOf((Object[])structuredSelection.toArray()));
        this.selectProjectsInTree((List<IProject>)projects);
    }

    private ImmutableList<IProject> convertToProjects(List<Object> selections) {
        return FluentIterable.from(selections).transform((Function)new Function<Object, IProject>(){

            public IProject apply(Object input) {
                if (input instanceof IProject) {
                    return (IProject)input;
                }
                if (input instanceof IJavaElement) {
                    return ((IJavaElement)input).getJavaProject().getProject();
                }
                if (input instanceof IResource) {
                    return ((IResource)input).getProject();
                }
                return null;
            }
        }).filter(Predicates.notNull()).toList();
    }

    private void selectProjectsInTree(List<IProject> projects) {
        ImmutableList.Builder selection = ImmutableList.builder();
        Tree tree = this.taskView.getTreeViewer().getTree();
        for (TreeItem treeItem : tree.getItems()) {
            ProjectNode selectedNode;
            Optional<IProject> workspaceProject;
            Object data = treeItem.getData();
            if (data == null || !(data instanceof ProjectNode) || !(workspaceProject = (selectedNode = (ProjectNode)data).getWorkspaceProject()).isPresent() || !projects.contains(workspaceProject.get())) continue;
            selection.add((Object)treeItem);
        }
        ImmutableList treeSelection = selection.build();
        tree.setSelection((TreeItem[])treeSelection.toArray((Object[])new TreeItem[treeSelection.size()]));
    }
}

