/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import com.gradleware.tooling.toolingmodel.OmniTaskSelector;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;

public final class TaskGroupNode {
    private static final String DEFAULT_NAME = "other";
    private final List<TaskNode> taskNodes;
    private final ProjectNode projectNode;
    private final String name;

    public static TaskGroupNode getDefault(ProjectNode projectNode) {
        return new TaskGroupNode(projectNode, DEFAULT_NAME);
    }

    public static TaskGroupNode forName(ProjectNode projectNode, Maybe<String> groupName) {
        Preconditions.checkNotNull(groupName);
        String name = null;
        if (groupName.isPresent()) {
            name = (String)groupName.get();
        }
        if (name == null) {
            name = DEFAULT_NAME;
        }
        return new TaskGroupNode(projectNode, name);
    }

    private TaskGroupNode(ProjectNode projectNode, String name) {
        this.projectNode = (ProjectNode)Preconditions.checkNotNull((Object)projectNode);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.taskNodes = this.createTaskNodes(projectNode);
    }

    private List<TaskNode> createTaskNodes(ProjectNode projectNode) {
        ArrayList taskNodes = Lists.newArrayList();
        for (OmniProjectTask projectTask : this.getProjectTasks()) {
            taskNodes.add(new ProjectTaskNode(projectNode, projectTask));
        }
        for (OmniTaskSelector taskSelector : this.getTaskSelectors()) {
            taskNodes.add(new TaskSelectorNode(projectNode, taskSelector));
        }
        return taskNodes;
    }

    private List<OmniProjectTask> getProjectTasks() {
        ArrayList projectTasks = Lists.newArrayList();
        for (OmniProjectTask projectTask : this.getProjectNode().getGradleProject().getProjectTasks()) {
            if (!this.contains(projectTask)) continue;
            projectTasks.add(projectTask);
        }
        return projectTasks;
    }

    private List<OmniTaskSelector> getTaskSelectors() {
        ArrayList taskSelectors = Lists.newArrayList();
        for (OmniTaskSelector taskSelector : this.getProjectNode().getGradleProject().getTaskSelectors()) {
            if (!this.contains(taskSelector)) continue;
            taskSelectors.add(taskSelector);
        }
        return taskSelectors;
    }

    public ProjectNode getProjectNode() {
        return this.projectNode;
    }

    public String getName() {
        return this.name;
    }

    public boolean contains(OmniProjectTask projectTask) {
        return this.matches((Maybe<String>)projectTask.getGroup());
    }

    public boolean contains(OmniTaskSelector taskSelector) {
        return this.matches((Maybe<String>)taskSelector.getGroup());
    }

    private boolean matches(Maybe<String> group) {
        if (!group.isPresent()) {
            return this.isDefault();
        }
        String name = (String)group.get();
        if (name == null) {
            return this.isDefault();
        }
        return name.equals(this.name);
    }

    public List<TaskNode> getTaskNodes() {
        return this.taskNodes;
    }

    private boolean isDefault() {
        return DEFAULT_NAME.equals(this.name);
    }

    public String toString() {
        return "Task group '" + this.name + "'";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TaskGroupNode that = (TaskGroupNode)other;
        return Objects.equal((Object)this.projectNode, (Object)that.projectNode) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectNode, this.name});
    }
}

