/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.repository.CompositeModelRepository;
import com.gradleware.tooling.toolingmodel.repository.Environment;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepositoryProvider;
import com.gradleware.tooling.toolingmodel.repository.SimpleModelRepository;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultCompositeModelRepository;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultSimpleModelRepository;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.Factory;

public final class DefaultModelRepositoryProvider
implements ModelRepositoryProvider {
    private final ToolingClient toolingClient;
    private final Environment environment;
    private final Factory<EventBus> eventBusFactory;
    private final Map<FixedRequestAttributes, SimpleModelRepository> modelRepositories;
    private final Map<Set<FixedRequestAttributes>, CompositeModelRepository> compositeModelRepositories;

    public DefaultModelRepositoryProvider(ToolingClient toolingClient) {
        this(toolingClient, Environment.STANDALONE);
    }

    public DefaultModelRepositoryProvider(ToolingClient toolingClient, Environment environment) {
        this(toolingClient, environment, DefaultEventBusFactory.INSTANCE);
    }

    public DefaultModelRepositoryProvider(ToolingClient toolingClient, Environment environment, Factory<EventBus> eventBusFactory) {
        this.toolingClient = (ToolingClient)Preconditions.checkNotNull((Object)toolingClient);
        this.environment = (Environment)((Object)Preconditions.checkNotNull((Object)((Object)environment)));
        this.eventBusFactory = (Factory)Preconditions.checkNotNull(eventBusFactory);
        this.modelRepositories = Maps.newHashMap();
        this.compositeModelRepositories = Maps.newHashMap();
    }

    @Override
    public SimpleModelRepository getModelRepository(FixedRequestAttributes fixedRequestAttributes) {
        Preconditions.checkNotNull((Object)fixedRequestAttributes);
        return this.getOrCreateModelRepository(fixedRequestAttributes);
    }

    @Override
    public CompositeModelRepository getCompositeModelRepository(Set<FixedRequestAttributes> fixedRequestAttributes) {
        return this.getOrCreateCompositeModelRepository(fixedRequestAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleModelRepository getOrCreateModelRepository(FixedRequestAttributes fixedRequestAttributes) {
        SimpleModelRepository modelRepository;
        Map<FixedRequestAttributes, SimpleModelRepository> map = this.modelRepositories;
        synchronized (map) {
            if (!this.modelRepositories.containsKey(fixedRequestAttributes)) {
                modelRepository = new DefaultSimpleModelRepository(fixedRequestAttributes, this.toolingClient, (EventBus)this.eventBusFactory.create(), this.environment);
                this.modelRepositories.put(fixedRequestAttributes, modelRepository);
            } else {
                modelRepository = this.modelRepositories.get(fixedRequestAttributes);
            }
        }
        return modelRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeModelRepository getOrCreateCompositeModelRepository(Set<FixedRequestAttributes> fixedRequestAttributes) {
        CompositeModelRepository modelRepository;
        Map<Set<FixedRequestAttributes>, CompositeModelRepository> map = this.compositeModelRepositories;
        synchronized (map) {
            if (!this.compositeModelRepositories.containsKey(fixedRequestAttributes)) {
                modelRepository = new DefaultCompositeModelRepository(this, fixedRequestAttributes, this.toolingClient, (EventBus)this.eventBusFactory.create());
                this.compositeModelRepositories.put(fixedRequestAttributes, modelRepository);
            } else {
                modelRepository = this.compositeModelRepositories.get(fixedRequestAttributes);
            }
        }
        return modelRepository;
    }

    private static enum DefaultEventBusFactory implements Factory<EventBus>
    {
        INSTANCE;


        public EventBus create() {
            return new EventBus();
        }
    }
}

