/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf.pkg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.odf.pkg.ImageEntry;
import org.eclipse.birt.report.engine.odf.pkg.Package;

public class ImageManager {
    private static final String IMAGE_PREFIX = "Pictures/";
    private static final Map<String, String> MIME_TO_EXTENSION;
    private static final Map<String, String> EXTENSION_TO_MIME;
    private Package pkg;
    private int lastId;
    private Map<String, ImageEntry> images;

    static {
        HashMap<String, String> mimeToExtension = new HashMap<String, String>();
        mimeToExtension.put("image/gif", "gif");
        mimeToExtension.put("image/x-png", "png");
        mimeToExtension.put("image/png", "png");
        mimeToExtension.put("application/jpeg", "jpg");
        mimeToExtension.put("image/jpeg", "jpeg");
        mimeToExtension.put("image/tiff", "tif");
        mimeToExtension.put("image/x-ms-bmp", "bmp");
        mimeToExtension.put("image/svg+xml", "svg");
        HashMap<String, String> extensionToMime = new HashMap<String, String>();
        for (Map.Entry ext : mimeToExtension.entrySet()) {
            extensionToMime.put((String)ext.getValue(), (String)ext.getKey());
        }
        MIME_TO_EXTENSION = Collections.unmodifiableMap(mimeToExtension);
        EXTENSION_TO_MIME = Collections.unmodifiableMap(extensionToMime);
    }

    public ImageManager(Package pkg) {
        this.pkg = pkg;
        this.images = new HashMap<String, ImageEntry>();
        this.lastId = 0;
    }

    public ImageEntry addImage(byte[] data, String extension) throws IOException {
        String fileName = this.generateFileName(extension, null);
        String contentType = null;
        contentType = extension != null ? EXTENSION_TO_MIME.get(extension.substring(1)) : EXTENSION_TO_MIME.get(fileName.substring(fileName.lastIndexOf(46) + 1));
        ImageEntry entry = new ImageEntry(this.pkg, fileName, contentType, null, extension);
        this.processEntry(entry, data);
        return entry;
    }

    public ImageEntry addImage(String uri, String contentType, String imageExtension) throws IOException {
        String fileName;
        ImageEntry entry = this.images.get(uri);
        if (entry != null) {
            return entry;
        }
        if (imageExtension == null) {
            imageExtension = "." + ImageManager.getImageExtension(uri);
        }
        if (this.processEntry(entry = new ImageEntry(this.pkg, fileName = this.generateFileName(imageExtension, contentType), contentType, uri, imageExtension), entry.getImage().getData())) {
            this.images.put(uri, entry);
        }
        return entry;
    }

    public ImageEntry addImage(IImageContent image) throws IOException {
        ImageEntry entry = this.images.get(image.getURI());
        if (entry != null) {
            return entry;
        }
        String fileName = this.generateFileName(image.getExtension(), image.getMIMEType());
        entry = new ImageEntry(this.pkg, fileName, image.getMIMEType(), image);
        if (this.processEntry(entry, entry.getImage().getData())) {
            this.images.put(image.getURI(), entry);
        }
        return entry;
    }

    private boolean processEntry(ImageEntry entry, byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return false;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream out = entry.getOutputStream();){
            out.write(data);
            this.pkg.addEntry(entry);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return false;
    }

    private String generateFileName(String imageExtension, String contentType) {
        if (imageExtension == null && contentType != null) {
            imageExtension = "." + MIME_TO_EXTENSION.get(contentType);
        }
        if (imageExtension == null) {
            imageExtension = ".jpg";
        }
        String id = String.valueOf(this.generateId()) + imageExtension;
        return IMAGE_PREFIX + id;
    }

    private String generateId() {
        ++this.lastId;
        return "Image" + this.lastId;
    }

    public static String getImageExtension(String imageURI) {
        String rectifiedImageURI = imageURI.replace('.', '&');
        String extension = imageURI.substring(rectifiedImageURI.lastIndexOf(38) + 1).toLowerCase();
        if (extension.equals("svg")) {
            extension = "jpg";
        }
        return extension;
    }
}

