/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDLocation;
import org.eclipse.birt.report.designer.internal.ui.dnd.DNDService;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.GuiExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.IExtension;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportCreationTool;
import org.eclipse.birt.report.designer.internal.ui.palette.BasePaletteFactory;
import org.eclipse.birt.report.designer.internal.ui.palette.PaletteCategory;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportCombinedTemplateCreationEntry;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportElementFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;

public class DesignerPaletteFactory
extends BasePaletteFactory {
    private static final String ELEMENT_NAME_TEXT = Messages.getString((String)"DesignerPaletteFactory.elementName.text");
    private static final String ELEMENT_NAME_TEXTDATA = Messages.getString((String)"DesignerPaletteFactory.elementName.textdata");
    private static final String ELEMENT_NAME_LABEL = Messages.getString((String)"DesignerPaletteFactory.elementName.label");
    private static final String ELEMENT_NAME_DATA = Messages.getString((String)"DesignerPaletteFactory.elementName.data");
    private static final String ELEMENT_NAME_IMAGE = Messages.getString((String)"DesignerPaletteFactory.elementName.image");
    private static final String ELEMENT_NAME_GRID = Messages.getString((String)"DesignerPaletteFactory.elementName.grid");
    private static final String ELEMENT_NAME_LIST = Messages.getString((String)"DesignerPaletteFactory.elementName.list");
    private static final String ELEMENT_NAME_TABLE = Messages.getString((String)"DesignerPaletteFactory.elementName.table");
    private static final String TOOL_TIP_TEXT_REPORT_ITEM = Messages.getString((String)"DesignerPaletteFactory.toolTip.textReportItem");
    private static final String TOOL_TIP_TEXTDATA_REPORT_ITEM = Messages.getString((String)"DesignerPaletteFactory.toolTip.textDataReportItem");
    private static final String TOOL_TIP_LABEL_REPORT_ITEM = Messages.getString((String)"DesignerPaletteFactory.toolTip.labelReportItem");
    private static final String TOOL_TIP_DATA_REPORT_ITEM = Messages.getString((String)"DesignerPaletteFactory.toolTip.dataReportItem");
    private static final String TOOL_TIP_IMAGE_REPORT_ITEM = Messages.getString((String)"DesignerPaletteFactory.toolTip.imageReportItem");
    private static final String TOOL_TIP_GRID_REPORT_ITEM = Messages.getString((String)"DesignerPaletteFactory.toolTip.gridReportItem");
    private static final String TOOL_TIP_LIST_REPORT_ITEM = Messages.getString((String)"DesignerPaletteFactory.toolTip.listReportItem");
    private static final String TOOL_TIP_TABLE_REPORT_ITEM = Messages.getString((String)"DesignerPaletteFactory.toolTip.tableReportItem");
    private static final String REPORT_ITEMS_LABEL = Messages.getString((String)"DesignerPaletteFactory.categoryName.reportItems");
    public static final String AGG_TEMPLATE = "DATA_AGG";
    public static final String TIMEPERIOD_TEMPLATE = "DATA_TIMEPERIOD";

    public static PaletteRoot createPalette() {
        PaletteRoot root = BasePaletteFactory.createPalette();
        root.addAll(DesignerPaletteFactory.createCategories());
        IExtension.Stub extension = new IExtension.Stub(){

            @Override
            public String getExtendsionIdentify() {
                return "pallet_designer";
            }
        };
        GuiExtensionManager.doExtension(extension, root);
        root.add((PaletteEntry)DesignerPaletteFactory.createQuickTools());
        return root;
    }

    private static PaletteContainer createQuickTools() {
        PaletteCategory quickTools = new PaletteCategory("Content", Messages.getString((String)"DesignerPaletteFactory.quicktool.title"), ReportPlatformUIImages.getImageDescriptor("IMG_OBJ_FOLDER"));
        ReportElementFactory factory = new ReportElementFactory(AGG_TEMPLATE);
        QuickToolsCombinedTemplateCreationEntry combined = new QuickToolsCombinedTemplateCreationEntry(Messages.getString((String)"DesignerPaletteFactory.quicktool.agg.title"), Messages.getString((String)"DesignerPaletteFactory.quicktool.agg.toolTip"), AGG_TEMPLATE, factory, ReportPlatformUIImages.getImageDescriptor("aggregation"), ReportPlatformUIImages.getImageDescriptor("aggregation_LARGE"));
        quickTools.add((PaletteEntry)combined);
        factory = new ReportElementFactory(TIMEPERIOD_TEMPLATE);
        combined = new QuickToolsCombinedTemplateCreationEntry(Messages.getString((String)"DesignerPaletteFactory.quicktool.timeperiod.title"), Messages.getString((String)"DesignerPaletteFactory.quicktool.timeperiod.toolTip"), TIMEPERIOD_TEMPLATE, factory, ReportPlatformUIImages.getImageDescriptor("relativetime"), ReportPlatformUIImages.getImageDescriptor("relativetime_LARGE"));
        quickTools.add((PaletteEntry)combined);
        return quickTools;
    }

    protected static List createCategories() {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(DesignerPaletteFactory.createContentCategory());
        return categories;
    }

    private static PaletteContainer createContentCategory() {
        PaletteCategory category = new PaletteCategory("Content", REPORT_ITEMS_LABEL, ReportPlatformUIImages.getImageDescriptor("IMG_OBJ_FOLDER"));
        ArrayList<ReportCombinedTemplateCreationEntry> entries = new ArrayList<ReportCombinedTemplateCreationEntry>();
        ReportCombinedTemplateCreationEntry combined = new ReportCombinedTemplateCreationEntry(ELEMENT_NAME_LABEL, TOOL_TIP_LABEL_REPORT_ITEM, "Label", new ReportElementFactory("Label"), ReportPlatformUIImages.getImageDescriptor("Label"), ReportPlatformUIImages.getImageDescriptor("Label_LARGE"), DesignerPaletteFactory.getAbstractToolHandleExtendsFromPaletteName("Label"));
        entries.add(combined);
        combined = new ReportCombinedTemplateCreationEntry(ELEMENT_NAME_TEXT, TOOL_TIP_TEXT_REPORT_ITEM, "Text", new ReportElementFactory("Text"), ReportPlatformUIImages.getImageDescriptor("Text"), ReportPlatformUIImages.getImageDescriptor("Text_LARGE"), DesignerPaletteFactory.getAbstractToolHandleExtendsFromPaletteName("Text"));
        entries.add(combined);
        combined = new ReportCombinedTemplateCreationEntry(ELEMENT_NAME_TEXTDATA, TOOL_TIP_TEXTDATA_REPORT_ITEM, "TextData", new ReportElementFactory("TextData"), ReportPlatformUIImages.getImageDescriptor("TextData"), ReportPlatformUIImages.getImageDescriptor("TextData_LARGE"), DesignerPaletteFactory.getAbstractToolHandleExtendsFromPaletteName("TextData"));
        entries.add(combined);
        combined = new ReportCombinedTemplateCreationEntry(ELEMENT_NAME_DATA, TOOL_TIP_DATA_REPORT_ITEM, "Data", new ReportElementFactory("Data"), ReportPlatformUIImages.getImageDescriptor("Data"), ReportPlatformUIImages.getImageDescriptor("Data_LARGE"), DesignerPaletteFactory.getAbstractToolHandleExtendsFromPaletteName("Data"));
        entries.add(combined);
        combined = new ReportCombinedTemplateCreationEntry(ELEMENT_NAME_IMAGE, TOOL_TIP_IMAGE_REPORT_ITEM, "Image", new ReportElementFactory("Image"), ReportPlatformUIImages.getImageDescriptor("Image"), ReportPlatformUIImages.getImageDescriptor("Image_LARGE"), DesignerPaletteFactory.getAbstractToolHandleExtendsFromPaletteName("Image"));
        entries.add(combined);
        combined = new ReportCombinedTemplateCreationEntry(ELEMENT_NAME_GRID, TOOL_TIP_GRID_REPORT_ITEM, "Grid", new ReportElementFactory("Grid"), ReportPlatformUIImages.getImageDescriptor("Grid"), ReportPlatformUIImages.getImageDescriptor("Grid_LARGE"), DesignerPaletteFactory.getAbstractToolHandleExtendsFromPaletteName("Grid"));
        entries.add(combined);
        combined = new ReportCombinedTemplateCreationEntry(ELEMENT_NAME_LIST, TOOL_TIP_LIST_REPORT_ITEM, "List", new ReportElementFactory("List"), ReportPlatformUIImages.getImageDescriptor("List"), ReportPlatformUIImages.getImageDescriptor("List_LARGE"), DesignerPaletteFactory.getAbstractToolHandleExtendsFromPaletteName("List"));
        entries.add(combined);
        combined = new ReportCombinedTemplateCreationEntry(ELEMENT_NAME_TABLE, TOOL_TIP_TABLE_REPORT_ITEM, "Table", new ReportElementFactory("Table"), ReportPlatformUIImages.getImageDescriptor("Table"), ReportPlatformUIImages.getImageDescriptor("Table_LARGE"), DesignerPaletteFactory.getAbstractToolHandleExtendsFromPaletteName("Table"));
        entries.add(combined);
        category.addAll(entries);
        return category;
    }

    private static class QuickToolsCombinedTemplateCreationEntry
    extends CombinedTemplateCreationEntry {
        public QuickToolsCombinedTemplateCreationEntry(String label, String shortDesc, Object template, CreationFactory factory, ImageDescriptor iconSmall, ImageDescriptor iconLarge) {
            super(label, shortDesc, template, factory, iconSmall, iconLarge);
        }

        public Tool createTool() {
            return new ReportCreationTool(this.factory, null){

                @Override
                protected void performCreation(int button) {
                    DNDService.getInstance().performDrop(this.getTemplate(), this.getTargetEditPart(), 16, new DNDLocation(this.getLocation()));
                }

                @Override
                public void performCreation(EditPart editPart) {
                    DNDService.getInstance().performDrop(this.getTemplate(), editPart, 16, new DNDLocation(this.getLocation()));
                }

                @Override
                protected boolean handleMove() {
                    this.updateTargetUnderMouse();
                    boolean canMove = DNDService.getInstance().validDrop(this.getTemplate(), this.getTargetEditPart(), 16, new DNDLocation(this.getLocation()));
                    if (canMove) {
                        this.updateTargetRequest();
                        this.setCurrentCommand(this.getCommand());
                        this.showTargetFeedback();
                    } else {
                        this.setCurrentCommand(null);
                    }
                    return canMove;
                }
            };
        }
    }
}

