/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.internal.impl;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.eclipse.birt.data.oda.mongodb.impl.MongoDBDriver;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbMetaData;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class QueryProperties {
    private static final String MONGO_PROP_PREFIX = "";
    private static final String COLLECTION_NAME_PROP = "".concat("collectionName");
    private static final String QUERY_OPERATION_TYPE_PROP = "".concat("operationType");
    private static final String QUERY_OPERATION_EXPR_PROP = "".concat("operationExpr");
    private static final String SELECTED_FIELDS_PROP = "".concat("selectedFields");
    private static final String FIND_QUERY_EXPR_PROP = "".concat("findQueryExpr");
    private static final String SORT_EXPR_PROP = "".concat("sortExpr");
    private static final String QUERY_READ_PREF_PROP = "".concat("queryReadPreference");
    private static final String QUERY_READ_PREF_TAGS_PROP = "".concat("queryReadPreferenceTags");
    private static final String RT_META_DATA_SEARCH_LIMIT = "".concat("rtMDSearchLimit");
    private static final String CURSOR_BATCH_SIZE_PROP = "".concat("batchSize");
    private static final String SKIP_NUM_DOCS_PROP = "".concat("numSkipDocuments");
    private static final String AUTO_FLATTENING_PROP = "".concat("flattenCollections");
    private static final String INDEX_HINTS_PROP = "".concat("indexHints");
    private static final String NO_TIMEOUT_PROP = "".concat("noTimeOut");
    private static final String PARTIAL_RESULTS_PROP = "".concat("allowsPartialResults");
    public static final int DEFAULT_RUNTIME_METADATA_SEARCH_LIMIT = 10;
    public static final int DEFAULT_CURSOR_BATCH_SIZE = 101;
    private static final String DOC_ID_FIELD_NAME = "_id";
    private static final String ARRAY_BEGIN_MARKER = "[";
    private static final String ARRAY_END_MARKER = "]";
    private static final Map<String, Object> sm_defaultPropsMap = new QueryProperties().getPropertiesMap();
    private Map<String, Object> m_propertiesMap;

    public QueryProperties(String collectionName) {
        this.setCollectionName(collectionName);
    }

    QueryProperties(Map<String, Object> propertiesMap) {
        this.setValues(propertiesMap);
    }

    private QueryProperties() {
        this.setDefaultValues();
    }

    public static QueryProperties defaultValues() {
        return new QueryProperties(sm_defaultPropsMap);
    }

    static QueryProperties copy(QueryProperties fromProps) {
        if (fromProps == null) {
            return null;
        }
        return new QueryProperties(fromProps.getPropertiesMap());
    }

    public static QueryProperties deserialize(String serializedContent) throws OdaException {
        if (serializedContent == null || serializedContent.trim().isEmpty()) {
            return new QueryProperties(null);
        }
        Exception caughtEx = null;
        try {
            DBObject parsedObj = QueryProperties.parseExprToDBObject(serializedContent);
            if (parsedObj instanceof Map) {
                return new QueryProperties((Map)parsedObj);
            }
        }
        catch (Exception ex) {
            caughtEx = ex;
        }
        OdaException odaEx = new OdaException(Messages.bind((String)Messages.queryProperties_errDeSerializeDBObject, (Object)serializedContent));
        if (caughtEx != null) {
            odaEx.initCause((Throwable)caughtEx);
        }
        throw odaEx;
    }

    public String serialize() {
        Map<String, Object> definedPropsMap = QueryProperties.copyNonDefaultProperties(this.getPropertiesMap());
        QueryProperties.externalizePropValues(definedPropsMap);
        return JSON.serialize(definedPropsMap);
    }

    private void setDefaultValues() {
        this.setOperationType(CommandOperationType.DYNAMIC_QUERY);
        this.setQueryReadPreference(MongoDBDriver.ReadPreferenceChoice.DEFAULT_PREFERENCE);
        this.setRuntimeMetaDataSearchLimit(10);
        this.setBatchSize(101);
        this.setNumDocsToSkip(0);
        this.setAutoFlattening(false);
        this.setNoTimeOut(false);
        this.setPartialResultsOk(true);
    }

    private static Object getDefaultPropValue(String propKey) {
        return sm_defaultPropsMap.get(propKey);
    }

    private void setValues(Map<String, Object> propertiesMap) {
        if (propertiesMap == null || propertiesMap.isEmpty()) {
            return;
        }
        this.setInternalProperties(propertiesMap);
    }

    void setNonNullValues(Map<String, Object> propertiesMap) {
        Map<String, Object> nonNullPropsMap = QueryProperties.copyNonNullProperties(propertiesMap);
        this.setInternalProperties(nonNullPropsMap);
    }

    private void setInternalProperties(Map<String, Object> propertiesMap) {
        this.getPropertiesMap().putAll(propertiesMap);
        this.internalizePropValues();
    }

    private void internalizePropValues() {
        Object propValue = this.getPropertiesMap().get(QUERY_READ_PREF_PROP);
        if (propValue instanceof String) {
            this.setQueryReadPreference((String)propValue);
        }
        if ((propValue = this.getPropertiesMap().get(QUERY_OPERATION_TYPE_PROP)) instanceof String) {
            this.setOperationType((String)propValue);
        }
    }

    private static void externalizePropValues(Map<String, Object> propertiesMap) {
        Object propValue = propertiesMap.get(QUERY_READ_PREF_PROP);
        if (propValue instanceof ReadPreference) {
            propertiesMap.put(QUERY_READ_PREF_PROP, ((ReadPreference)propValue).getName());
        }
        if ((propValue = propertiesMap.get(QUERY_OPERATION_TYPE_PROP)) instanceof CommandOperationType) {
            propertiesMap.put(QUERY_OPERATION_TYPE_PROP, propValue.toString());
        }
    }

    private static Map<String, Object> copyNonNullProperties(Map<String, Object> propertiesMap) {
        if (propertiesMap == null || propertiesMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> propsCopy = new HashMap<String, Object>(propertiesMap.size());
        for (Map.Entry<String, Object> propEntry : propertiesMap.entrySet()) {
            Object propValue = propEntry.getValue();
            if (propValue == null) continue;
            propsCopy.put(propEntry.getKey(), propValue);
        }
        return propsCopy;
    }

    private static Map<String, Object> copyNonDefaultProperties(Map<String, Object> propertiesMap) {
        if (propertiesMap == null || propertiesMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> propsCopy = new HashMap<String, Object>(propertiesMap.size());
        for (Map.Entry<String, Object> propEntry : propertiesMap.entrySet()) {
            Object propValue = propEntry.getValue();
            if (propValue == null) continue;
            String propKey = propEntry.getKey();
            Object defaultValue = QueryProperties.getDefaultPropValue(propKey);
            if (propValue instanceof String) {
                if (((String)propValue).isEmpty()) continue;
                if (defaultValue instanceof Boolean || defaultValue instanceof Integer || defaultValue instanceof ReadPreference) {
                    defaultValue = defaultValue.toString();
                }
            }
            if (propValue.equals(defaultValue)) continue;
            propsCopy.put(propKey, propValue);
        }
        return propsCopy;
    }

    Map<String, Object> getPropertiesMap() {
        if (this.m_propertiesMap == null) {
            this.m_propertiesMap = new HashMap<String, Object>();
        }
        return this.m_propertiesMap;
    }

    public void setCollectionName(String collectionName) {
        this.getPropertiesMap().put(COLLECTION_NAME_PROP, collectionName);
    }

    public String getCollectionName() {
        return this.getStringPropOrEmptyValue(COLLECTION_NAME_PROP);
    }

    public void setOperationType(String opTypeLiteral) {
        this.setOperationType(CommandOperationType.getType(opTypeLiteral.trim()));
    }

    public void setOperationType(CommandOperationType opType) {
        this.getPropertiesMap().put(QUERY_OPERATION_TYPE_PROP, (Object)opType);
    }

    public CommandOperationType getOperationType() {
        CommandOperationType value = QueryProperties.getOperationTypeImpl(this.getPropertiesMap());
        if (value == null) {
            value = QueryProperties.getOperationTypeImpl(sm_defaultPropsMap);
        }
        return value;
    }

    private static CommandOperationType getOperationTypeImpl(Map<String, Object> propMap) {
        Object propValue = propMap.get(QUERY_OPERATION_TYPE_PROP);
        if (propValue instanceof CommandOperationType) {
            return (CommandOperationType)((Object)propValue);
        }
        if (propValue instanceof String) {
            return CommandOperationType.getType(((String)propValue).trim());
        }
        return null;
    }

    public boolean hasValidCommandOperation() {
        return this.hasAggregateCommand() || this.hasMapReduceCommand() || this.hasRunCommand();
    }

    public boolean hasAggregateCommand() {
        return this.hasValidCommand(CommandOperationType.AGGREGATE);
    }

    public boolean hasMapReduceCommand() {
        return this.hasValidCommand(CommandOperationType.MAP_REDUCE);
    }

    public boolean hasRunCommand() {
        return this.hasValidCommand(CommandOperationType.RUN_DB_COMMAND);
    }

    private boolean hasValidCommand(CommandOperationType opType) {
        if (this.getOperationType() != opType) {
            return false;
        }
        return !this.getOperationExpression().isEmpty();
    }

    public void setOperationExpression(String opExpr) {
        this.getPropertiesMap().put(QUERY_OPERATION_EXPR_PROP, opExpr);
    }

    public String getOperationExpression() {
        return this.getStringPropOrEmptyValue(QUERY_OPERATION_EXPR_PROP);
    }

    DBObject getOperationExprAsParsedObject(boolean addArrayMarkers) throws OdaException {
        String cmdOpExprText = this.getOperationExpression();
        if (cmdOpExprText.isEmpty()) {
            return null;
        }
        if (addArrayMarkers) {
            cmdOpExprText = QueryProperties.addArrayMarkers(cmdOpExprText);
        }
        return QueryProperties.parseExprToDBObject(cmdOpExprText);
    }

    static String addArrayMarkers(String expr) {
        if (!expr.startsWith(ARRAY_BEGIN_MARKER) && !expr.endsWith(ARRAY_END_MARKER)) {
            StringBuilder strBldr = new StringBuilder(expr.length() + 2);
            strBldr.append(ARRAY_BEGIN_MARKER).append(expr).append(ARRAY_END_MARKER);
            return strBldr.toString();
        }
        return expr;
    }

    static Document getDocument(BasicDBObject dbObject) {
        return Document.parse((String)dbObject.toJson());
    }

    static List<Document> getObjectsAsDocumentList(DBObject exprObj) {
        if (exprObj == null) {
            return null;
        }
        ArrayList<Document> documentList = new ArrayList<Document>();
        if (exprObj instanceof BasicDBList) {
            BasicDBList dbList = (BasicDBList)exprObj;
            for (Object obj : dbList) {
                List<Document> childrenList;
                if (obj instanceof DBObject) {
                    documentList.add(QueryProperties.getDocument((BasicDBObject)obj));
                    continue;
                }
                if (!(obj instanceof BasicDBList) || (childrenList = QueryProperties.getObjectsAsDocumentList((DBObject)obj)) == null) continue;
                documentList.addAll(childrenList);
            }
        } else if (exprObj instanceof DBObject) {
            documentList.add(QueryProperties.getDocument((BasicDBObject)exprObj));
        }
        return documentList;
    }

    static DBObject getFirstObjectSet(DBObject exprObj) {
        if (exprObj == null) {
            return null;
        }
        DBObject firstObj = null;
        if (exprObj instanceof BasicDBList) {
            BasicDBList objList = (BasicDBList)exprObj;
            if (objList.size() >= 1) {
                Object value = objList.get(0);
                if (value instanceof DBObject) {
                    firstObj = (DBObject)value;
                } else {
                    QueryProperties.logInvalidTagValue(value);
                }
            }
        } else {
            firstObj = exprObj;
        }
        return firstObj;
    }

    static DBObject[] getSecondaryObjectSets(DBObject exprObj) {
        if (!(exprObj instanceof BasicDBList)) {
            return null;
        }
        BasicDBList objList = (BasicDBList)exprObj;
        if (objList.size() <= 1) {
            return null;
        }
        ArrayList<DBObject> secondaryObjList = new ArrayList<DBObject>(objList.size() - 1);
        int i = 1;
        while (i < objList.size()) {
            Object value = objList.get(i);
            if (value instanceof DBObject) {
                secondaryObjList.add((DBObject)value);
            } else {
                QueryProperties.logInvalidTagValue(value);
            }
            ++i;
        }
        if (secondaryObjList.isEmpty()) {
            return null;
        }
        return secondaryObjList.toArray(new DBObject[secondaryObjList.size()]);
    }

    private static final void logInvalidTagValue(Object tagValue) {
        QueryProperties.getLogger().info(Messages.bind((String)"Ignoring the tag value ({0}).  A Read Preference Tag Set must be specified as a document.", (Object)tagValue));
    }

    public void setSelectedFields(List<MDbMetaData.FieldMetaData> selectedFields) {
        ArrayList<String> fieldNames = new ArrayList<String>(selectedFields.size());
        for (MDbMetaData.FieldMetaData fieldMd : selectedFields) {
            fieldNames.add(fieldMd.getFullName());
        }
        this.setSelectedFieldNames(fieldNames);
    }

    private void setSelectedFieldNames(List<String> selectedFieldList) {
        this.getPropertiesMap().put(SELECTED_FIELDS_PROP, selectedFieldList);
    }

    public List<String> getSelectedFieldNames() {
        Object propValue = this.getPropertiesMap().get(SELECTED_FIELDS_PROP);
        if (propValue instanceof List) {
            return (List)propValue;
        }
        if (propValue instanceof String) {
            DBObject projectionKeys = null;
            try {
                projectionKeys = QueryProperties.parseExprToDBObject((String)propValue);
            }
            catch (OdaException ex) {
                QueryProperties.getLogger().log(Level.INFO, Messages.bind((String)"Ignoring invalid Selected Fields expression: {0}", (Object)propValue), ex);
                return Collections.emptyList();
            }
            ArrayList<String> selectedFieldNames = new ArrayList<String>(projectionKeys.keySet().size());
            for (String key : projectionKeys.keySet()) {
                Object value = projectionKeys.get(key);
                if (value instanceof Integer ? (Integer)value == 0 : value instanceof Boolean && (Boolean)value == Boolean.FALSE) continue;
                selectedFieldNames.add(key);
            }
            return selectedFieldNames;
        }
        return Collections.emptyList();
    }

    BasicDBObject getSelectedFieldsAsProjectionKeys() throws OdaException {
        Object propValue = this.getPropertiesMap().get(SELECTED_FIELDS_PROP);
        if (propValue instanceof List) {
            BasicDBObject keys = new BasicDBObject();
            List fieldNames = (List)propValue;
            for (String field : fieldNames) {
                keys.append(field, (Object)1);
            }
            if (!keys.containsField(DOC_ID_FIELD_NAME)) {
                keys.append(DOC_ID_FIELD_NAME, (Object)0);
            }
            return keys;
        }
        if (propValue instanceof String) {
            DBObject projectObj = QueryProperties.parseExprToDBObject((String)propValue);
            if (!(projectObj instanceof BasicDBObject)) {
                throw new OdaException(Messages.bind((String)"Unexpected data type ({0}) in {1}", (Object)projectObj.getClass().getSimpleName(), (Object)SELECTED_FIELDS_PROP));
            }
            return (BasicDBObject)projectObj;
        }
        if (propValue != null) {
            QueryProperties.getLogger().log(Level.INFO, Messages.bind((String)"Unexpected data type ({0}) in Selected Fields property value.", (Object)propValue.getClass().getName()));
        }
        return new BasicDBObject();
    }

    public void setQueryReadPreference(String readPrefLiteral) {
        ReadPreference readPref = QueryProperties.toReadPreference(readPrefLiteral);
        this.setQueryReadPreference(readPref);
    }

    public void setQueryReadPreference(ReadPreference readPref) {
        this.getPropertiesMap().put(QUERY_READ_PREF_PROP, readPref);
    }

    public ReadPreference getQueryReadPreference() {
        Object propValue = this.getPropertiesMap().get(QUERY_READ_PREF_PROP);
        if (propValue instanceof String) {
            propValue = QueryProperties.toReadPreference((String)propValue);
        }
        if (propValue instanceof ReadPreference) {
            return (ReadPreference)propValue;
        }
        return MongoDBDriver.ReadPreferenceChoice.DEFAULT_PREFERENCE;
    }

    private static ReadPreference toReadPreference(String readPrefChoiceLiteral) {
        return MongoDBDriver.ReadPreferenceChoice.getMongoReadPreference(readPrefChoiceLiteral);
    }

    public void setQueryReadPreferenceTags(String tagsExpr) {
        this.getPropertiesMap().put(QUERY_READ_PREF_TAGS_PROP, tagsExpr);
    }

    public String getQueryReadPreferenceTags() {
        return this.getStringPropOrEmptyValue(QUERY_READ_PREF_TAGS_PROP);
    }

    DBObject getReadPreferenceTagsAsParsedObject() {
        String tagsExpr = this.getQueryReadPreferenceTags();
        if (tagsExpr.isEmpty()) {
            return null;
        }
        try {
            return QueryProperties.parseExprToDBObject(tagsExpr);
        }
        catch (OdaException ex) {
            QueryProperties.getLogger().log(Level.INFO, Messages.bind((String)"Ignoring invalid Read Preference Tags expression: {0}", (Object)tagsExpr), ex);
            return null;
        }
    }

    private static TagSet toTags(DBObject tagsDocument) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        for (String key : tagsDocument.keySet()) {
            tagList.add(new Tag(key, tagsDocument.get(key).toString()));
        }
        return new TagSet(tagList);
    }

    ReadPreference getTaggableReadPreference() {
        ReadPreference readPref = this.getQueryReadPreference();
        if (readPref == ReadPreference.primary()) {
            return readPref;
        }
        DBObject tagObjects = this.getReadPreferenceTagsAsParsedObject();
        if (tagObjects == null) {
            return readPref;
        }
        ArrayList<TagSet> tagsList = new ArrayList<TagSet>();
        if (tagObjects instanceof BasicDBList) {
            BasicDBList tagObjectList = (BasicDBList)tagObjects;
            for (Object obj : tagObjectList) {
                if (obj instanceof DBObject) {
                    tagsList.add(QueryProperties.toTags((DBObject)obj));
                    continue;
                }
                QueryProperties.logInvalidTagValue(obj);
            }
        } else {
            tagsList.add(QueryProperties.toTags(tagObjects));
        }
        if (tagsList.size() == 0) {
            return readPref;
        }
        try {
            return ReadPreference.valueOf((String)readPref.getName(), tagsList);
        }
        catch (RuntimeException ex) {
            QueryProperties.getLogger().info(ex.getLocalizedMessage());
            return readPref;
        }
    }

    public void setRuntimeMetaDataSearchLimit(Integer searchLimit) {
        this.getPropertiesMap().put(RT_META_DATA_SEARCH_LIMIT, searchLimit);
    }

    public Integer getRuntimeMetaDataSearchLimit() {
        return this.getIntPropOrDefaultValue(RT_META_DATA_SEARCH_LIMIT);
    }

    public boolean hasRuntimeMetaDataSearchLimit() {
        return QueryProperties.hasIntPropertyValue(this.getPropertiesMap(), RT_META_DATA_SEARCH_LIMIT);
    }

    public void setBatchSize(Integer batchSize) {
        this.getPropertiesMap().put(CURSOR_BATCH_SIZE_PROP, batchSize);
    }

    public Integer getBatchSize() {
        return this.getIntPropOrDefaultValue(CURSOR_BATCH_SIZE_PROP);
    }

    public boolean hasBatchSize() {
        return QueryProperties.hasIntPropertyValue(this.getPropertiesMap(), CURSOR_BATCH_SIZE_PROP);
    }

    public void setNumDocsToSkip(Integer numDocsToSkip) {
        this.getPropertiesMap().put(SKIP_NUM_DOCS_PROP, numDocsToSkip);
    }

    public Integer getNumDocsToSkip() {
        return this.getIntPropOrDefaultValue(SKIP_NUM_DOCS_PROP);
    }

    public boolean hasNumDocsToSkip() {
        return QueryProperties.hasIntPropertyValue(this.getPropertiesMap(), SKIP_NUM_DOCS_PROP);
    }

    public void setAutoFlattening(Boolean isAutoFlattening) {
        this.getPropertiesMap().put(AUTO_FLATTENING_PROP, isAutoFlattening);
    }

    public boolean isAutoFlattening() {
        return this.getBooleanPropOrDefaultValue(AUTO_FLATTENING_PROP);
    }

    public void setIndexHints(String indexHints) {
        this.getPropertiesMap().put(INDEX_HINTS_PROP, indexHints);
    }

    public String getIndexHints() {
        return this.getStringPropOrEmptyValue(INDEX_HINTS_PROP);
    }

    DBObject getIndexHintsAsParsedObject() {
        String hintValue = this.getIndexHints();
        if (hintValue.isEmpty()) {
            return null;
        }
        try {
            return QueryProperties.parseExprToDBObject(hintValue);
        }
        catch (OdaException ex) {
            QueryProperties.getLogger().log(Level.INFO, Messages.bind((String)"Ignoring invalid Index Hint expression: {0}", (Object)hintValue), ex);
            return null;
        }
    }

    public void setNoTimeOut(Boolean hasNoTimeOut) {
        this.getPropertiesMap().put(NO_TIMEOUT_PROP, hasNoTimeOut);
    }

    public boolean hasNoTimeOut() {
        return this.getBooleanPropOrDefaultValue(NO_TIMEOUT_PROP);
    }

    public void setPartialResultsOk(Boolean isPartialResultsOk) {
        this.getPropertiesMap().put(PARTIAL_RESULTS_PROP, isPartialResultsOk);
    }

    public boolean isPartialResultsOk() {
        return this.getBooleanPropOrDefaultValue(PARTIAL_RESULTS_PROP);
    }

    public void setFindQueryExpr(String findQueryExpr) {
        this.getPropertiesMap().put(FIND_QUERY_EXPR_PROP, findQueryExpr);
    }

    public String getFindQueryExpr() {
        return this.getStringPropOrEmptyValue(FIND_QUERY_EXPR_PROP);
    }

    BasicDBObject getFindQueryExprAsParsedObject() throws OdaException {
        String queryExprText = this.getFindQueryExpr();
        if (queryExprText.isEmpty()) {
            return null;
        }
        DBObject queryObj = QueryProperties.parseExprToDBObject(queryExprText);
        if (!(queryObj instanceof BasicDBObject)) {
            throw new OdaException(Messages.bind((String)"Unexpected data type ({0}) in {1}", (Object)queryObj.getClass().getSimpleName(), (Object)FIND_QUERY_EXPR_PROP));
        }
        return (BasicDBObject)queryObj;
    }

    public void setSortExpr(String sortExpr) {
        this.getPropertiesMap().put(SORT_EXPR_PROP, sortExpr);
    }

    public String getSortExpr() {
        return this.getStringPropOrEmptyValue(SORT_EXPR_PROP);
    }

    BasicDBObject getSortExprAsParsedObject() throws OdaException {
        String sortExprText = this.getSortExpr();
        if (sortExprText.isEmpty()) {
            return null;
        }
        DBObject sortObj = QueryProperties.parseExprToDBObject(sortExprText);
        if (!(sortObj instanceof BasicDBObject)) {
            throw new OdaException(Messages.bind((String)"Unexpected data type ({0}) in {1}", (Object)sortObj.getClass().getSimpleName(), (Object)SORT_EXPR_PROP));
        }
        return (BasicDBObject)sortObj;
    }

    private String getStringPropOrEmptyValue(String propName) {
        String value = QueryProperties.getStringPropertyValue(this.getPropertiesMap(), propName);
        return value != null ? value : MONGO_PROP_PREFIX;
    }

    private static String getStringPropertyValue(Map<String, Object> propertiesMap, String propertyName) {
        Object propValue = propertiesMap.get(propertyName);
        return propValue instanceof String ? ((String)propValue).trim() : null;
    }

    private Boolean getBooleanPropOrDefaultValue(String propName) {
        Boolean value = QueryProperties.getBooleanPropertyValue(this.getPropertiesMap(), propName);
        if (value == null) {
            value = QueryProperties.getBooleanPropertyValue(sm_defaultPropsMap, propName);
        }
        return value;
    }

    private static Boolean getBooleanPropertyValue(Map<String, Object> propertiesMap, String propertyName) {
        Object propValue = propertiesMap.get(propertyName);
        if (propValue instanceof Boolean) {
            return (Boolean)propValue;
        }
        if (propValue instanceof String && !((String)propValue).isEmpty()) {
            return Boolean.valueOf((String)propValue);
        }
        return null;
    }

    private Integer getIntPropOrDefaultValue(String propName) {
        Integer value = QueryProperties.getIntPropertyValue(this.getPropertiesMap(), propName);
        if (value == null) {
            value = QueryProperties.getIntPropertyValue(sm_defaultPropsMap, propName);
        }
        return value;
    }

    private static Integer getIntPropertyValue(Map<String, Object> propertiesMap, String propertyName) {
        Object propValue = propertiesMap.get(propertyName);
        try {
            if (propValue instanceof Integer) {
                return (Integer)propValue;
            }
            if (propValue instanceof String && !((String)propValue).isEmpty()) {
                return Integer.valueOf((String)propValue);
            }
        }
        catch (NumberFormatException ex) {
            QueryProperties.getLogger().log(Level.INFO, Messages.bind((String)"Invalid integer value ({0}) found in the {1} property.", (Object)propValue, (Object)propertyName), ex);
        }
        return null;
    }

    private static boolean hasIntPropertyValue(Map<String, Object> propertiesMap, String propertyName) {
        return QueryProperties.getIntPropertyValue(propertiesMap, propertyName) != null;
    }

    private static final DBObject parseExprToDBObject(String jsonExpr) throws OdaException {
        return DriverUtil.parseExprToDBObject(jsonExpr);
    }

    private static final Logger getLogger() {
        return DriverUtil.getLogger();
    }

    public static enum CommandOperationType {
        DYNAMIC_QUERY,
        AGGREGATE,
        MAP_REDUCE,
        RUN_DB_COMMAND;


        public static CommandOperationType getType(String operationTypeLiteral) {
            if (operationTypeLiteral == null || operationTypeLiteral.isEmpty()) {
                return DYNAMIC_QUERY;
            }
            if (operationTypeLiteral.equals(AGGREGATE.displayName()) || operationTypeLiteral.equals(AGGREGATE.name())) {
                return AGGREGATE;
            }
            if (operationTypeLiteral.equals(MAP_REDUCE.displayName()) || operationTypeLiteral.equals(MAP_REDUCE.name())) {
                return MAP_REDUCE;
            }
            if (operationTypeLiteral.equals(RUN_DB_COMMAND.displayName()) || operationTypeLiteral.equals(RUN_DB_COMMAND.name())) {
                return RUN_DB_COMMAND;
            }
            return DYNAMIC_QUERY;
        }

        public String displayName() {
            if (this == DYNAMIC_QUERY) {
                return QueryProperties.MONGO_PROP_PREFIX;
            }
            if (this == AGGREGATE) {
                return Messages.queryProperties_aggrCmdName;
            }
            if (this == MAP_REDUCE) {
                return Messages.queryProperties_mapReduceCmdName;
            }
            if (this == RUN_DB_COMMAND) {
                return Messages.queryProperties_dbCmdName;
            }
            return QueryProperties.MONGO_PROP_PREFIX;
        }
    }
}

