/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.validation.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.app4mc.validation.core.IProfile;
import org.eclipse.app4mc.validation.util.CachedProfile;
import org.eclipse.app4mc.validation.util.ProfileManager;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.jface.dialogs.IDialogSettings;

public class ProfileDialogSettings {
    private static final String KEY_SELECTED_PROFILE_CLASSES = "Validation_SelectedProfileClasses";
    private static final String KEY_SELECTED_SCOPE = "Validation_SelectedScope";
    public static final String SCOPE_SELECTION = "Selection";
    public static final String SCOPE_FILE = "File";
    public static final String SCOPE_FOLDER = "Folder";
    private Set<String> selectedProfileClassNames = new HashSet<String>();
    private String scope = "Folder";
    private boolean dialogSuccess = false;
    private List<Class<? extends IProfile>> dialogResults = null;
    private ProfileManager profileManager;

    @Inject
    @Optional
    public void setProfileManager(@Service ProfileManager manager) {
        this.profileManager = manager;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean isDialogSuccess() {
        return this.dialogSuccess;
    }

    public void setDialogSuccess(boolean dialogSuccess) {
        this.dialogSuccess = dialogSuccess;
    }

    public List<Class<? extends IProfile>> getDialogResults() {
        return this.dialogResults;
    }

    public void setDialogResults(List<Class<? extends IProfile>> dialogResults) {
        this.dialogResults = dialogResults;
    }

    public Object[] getProfiles() {
        return this.profileManager.getRegisteredValidationProfiles().values().stream().sorted(Comparator.comparing(CachedProfile::getName)).toArray();
    }

    public List<CachedProfile> getInitialSelection() {
        ArrayList<CachedProfile> allNodes = new ArrayList<CachedProfile>();
        for (CachedProfile rootNode : this.profileManager.getRegisteredValidationProfiles().values()) {
            allNodes.add(rootNode);
            this.collectSubNodes(rootNode, allNodes);
        }
        Map<Object, List<CachedProfile>> filteredNodesMap = allNodes.stream().filter(cache -> this.selectedProfileClassNames.contains(cache.getProfileClass().getName())).collect(Collectors.groupingBy(cache -> cache.getProfileClass().getName()));
        ArrayList<CachedProfile> result = new ArrayList<CachedProfile>();
        for (List<CachedProfile> list : filteredNodesMap.values()) {
            result.add(this.getRepresentative(list));
        }
        return result;
    }

    private void collectSubNodes(CachedProfile profile, List<CachedProfile> list) {
        if (!profile.getCachedProfiles().isEmpty()) {
            for (CachedProfile subProfile : profile.getCachedProfiles().values()) {
                list.add(subProfile);
                this.collectSubNodes(subProfile, list);
            }
        }
    }

    private CachedProfile getRepresentative(List<CachedProfile> profileList) {
        if (profileList.isEmpty()) {
            return null;
        }
        CachedProfile selectedProfile = profileList.get(0);
        int selectedLevel = this.getLevel(selectedProfile);
        int i = 1;
        while (i < profileList.size()) {
            CachedProfile tmpProfile = profileList.get(i);
            int tmpLevel = this.getLevel(tmpProfile);
            if (tmpLevel < selectedLevel) {
                selectedProfile = tmpProfile;
                selectedLevel = tmpLevel;
            }
            ++i;
        }
        return selectedProfile;
    }

    private int getLevel(CachedProfile profile) {
        if (profile == null) {
            return -1;
        }
        int level = 0;
        CachedProfile parent = profile.getParentProfile();
        while (parent != null) {
            ++level;
            parent = parent.getParentProfile();
        }
        return level;
    }

    public void setSelectedProfileClassNames(List<String> classNames) {
        this.selectedProfileClassNames.clear();
        this.selectedProfileClassNames.addAll(classNames);
    }

    public void loadFrom(IDialogSettings store) {
        String selectedScope;
        if (store == null) {
            return;
        }
        String[] classNames = store.getArray(KEY_SELECTED_PROFILE_CLASSES);
        if (classNames != null) {
            this.setSelectedProfileClassNames(List.of(classNames));
        }
        if ((selectedScope = store.get(KEY_SELECTED_SCOPE)) != null) {
            this.setScope(selectedScope);
        }
    }

    public void saveTo(IDialogSettings store) {
        if (store == null || !this.dialogSuccess || this.dialogResults == null) {
            return;
        }
        String[] classNames = (String[])this.dialogResults.stream().map(Class::getName).toArray(String[]::new);
        store.put(KEY_SELECTED_PROFILE_CLASSES, classNames);
        store.put(KEY_SELECTED_SCOPE, this.scope);
    }
}

