/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.inchron.hw;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.PortType;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="Inchron-HW-PU-PortTypeInitiator", checks={"HW ports of processing Unit should be of type initiator"})
public class InchronHWPUPortTypeCheck
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getProcessingUnit();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        EObject eObject2 = eObject;
        if (eObject2 instanceof ProcessingUnit) {
            void puCore;
            ProcessingUnit processingUnit = (ProcessingUnit)eObject2;
            ProcessingUnit cfr_ignored_0 = (ProcessingUnit)eObject2;
            EList listPorts = puCore.getPorts();
            for (HwPort port : listPorts) {
                if (port.getPortType() == PortType.INITIATOR) continue;
                this.addIssue(results, (EObject)puCore, (EStructuralFeature)ePackage.getHwModule_Ports(), "Processing Unit " + this.name((INamed)puCore) + " has a HW port " + this.name((INamed)port) + " of type not equal to INITIATOR");
            }
        }
    }
}

