/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.runnabledependency;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;

public class RunnableDependencyConfig {
    private static final String HORIZONTAL_LAYOUT_KEY = "HorizontalLayout";
    private static final String HORIZONTAL_LAYOUT_DEFAULT = "true";
    private static final String SHOW_CALL_DEPENDENCIES_KEY = "ShowCallDependencies";
    private static final String SHOW_CALL_DEPENDENCIES_DEFAULT = "true";
    private static final String SHOW_LABEL_DEPENDENCIES_KEY = "ShowLabelDependencies";
    private static final String SHOW_LABEL_DEPENDENCIES_DEFAULT = "true";
    private static final String SHOW_LABELS_KEY = "ShowLabels";
    private static final String SHOW_LABELS_DEFAULT = "true";
    private static final String SHOW_TASKS_KEY = "ShowTasks";
    private static final String SHOW_TASKS_DEFAULT = "true";
    private static final String SCALE_KEY = "Scale";
    private static final String SCALE_DEFAULT = "80";
    private final VisualizationParameters parameters;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public RunnableDependencyConfig(VisualizationParameters viewParameters) {
        this.parameters = viewParameters;
    }

    public boolean isHorizontalLayout() {
        return Boolean.parseBoolean(this.parameters.getOrDefault((Object)HORIZONTAL_LAYOUT_KEY, "true"));
    }

    public void setHorizontalLayout(boolean horizontal) {
        this.parameters.put(HORIZONTAL_LAYOUT_KEY, Boolean.toString(horizontal));
        this.firePropertyChange("parameter1", null, horizontal);
    }

    public boolean isShowCallDependencies() {
        return Boolean.parseBoolean(this.parameters.getOrDefault((Object)SHOW_CALL_DEPENDENCIES_KEY, "true"));
    }

    public void setShowCallDependencies(boolean showCallDependencies) {
        this.parameters.put(SHOW_CALL_DEPENDENCIES_KEY, Boolean.toString(showCallDependencies));
        this.firePropertyChange("parameter2", null, showCallDependencies);
    }

    public boolean isShowLabelDependencies() {
        return Boolean.parseBoolean(this.parameters.getOrDefault((Object)SHOW_LABEL_DEPENDENCIES_KEY, "true"));
    }

    public void setShowLabelDependencies(boolean showLabelDependencies) {
        this.parameters.put(SHOW_LABEL_DEPENDENCIES_KEY, Boolean.toString(showLabelDependencies));
        this.firePropertyChange("parameter3", null, showLabelDependencies);
    }

    public boolean isShowLabels() {
        return Boolean.parseBoolean(this.parameters.getOrDefault((Object)SHOW_LABELS_KEY, "true"));
    }

    public void setShowLabels(boolean showLabels) {
        this.parameters.put(SHOW_LABELS_KEY, Boolean.toString(showLabels));
        this.firePropertyChange("parameter4", null, showLabels);
    }

    public boolean isShowTasks() {
        return Boolean.parseBoolean(this.parameters.getOrDefault((Object)SHOW_TASKS_KEY, "true"));
    }

    public void setShowTasks(boolean showTasks) {
        this.parameters.put(SHOW_TASKS_KEY, Boolean.toString(showTasks));
        this.firePropertyChange("parameter5", null, showTasks);
    }

    public int getScale() {
        return Integer.parseInt(this.parameters.getOrDefault((Object)SCALE_KEY, SCALE_DEFAULT));
    }

    public boolean setScale(int newScale) {
        int oldScale = this.getScale();
        if (oldScale == newScale || newScale < 10 || newScale > 200) {
            return false;
        }
        this.parameters.put(SCALE_KEY, Integer.toString(newScale));
        this.firePropertyChange("scale", oldScale, newScale);
        return true;
    }

    public boolean decrementScale() {
        return this.setScale(Math.max(10, this.getScale() - 10));
    }

    public boolean incrementScale() {
        return this.setScale(Math.min(200, this.getScale() + 10));
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

