/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.search;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.editor.search.ModelSearchResult;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class SearchResultContentProvider
implements IStructuredContentProvider {
    private static final Object[] NO_OBJECTS = new Object[0];
    private ModelSearchResult searchResult;
    private Object[] elements = NO_OBJECTS;

    public void dispose() {
    }

    public void clear() {
        this.elements = NO_OBJECTS;
    }

    /*
     * WARNING - void declaration
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clear();
        Object object = newInput;
        if (object instanceof ModelSearchResult) {
            void result;
            ModelSearchResult modelSearchResult = (ModelSearchResult)((Object)object);
            ModelSearchResult cfr_ignored_0 = (ModelSearchResult)((Object)object);
            this.searchResult = result;
            this.elements = this.searchResult.getElements();
            Arrays.parallelSort(this.elements, new ObjectComparator());
        } else {
            this.searchResult = null;
        }
    }

    public void addElements(Object[] newElements) {
        if (newElements.length == 0) {
            return;
        }
        this.elements = this.concatenate(this.elements, newElements);
        Arrays.parallelSort(this.elements, new ObjectComparator());
    }

    private Object[] concatenate(Object[] a, Object[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = new Object[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != this.searchResult) {
            return NO_OBJECTS;
        }
        return this.elements;
    }

    private static class ObjectComparator
    implements Comparator<Object> {
        private ObjectComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            INamed n1 = (INamed)o1;
            INamed n2 = (INamed)o2;
            if (n1.getName() != null && n2.getName() != null) {
                return n1.getName().compareTo(n2.getName());
            }
            return 0;
        }
    }
}

