/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.standard.hardware;

import java.util.HashSet;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.HwConnection;
import org.eclipse.app4mc.amalthea.model.HwPort;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.PortType;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@Validation(id="AM-HW-Structure", checks={"Connections must only refer to contained HwPorts", "Inner connections always need one Initiator and one Responder HwPort", "Delegated connections always connect HwPorts of the same type"})
public class AmHwStructure
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getHwStructure();
    }

    /*
     * WARNING - void declaration
     */
    public void validate(EObject object, List<ValidationDiagnostic> results) {
        EObject eObject = object;
        if (eObject instanceof HwStructure) {
            void structure;
            HwStructure hwStructure = (HwStructure)eObject;
            HwStructure cfr_ignored_0 = (HwStructure)eObject;
            HashSet subModules = new HashSet(AmaltheaServices.getAllModules((HwStructure)structure));
            HashSet subStructures = new HashSet(structure.getStructures());
            for (HwConnection conn : structure.getConnections()) {
                boolean p1InnerPort = false;
                boolean p1OuterPort = false;
                boolean p2InnerPort = false;
                boolean p2OuterPort = false;
                HwPort port1 = conn.getPort1();
                HwPort port2 = conn.getPort2();
                if (port1 == null || port2 == null || port1 == port2) break;
                EObject container1 = port1.eContainer();
                if (subModules.contains(container1) || subStructures.contains(container1)) {
                    p1InnerPort = true;
                } else if (container1 == structure) {
                    p1OuterPort = true;
                }
                EObject container2 = port2.eContainer();
                if (subModules.contains(container2) || subStructures.contains(container2)) {
                    p2InnerPort = true;
                } else if (container2 == structure) {
                    p2OuterPort = true;
                }
                if (p1InnerPort && p2InnerPort || p1OuterPort && p2OuterPort) {
                    if ((port1.getPortType() != PortType.INITIATOR || port2.getPortType() != PortType.INITIATOR) && (port1.getPortType() != PortType.RESPONDER || port2.getPortType() != PortType.RESPONDER)) continue;
                    this.addIssue(results, (EObject)conn, (EStructuralFeature)ePackage.getHwConnection_Port1(), "HW Connection " + this.qualifiedName((IReferable)conn) + ": Port types do not fulfill initiator -> responder");
                    continue;
                }
                if ((!p1InnerPort || !p2OuterPort) && (!p1OuterPort || !p2InnerPort) || (port1.getPortType() != PortType.INITIATOR || port2.getPortType() != PortType.RESPONDER) && (port1.getPortType() != PortType.RESPONDER || port2.getPortType() != PortType.INITIATOR)) continue;
                this.addIssue(results, (EObject)conn, (EStructuralFeature)ePackage.getHwConnection_Port1(), "HW Connection " + this.qualifiedName((IReferable)conn) + ": Port types of delegate connection do not match");
            }
        }
    }
}

