/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.amalthea;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.AbstractEventChain;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.Event;
import org.eclipse.app4mc.amalthea.model.EventChainItem;
import org.eclipse.app4mc.amalthea.model.EventChainItemType;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.util.ConstraintsUtil;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.EntityProperty;
import org.eclipse.app4mc.atdb._import.amalthea.EventImporter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class EventChainImporter
implements IRunnableWithProgress {
    private final ATDBConnection con;
    private final Amalthea model;

    public EventChainImporter(ATDBConnection con, Amalthea model) {
        this.con = con;
        this.model = model;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        if (this.model.getConstraintsModel() != null) {
            List allECs = ConstraintsUtil.getAllAbstractEventChains((ConstraintsModel)this.model.getConstraintsModel());
            int eventChainCount = allECs.size();
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Importing event chains from AMALTHEA...", (int)eventChainCount);
            try {
                this.con.executeBatchUpdate(atdbCon -> {
                    String eventChainName;
                    for (EntityProperty ep : EntityProperty.eventChainProperties) {
                        atdbCon.insertProperty(ep.camelName, ep.type);
                    }
                    for (AbstractEventChain ec : allECs) {
                        eventChainName = ec.getName();
                        atdbCon.insertEventChain(eventChainName);
                    }
                    for (AbstractEventChain ec : allECs) {
                        eventChainName = ec.getName();
                        List<String> itemNames = ec.getItems().stream().map(EventChainItem::getEventChain).map(INamed::getName).toList();
                        atdbCon.insertEntityRefsPropertyValue(eventChainName, EntityProperty.EC_ITEMS.camelName, itemNames);
                        EventChainImporter.insertEventRefProp(atdbCon, eventChainName, EntityProperty.EC_STIMULUS.camelName, ec.getStimulus());
                        EventChainImporter.insertEventRefProp(atdbCon, eventChainName, EntityProperty.EC_RESPONSE.camelName, ec.getResponse());
                        if (ec.getItemType() == EventChainItemType.PARALLEL && ec.getMinItemsCompleted() > 0) {
                            atdbCon.insertPropertyValue(eventChainName, EntityProperty.EC_MIN_ITEMS_COMPLETED.camelName, (Object)ec.getMinItemsCompleted());
                        }
                        subMon.worked(1);
                    }
                });
            }
            catch (SQLException e) {
                throw new InvocationTargetException(e);
            }
            subMon.done();
        }
    }

    private static void insertEventRefProp(ATDBConnection atdbCon, String eventChainName, String propertyName, Event ev) throws SQLException {
        String eventName = ev.getName();
        String eventTypeName = EventImporter.getEventTypeName(ev).orElse("");
        String subjectEntityName = EventImporter.getEntityName(ev).orElse("");
        String sourceEntityName = EventImporter.getSourceEntityName(ev).orElse("");
        atdbCon.insertEventRefPropertyValue(eventChainName, propertyName, eventName, eventTypeName, subjectEntityName, sourceEntityName);
    }
}

