/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.RowObjectIndexHolder;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public final class SelectionUtils {
    private SelectionUtils() {
    }

    public static boolean noShiftOrControl(boolean withShiftMask, boolean withControlMask) {
        return !withShiftMask && !withControlMask;
    }

    public static boolean bothShiftAndControl(boolean withShiftMask, boolean withControlMask) {
        return withShiftMask && withControlMask;
    }

    public static boolean isControlOnly(boolean withShiftMask, boolean withControlMask) {
        return !withShiftMask && withControlMask;
    }

    public static boolean isShiftOnly(boolean withShiftMask, boolean withControlMask) {
        return withShiftMask && !withControlMask;
    }

    public static boolean isConsecutive(int[] pos) {
        Arrays.sort(pos);
        int i = 1;
        while (i < pos.length) {
            if (pos[i - 1] + 1 != pos[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean hasConsecutiveSelection(SelectionLayer selectionLayer) {
        if (selectionLayer == null) {
            return false;
        }
        int[] selectedColumnPositions = selectionLayer.getSelectedColumnPositions();
        if (selectedColumnPositions.length == 0) {
            return false;
        }
        Arrays.sort(selectedColumnPositions);
        Set<Range> selectedRowPositions = selectionLayer.getSelectedRowPositions();
        Range range = PositionUtil.joinConsecutiveRanges(selectedRowPositions);
        if (range == null) {
            return false;
        }
        int colPosIdx = 0;
        while (colPosIdx < selectedColumnPositions.length) {
            if (colPosIdx > 0 && selectedColumnPositions[colPosIdx - 1] + 1 != selectedColumnPositions[colPosIdx]) {
                return false;
            }
            int columnPosition = selectedColumnPositions[colPosIdx];
            int rowPositionIndex = range.start;
            while (rowPositionIndex < range.end) {
                if (!selectionLayer.isCellPositionSelected(columnPosition, rowPositionIndex)) {
                    return false;
                }
                ++rowPositionIndex;
            }
            ++colPosIdx;
        }
        return true;
    }

    public static ILayerCell getBottomRightCellInSelection(SelectionLayer selectionLayer) {
        if (selectionLayer == null) {
            return null;
        }
        int[] selectedColumnPositions = selectionLayer.getSelectedColumnPositions();
        Arrays.sort(selectedColumnPositions);
        Set<Range> selectedRowPositions = selectionLayer.getSelectedRowPositions();
        Range range = PositionUtil.joinConsecutiveRanges(selectedRowPositions);
        if (range == null) {
            return null;
        }
        int colPosIdx = 0;
        while (colPosIdx < selectedColumnPositions.length) {
            if (colPosIdx > 0 && selectedColumnPositions[colPosIdx - 1] + 1 != selectedColumnPositions[colPosIdx]) {
                return null;
            }
            int columnPosition = selectedColumnPositions[colPosIdx];
            int rowPositionIndex = range.start;
            while (rowPositionIndex < range.end) {
                if (!selectionLayer.isCellPositionSelected(columnPosition, rowPositionIndex)) {
                    return null;
                }
                ++rowPositionIndex;
            }
            ++colPosIdx;
        }
        int colPosition = selectedColumnPositions[selectedColumnPositions.length - 1];
        int rowPosition = range.end - 1;
        return selectionLayer.getCellByPosition(colPosition, rowPosition);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> getSelectedRowObjects(SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider, boolean fullySelectedRowsOnly) {
        ArrayList<RowObjectIndexHolder<T>> rows = new ArrayList<RowObjectIndexHolder<T>>();
        if (selectionLayer != null) {
            if (fullySelectedRowsOnly) {
                void var5_10;
                int[] nArray = selectionLayer.getFullySelectedRowPositions();
                int n = nArray.length;
                boolean n2 = false;
                while (var5_10 < n) {
                    int rowPosition = nArray[var5_10];
                    SelectionUtils.addToSelection(rows, rowPosition, selectionLayer, rowDataProvider);
                    ++var5_10;
                }
            } else {
                Set<Range> rowRanges = selectionLayer.getSelectedRowPositions();
                for (Range range : rowRanges) {
                    int rowPosition = range.start;
                    while (rowPosition < range.end) {
                        SelectionUtils.addToSelection(rows, rowPosition, selectionLayer, rowDataProvider);
                        ++rowPosition;
                    }
                }
            }
        }
        Collections.sort(rows);
        ArrayList rowObjects = new ArrayList(rows.size());
        for (RowObjectIndexHolder rowObjectIndexHolder : rows) {
            rowObjects.add(rowObjectIndexHolder.getRow());
        }
        return rowObjects;
    }

    private static <T> void addToSelection(List<RowObjectIndexHolder<T>> rows, int rowPosition, SelectionLayer selectionLayer, IRowDataProvider<T> rowDataProvider) {
        int rowIndex = selectionLayer.getRowIndexByPosition(rowPosition);
        if (rowIndex >= 0 && rowIndex < rowDataProvider.getRowCount()) {
            T rowObject = rowDataProvider.getRowObject(rowIndex);
            rows.add(new RowObjectIndexHolder<T>(rowIndex, rowObject));
        }
    }
}

