/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionProviderProxy
implements IPostSelectionProvider {
    private final ListenerList<ISelectionChangedListener> selectionListeners = new ListenerList();
    private final ListenerList<ISelectionChangedListener> postSelectionListeners = new ListenerList();
    private ISelectionProvider delegate;
    private final ISelectionChangedListener selectionListener = event -> {
        if (event.getSelectionProvider() == this.delegate) {
            this.fireSelectionChanged(event.getSelection());
        }
    };
    private final ISelectionChangedListener postSelectionListener = event -> {
        if (event.getSelectionProvider() == this.delegate) {
            this.firePostSelectionChanged(event.getSelection());
        }
    };

    public void setDelegate(ISelectionProvider newDelegate) {
        IPostSelectionProvider postSelectionProvider;
        if (this.delegate == newDelegate) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.removeSelectionChangedListener(this.selectionListener);
            ISelectionProvider iSelectionProvider = this.delegate;
            if (iSelectionProvider instanceof IPostSelectionProvider) {
                postSelectionProvider = (IPostSelectionProvider)iSelectionProvider;
                postSelectionProvider.removePostSelectionChangedListener(this.postSelectionListener);
            }
        }
        this.delegate = newDelegate;
        if (newDelegate != null) {
            newDelegate.addSelectionChangedListener(this.selectionListener);
            if (newDelegate instanceof IPostSelectionProvider) {
                postSelectionProvider = (IPostSelectionProvider)newDelegate;
                postSelectionProvider.addPostSelectionChangedListener(this.postSelectionListener);
            }
            this.fireSelectionChanged(newDelegate.getSelection());
            this.firePostSelectionChanged(newDelegate.getSelection());
        } else {
            this.fireSelectionChanged((ISelection)StructuredSelection.EMPTY);
            this.firePostSelectionChanged((ISelection)StructuredSelection.EMPTY);
        }
    }

    protected void fireSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.selectionListeners, selection);
    }

    protected void firePostSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(this.postSelectionListeners, selection);
    }

    private void fireSelectionChanged(ListenerList<ISelectionChangedListener> list, ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        list.forEach(listener -> listener.selectionChanged(event));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return this.delegate != null ? this.delegate.getSelection() : StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.delegate != null) {
            this.delegate.setSelection(selection);
        }
    }
}

