/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.dataimport.BlockTypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class ADPImporter
extends BlockTypeImporter {
    public ADPImporter(IFile typeFile) {
        super(typeFile);
    }

    public ADPImporter(InputStream inputStream, TypeLibrary typeLibrary) {
        super(inputStream, typeLibrary);
    }

    @Override
    protected CommonElementImporter.IChildHandler getBaseChildrenHandler() {
        return name -> {
            switch (name) {
                case "Identification": {
                    this.parseIdentification(this.getElement());
                    break;
                }
                case "VersionInfo": {
                    this.parseVersionInfo(this.getElement());
                    break;
                }
                case "CompilerInfo": {
                    this.getElement().setCompilerInfo(this.parseCompilerInfo());
                    break;
                }
                case "InterfaceList": {
                    this.getElement().setInterfaceList(this.getInterfaceListImporter().parseInterfaceList("InterfaceList"));
                    break;
                }
                case "Service": {
                    this.parseService(this.getElement());
                    break;
                }
                case "Attribute": {
                    this.parseGenericAttributeNode(this.getElement());
                    this.proceedToEndElementNamed("Attribute");
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    public AdapterType getElement() {
        return (AdapterType)super.getElement();
    }

    @Override
    public LibraryElement createRootModelElement() {
        AdapterType newType = LibraryElementFactory.eINSTANCE.createAdapterType();
        newType.setService(LibraryElementFactory.eINSTANCE.createService());
        return newType;
    }

    @Override
    protected String getStartElementName() {
        return "AdapterType";
    }
}

