/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.eval.EvaluatorInitializerException;
import org.eclipse.fordiac.ide.model.eval.value.AnyDerivedValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public final class StructValue
implements AnyDerivedValue,
Iterable<Value> {
    private final StructuredType type;
    private final Map<String, Variable<?>> members;

    public StructValue(StructuredType type) {
        this.type = type;
        this.members = type.getMemberVariables().stream().map(StructValue::initializeMember).collect(Collectors.toMap(Variable::getName, Function.identity(), (a, b) -> a, LinkedHashMap::new));
    }

    public StructValue(StructuredType type, Map<String, ?> values) {
        this.type = type;
        this.members = type.getMemberVariables().stream().map(member -> StructValue.initializeMember(member, values)).collect(Collectors.toMap(Variable::getName, Function.identity(), (a, b) -> a, LinkedHashMap::new));
    }

    public StructValue(StructValue value) {
        this.type = value.getType();
        this.members = value.getMembers().values().stream().map(VariableOperations::newVariable).collect(Collectors.toMap(Variable::getName, Function.identity(), (a, b) -> a, LinkedHashMap::new));
    }

    protected static Variable<?> initializeMember(VarDeclaration variable) {
        try {
            return VariableOperations.newVariable(variable);
        }
        catch (Exception e) {
            throw new EvaluatorInitializerException((INamedElement)variable, (Throwable)e);
        }
    }

    protected static Variable<?> initializeMember(VarDeclaration variable, Object value) {
        try {
            LibraryElement type = VariableOperations.evaluateResultType(variable);
            return VariableOperations.newVariable(variable.getName(), type, ValueOperations.wrapValue(value, type));
        }
        catch (Exception e) {
            throw new EvaluatorInitializerException((INamedElement)variable, (Throwable)e);
        }
    }

    protected static Variable<?> initializeMember(VarDeclaration member, Map<String, ?> values) {
        Object value = values.get(member.getName());
        return value != null ? StructValue.initializeMember(member, value) : StructValue.initializeMember(member);
    }

    public Variable<?> get(String key) {
        return this.members.get(key);
    }

    public int hashCode() {
        return this.members.values().stream().map(Variable::getValue).mapToInt(Objects::hashCode).sum();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructValue other = (StructValue)obj;
        return this.members.values().stream().allMatch(member -> Objects.equals(member.getValue(), other.get(member.getName()).getValue()));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean pretty) {
        return this.members.values().stream().map(member -> member.getName() + (pretty ? " := " : ":=") + member.toString(pretty)).collect(Collectors.joining(pretty ? ", " : ",", "(", ")"));
    }

    @Override
    public Iterator<Value> iterator() {
        return this.members.values().stream().sorted(Comparator.comparing(Variable::getName)).map(Variable::getValue).iterator();
    }

    public StructuredType getType() {
        return this.type;
    }

    public Map<String, Variable<?>> getMembers() {
        return this.members;
    }
}

