/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteWithCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeleteInterfaceCommand
extends Command
implements ScopedCommand {
    private final IInterfaceElement interfaceElement;
    private final InterfaceList parent;
    private final List<? extends IInterfaceElement> targetList;
    private final CompoundCommand cmds = new CompoundCommand();
    private int oldIndex;

    public DeleteInterfaceCommand(IInterfaceElement interfaceElement) {
        this.interfaceElement = DeleteInterfaceCommand.getTargetElement(Objects.requireNonNull(interfaceElement));
        this.parent = Objects.requireNonNull(interfaceElement.getInterfaceList(), "not in an interface list");
        this.targetList = DeleteInterfaceCommand.getTargetList(this.interfaceElement);
    }

    public void execute() {
        IInterfaceElement iInterfaceElement;
        VarDeclaration varDecl;
        this.handleWiths(this.interfaceElement);
        this.handleSubAppConnections(this.interfaceElement);
        IInterfaceElement iInterfaceElement2 = this.interfaceElement;
        if (iInterfaceElement2 instanceof VarDeclaration && (varDecl = (VarDeclaration)iInterfaceElement2).isInOutVar()) {
            this.handleWiths((IInterfaceElement)varDecl.getInOutVarOpposite());
            this.handleSubAppConnections((IInterfaceElement)varDecl.getInOutVarOpposite());
        }
        if ((iInterfaceElement = this.interfaceElement) instanceof AdapterDeclaration) {
            AdapterDeclaration adp = (AdapterDeclaration)iInterfaceElement;
            if (this.parent.getFBType() instanceof CompositeFBType) {
                this.cmds.add((Command)new DeleteFBNetworkElementCommand((FBNetworkElement)adp.getAdapterFB()));
            }
        }
        this.performDeletion();
        if (this.cmds.canExecute()) {
            this.cmds.execute();
        }
    }

    public void undo() {
        EList temp = (EList)this.targetList;
        temp.add(this.oldIndex, (Object)this.interfaceElement);
        if (this.cmds.canUndo()) {
            this.cmds.undo();
        }
    }

    public void redo() {
        this.targetList.remove(this.oldIndex);
        if (this.cmds.canRedo()) {
            this.cmds.redo();
        }
    }

    private void performDeletion() {
        this.oldIndex = this.targetList.indexOf(this.interfaceElement);
        this.targetList.remove(this.oldIndex);
    }

    protected void handleSubAppConnections(IInterfaceElement ie) {
        for (Connection con : ie.getInputConnections()) {
            this.cmds.add((Command)new DeleteConnectionCommand(con));
        }
        for (Connection con : ie.getOutputConnections()) {
            this.cmds.add((Command)new DeleteConnectionCommand(con));
        }
    }

    protected void handleWiths(IInterfaceElement ie) {
        block3: {
            block2: {
                if (!(ie instanceof VarDeclaration)) break block2;
                VarDeclaration varDecl = (VarDeclaration)ie;
                for (With with : varDecl.getWiths()) {
                    this.cmds.add((Command)new DeleteWithCommand(with));
                }
                break block3;
            }
            if (!(ie instanceof Event)) break block3;
            Event event = (Event)ie;
            for (With with : event.getWith()) {
                this.cmds.add((Command)new DeleteWithCommand(with));
            }
        }
    }

    public InterfaceList getParent() {
        return this.parent;
    }

    public IInterfaceElement getInterfaceElement() {
        return this.interfaceElement;
    }

    private static IInterfaceElement getTargetElement(IInterfaceElement ie) {
        VarDeclaration varDecl;
        if (ie instanceof VarDeclaration && (varDecl = (VarDeclaration)ie).isInOutVar() && !varDecl.isIsInput()) {
            return varDecl.getInOutVarOpposite();
        }
        return ie;
    }

    private static List<? extends IInterfaceElement> getTargetList(IInterfaceElement ie) {
        InterfaceList il = ie.getInterfaceList();
        if (ie instanceof ErrorMarkerInterface) {
            return il.getErrorMarker();
        }
        if (ie.isIsInput()) {
            if (ie instanceof Event) {
                return il.getEventInputs();
            }
            if (ie instanceof AdapterDeclaration) {
                return il.getSockets();
            }
            if (ie instanceof VarDeclaration) {
                VarDeclaration varDecl = (VarDeclaration)ie;
                if (varDecl.isInOutVar()) {
                    return il.getInOutVars();
                }
                return il.getInputVars();
            }
        } else {
            if (ie instanceof Event) {
                return il.getEventOutputs();
            }
            if (ie instanceof AdapterDeclaration) {
                return il.getPlugs();
            }
            if (ie instanceof VarDeclaration) {
                return il.getOutputVars();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        if (this.parent.eContainer() != null) {
            return Set.of(this.parent.eContainer());
        }
        return Set.of(this.parent);
    }
}

