/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.utils;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class ExportFilterUtil {
    public static final String FILTER_ID = "id";
    private static final String SORT_INDEX = "sortIndex";
    private static final IConfigurationElement[] filters = ExportFilterUtil.getAvailableExportFilters();

    public static Optional<IConfigurationElement> getExportFilter(String id) {
        return Stream.of(filters).filter(expf -> expf.getAttribute(FILTER_ID).equals(id)).findFirst();
    }

    public static IConfigurationElement[] getExportFilters() {
        return filters;
    }

    private static IConfigurationElement[] getAvailableExportFilters() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor("org.eclipse.fordiac.ide.export.exportFilter");
        return (IConfigurationElement[])Stream.of(elems).sorted((o1, o2) -> {
            try {
                int sortIndex1 = Integer.parseInt(o1.getAttribute(SORT_INDEX));
                int sortIndex2 = Integer.parseInt(o2.getAttribute(SORT_INDEX));
                return sortIndex1 - sortIndex2;
            }
            catch (NumberFormatException e2) {
                FordiacLogHelper.logError((String)e2.getMessage(), (Throwable)e2);
                return 0;
            }
        }).toArray(IConfigurationElement[]::new);
    }

    private ExportFilterUtil() {
        throw new UnsupportedOperationException();
    }
}

