/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.interactors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.AbstractDelegatingDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;

public class SharedWatchDeviceManagementInteractor
extends AbstractDelegatingDeviceManagementInteractor {
    private final Map<String, Map<String, Integer>> watches = new HashMap<String, Map<String, Integer>>();

    public SharedWatchDeviceManagementInteractor(IDeviceManagementInteractor delegate) {
        super(delegate);
    }

    @Override
    public boolean addWatch(Resource resource, String name) throws DeploymentException {
        Map<String, Integer> resourceWatches = this.getResourceWatches(resource);
        Integer count = resourceWatches.get(name);
        if (count != null) {
            resourceWatches.put(name, count + 1);
        } else if (super.addWatch(resource, name)) {
            resourceWatches.put(name, 1);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean removeWatch(Resource resource, String name) throws DeploymentException {
        Map<String, Integer> resourceWatches = this.getResourceWatches(resource);
        Integer count = resourceWatches.get(name);
        if (count != null && count > 1) {
            resourceWatches.put(name, count - 1);
        } else if (super.removeWatch(resource, name)) {
            resourceWatches.remove(name);
        } else {
            return false;
        }
        return true;
    }

    protected Map<String, Integer> getResourceWatches(Resource resource) {
        return this.watches.computeIfAbsent(resource.getName(), unused -> new HashMap());
    }
}

