/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.st;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.debug.st.STLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.st.STLaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.debug.ui.MainLaunchConfigurationTab;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionSource;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.util.STFunctionParseUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class STLaunchConfigurationTab
extends MainLaunchConfigurationTab {
    private static final String FILE_EXTENSION = "stfunc";
    private ComboViewer functionCombo;

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite functionComponent = this.createFunctionComponent((Composite)this.getControl());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)functionComponent);
        Composite argumentsComponent = this.createArgumentsComponent((Composite)this.getControl());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)argumentsComponent);
    }

    protected Composite createFunctionComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText("Function");
        Composite comp = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        this.functionCombo = new ComboViewer(comp, 12);
        this.functionCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.functionCombo.setLabelProvider((IBaseLabelProvider)new FunctionsLabelProvider());
        this.functionCombo.addSelectionChangedListener(e -> this.handleFunctionUpdated());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.functionCombo.getCombo());
        return group;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.st.function");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            STFunctionSource source = this.getSource();
            List<STFunction> functions = STLaunchConfigurationTab.getFunctions(source);
            this.functionCombo.setInput(functions);
            if (!functions.isEmpty()) {
                STFunction function = STLaunchConfigurationAttributes.getFunction((ILaunchConfiguration)configuration, (STFunctionSource)source, (STFunction)functions.get(0));
                this.functionCombo.setSelection((ISelection)new StructuredSelection((Object)function), true);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.initializeArgumentsFrom(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        STFunction function = (STFunction)this.functionCombo.getStructuredSelection().getFirstElement();
        if (function != null) {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.st.function", function.getName());
        } else {
            configuration.removeAttribute("org.eclipse.fordiac.ide.debug.st.function");
        }
    }

    protected void handleResourceUpdated() {
        STFunctionSource source = this.getSource();
        STFunction oldFunction = this.getFunction();
        List<STFunction> functions = STLaunchConfigurationTab.getFunctions(source);
        this.functionCombo.setInput(functions);
        if (!functions.isEmpty()) {
            STFunction function = oldFunction != null ? functions.stream().filter(e -> e.getName().equals(oldFunction.getName())).findFirst().orElse(functions.get(0)) : functions.get(0);
            this.functionCombo.setSelection((ISelection)new StructuredSelection((Object)function), true);
        }
        super.handleResourceUpdated();
    }

    protected void handleFunctionUpdated() {
        this.updateArguments();
        this.updateLaunchConfigurationDialog();
    }

    protected boolean filterTargetResource(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            return resource.getFileExtension() != null && resource.getFileExtension().equalsIgnoreCase(FILE_EXTENSION);
        }
        return super.filterTargetResource(resource);
    }

    protected List<Variable<?>> getDefaultArguments() throws CoreException {
        STFunction function = this.getFunction();
        if (function != null) {
            return STLaunchConfigurationDelegate.getDefaultArguments((STFunction)function);
        }
        return Collections.emptyList();
    }

    protected static List<STFunction> getFunctions(STFunctionSource source) {
        if (source != null) {
            return source.getFunctions();
        }
        return Collections.emptyList();
    }

    protected STFunction getFunction() {
        return (STFunction)this.functionCombo.getStructuredSelection().getFirstElement();
    }

    protected STFunctionSource getSource() {
        IResource resource = this.getResource();
        if (resource instanceof IFile) {
            return STFunctionParseUtil.parse((URI)URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true), null, null, null);
        }
        return null;
    }

    private static class FunctionsLabelProvider
    extends LabelProvider {
        private FunctionsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof STFunction) {
                STFunction function = (STFunction)element;
                return function.getName();
            }
            return super.getText(element);
        }
    }
}

