/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.fordiac.ide.debug.replaydebugging.ReplayDebuggingDevice;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugTarget;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class ReplayDebuggingTarget
extends DeploymentDebugTarget {
    private final Map<String, String> deviceNameToPath = new HashMap<String, String>();

    public ReplayDebuggingTarget(AutomationSystem system, Set<INamedElement> selection, ILaunch launch, boolean allowTerminate, String tracesPath) throws DeploymentException {
        super(system, selection, launch, allowTerminate, Duration.ofSeconds(30L), List.of());
        for (INamedElement element : selection) {
            if (!(element instanceof Device)) continue;
            Device device = (Device)element;
            this.deviceNameToPath.put(device.getName(), tracesPath);
        }
    }

    protected void doConnect(Device device) throws DebugException {
        ReplayDebuggingDevice replayDebuggingDevice = new ReplayDebuggingDevice(device, this, this.deviceNameToPath.get(device.getName()));
        replayDebuggingDevice.connect();
    }
}

