/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.helpers;

import java.util.List;
import org.eclipse.fordiac.ide.contractSpec.CausalFuncName;
import org.eclipse.fordiac.ide.contractSpec.CausalRelation;

public final class ContractUtils {
    private ContractUtils() {
    }

    public static String createSingleEvent(List<String> pins, String timeExpr) {
        return "%s occurs within %s".formatted(ContractUtils.createEventList(pins), timeExpr);
    }

    public static String createRepetition(List<String> pins, String timeExpr, String offsetExpr, String jitterExpr) {
        boolean jitter;
        Object repetition = "%s occurs every %s".formatted(ContractUtils.createEventList(pins), timeExpr);
        boolean offset = offsetExpr != null && !offsetExpr.isBlank();
        boolean bl = jitter = jitterExpr != null && !jitterExpr.isBlank();
        if (offset && jitter) {
            repetition = (String)repetition + " with offset %s and jitter %s".formatted(offsetExpr, jitterExpr);
        } else if (offset) {
            repetition = (String)repetition + " with offset %s".formatted(offsetExpr);
        } else if (jitter) {
            repetition = (String)repetition + " with jitter %s".formatted(jitterExpr);
        }
        return repetition;
    }

    public static String createReaction(List<String> iPins, List<String> oPins, boolean inputIsSeq, boolean outputIsSeq, String timeExpr, boolean once, int n, int outOf) {
        String reaction = "whenever %s occurs then %s occurs within %s".formatted(ContractUtils.createEventExpr(iPins, inputIsSeq), ContractUtils.createEventExpr(oPins, outputIsSeq), timeExpr);
        return ContractUtils.addReactionProperties(reaction, once, n, outOf);
    }

    public static String createAge(List<String> iPins, List<String> oPins, boolean inputIsSeq, boolean outputIsSeq, String timeExpr, boolean once, int n, int outOf) {
        String age = "whenever %s occurs then %s has occurred within %s".formatted(ContractUtils.createEventExpr(oPins, outputIsSeq), ContractUtils.createEventExpr(iPins, inputIsSeq), timeExpr);
        return ContractUtils.addReactionProperties(age, once, n, outOf);
    }

    public static String createCausalReaction(String iPin, String oPin, String timeExpr) {
        return "Reaction(%s, %s) within %s".formatted(iPin, oPin, timeExpr);
    }

    public static String createCausalAge(String iPin, String oPin, String timeExpr) {
        return "Age(%s, %s) within %s".formatted(oPin, iPin, timeExpr);
    }

    public static String createCausalFuncDecl(CausalFuncName name, String port1, String port2, CausalRelation relation) {
        return "%s (%s, %s) := %s".formatted(name, port1, port2, relation);
    }

    private static String createEventList(List<String> pins) {
        return String.join((CharSequence)", ", pins);
    }

    private static String createEventExpr(List<String> pins, boolean isSequence) {
        if (pins.size() == 1) {
            return pins.get(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(isSequence ? (char)'(' : '{');
        sb.append(ContractUtils.createEventList(pins));
        sb.append(isSequence ? (char)')' : '}');
        return sb.toString();
    }

    private static String addReactionProperties(String rule, boolean once, int n, int outOf) {
        if (once) {
            rule = (String)rule + " once";
        }
        if (n != outOf) {
            rule = (String)rule + " %d out of %d times".formatted(n, outOf);
        }
        return rule;
    }
}

