/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.eclipse.fordiac.ide.Utils;
import org.eclipse.fordiac.ide.contracts.CInterval;
import org.eclipse.fordiac.ide.contracts.ContractComponent;
import org.eclipse.fordiac.ide.contracts.ContractIssue;
import org.eclipse.fordiac.ide.contracts.ContractRule;
import org.eclipse.fordiac.ide.contracts.ContractSystem;
import org.eclipse.fordiac.ide.contracts.DynamicCheckResult;
import org.eclipse.fordiac.ide.contracts.EventOccurrence;
import org.eclipse.fordiac.ide.contracts.Messages;

public class DynamicContractChecker {
    private final ContractSystem system;
    private final Map<String, List<DynamicCheckResult.RuleData>> rules;
    private final PriorityQueue<EventOccurrence> queue;
    private final DynamicCheckResult result;

    public DynamicContractChecker(ContractSystem system, List<ContractComponent> components, List<EventOccurrence> eventOccurrences) {
        this.system = system;
        this.rules = new HashMap<String, List<DynamicCheckResult.RuleData>>();
        this.queue = new PriorityQueue<EventOccurrence>(eventOccurrences);
        this.result = new DynamicCheckResult(system);
        for (ContractComponent comp : components) {
            DynamicCheckResult.RuleData d;
            for (ContractRule a : comp.getAssumptions().values()) {
                d = new DynamicCheckResult.RuleData(a);
                this.addRule(DynamicContractChecker.createKey(a, a.getInputs().getFirst()), d);
                this.result.rules().add(d);
            }
            for (ContractRule g : comp.getGuarantees().values()) {
                d = new DynamicCheckResult.RuleData(g);
                this.addRule(DynamicContractChecker.createKey(g, g.getOutputs().getFirst()), d);
                this.result.rules().add(d);
            }
            for (ContractRule r : comp.getReactions()) {
                d = new DynamicCheckResult.RuleData(r);
                for (String port : r.getInputs()) {
                    this.addRule(DynamicContractChecker.createKey(r, port), d);
                }
                for (String port : r.getOutputs()) {
                    this.addRule(DynamicContractChecker.createKey(r, port), d);
                }
                this.result.rules().add(d);
            }
        }
    }

    private static String createKey(ContractRule rule, String port) {
        return rule.getOwner().getName() + "." + port;
    }

    private void addRule(String key, DynamicCheckResult.RuleData ruleData) {
        List<DynamicCheckResult.RuleData> list = this.rules.get(key);
        if (list == null) {
            ArrayList<DynamicCheckResult.RuleData> l = new ArrayList<DynamicCheckResult.RuleData>();
            l.add(ruleData);
            this.rules.put(key, l);
        } else if (!list.contains(ruleData)) {
            list.add(ruleData);
        }
    }

    public DynamicCheckResult checkSystem() {
        this.initializeRuleStates();
        this.processEvents();
        return this.result;
    }

    private void initializeRuleStates() {
        for (List<DynamicCheckResult.RuleData> dataList : this.rules.values()) {
            int ruleIdx = 0;
            for (DynamicCheckResult.RuleData ruleData : dataList) {
                ContractRule rule = ruleData.rule();
                switch (rule.getType()) {
                    case SINGLE_EVENT: {
                        this.initSingleEvent(ruleData, rule, ruleIdx);
                        break;
                    }
                    case REPETITION: {
                        this.initRepetition(ruleData, rule, ruleIdx);
                        break;
                    }
                }
                ++ruleIdx;
            }
        }
    }

    private void processEvents() {
        while (!this.queue.isEmpty()) {
            EventOccurrence eo = this.queue.poll();
            List<DynamicCheckResult.RuleData> dataList = this.rules.get(eo.eventName());
            if (dataList == null) continue;
            if (eo.type() == EventOccurrence.Type.MISSED_MARKER) {
                this.processEvent(dataList.get(eo.ruleIndex()), eo, eo.ruleIndex());
                continue;
            }
            int ruleIdx = 0;
            for (DynamicCheckResult.RuleData ruleData : dataList) {
                this.processEvent(ruleData, eo, ruleIdx);
                ++ruleIdx;
            }
        }
    }

    private void processEvent(DynamicCheckResult.RuleData ruleData, EventOccurrence eo, int ruleIdx) {
        ContractRule rule = ruleData.rule();
        switch (rule.getType()) {
            case SINGLE_EVENT: {
                this.checkSingleEvent(ruleData, eo);
                break;
            }
            case REPETITION: {
                this.checkRepetition(ruleData, eo, ruleIdx);
                break;
            }
            case REACTION: {
                this.checkReaction(ruleData, eo, ruleIdx);
                break;
            }
            case AGE: {
                this.checkAge(ruleData, eo);
                break;
            }
            case CAUSAL_REACTION: {
                this.checkCausalReaction(ruleData, eo, ruleIdx);
                break;
            }
            case CAUSAL_AGE: {
                this.checkCausalAge(ruleData, eo);
                break;
            }
        }
    }

    private void initSingleEvent(DynamicCheckResult.RuleData ruleData, ContractRule rule, int ruleIdx) {
        this.createMissedMarker(rule, rule.getSinglePort(), rule.getInterval().getUpperBound(), ruleIdx);
        ruleData.intervals().add(rule.getInterval());
    }

    private void checkSingleEvent(DynamicCheckResult.RuleData ruleData, EventOccurrence eo) {
        ContractRule rule = ruleData.rule();
        if (eo.type() == EventOccurrence.Type.MISSED_MARKER) {
            if (!rule.isFulFilled()) {
                this.eventMissedError(eo, ContractIssue.Code.SINGLE_EVENT_MISSED);
                ruleData.markers().add(eo);
            }
            return;
        }
        if (rule.isFulFilled()) {
            this.system.error(Messages.ContractSingleEventOnceError.formatted(eo.eventName()), ContractIssue.Code.SINGLE_EVENT_MULTIPLE);
            ruleData.markers().add(DynamicContractChecker.issueMarker(eo));
        } else if (!rule.getInterval().contains(eo.timestampNs())) {
            this.eventOutsideIntervalError(rule.getInterval(), eo, ContractIssue.Code.SINGLE_EVENT_TOO_EARLY, ContractIssue.Code.SINGLE_EVENT_TOO_LATE);
            ruleData.markers().add(DynamicContractChecker.issueMarker(eo));
        } else {
            ruleData.markers().add(DynamicContractChecker.fulfillMarker(eo));
        }
        rule.setFulFilled(true);
    }

    private void initRepetition(DynamicCheckResult.RuleData ruleData, ContractRule rule, int ruleIdx) {
        this.createMissedMarker(rule, rule.getSinglePort(), rule.getOffset().getUpperBound() + rule.getJitter(), ruleIdx);
        ruleData.intervals().add(rule.getOffset());
    }

    private void checkRepetition(DynamicCheckResult.RuleData ruleData, EventOccurrence eo, int ruleIdx) {
        double shift;
        ContractRule rule = ruleData.rule();
        CInterval interval = ruleData.intervals().getLast();
        CInterval intervalJitter = interval.addJitter(rule.getJitter());
        if (eo.type() == EventOccurrence.Type.MISSED_MARKER) {
            if (eo.timestampNs() >= intervalJitter.getUpperBound()) {
                this.eventMissedError(eo, ContractIssue.Code.REPETITION_MISSED);
                ruleData.markers().add(eo);
            }
            return;
        }
        if (!intervalJitter.contains(eo.timestampNs())) {
            this.eventOutsideIntervalError(intervalJitter, eo, ContractIssue.Code.REPETITION_TOO_EARLY, ContractIssue.Code.REPETITION_TOO_LATE);
            ruleData.markers().add(DynamicContractChecker.issueMarker(eo));
            shift = eo.timestampNs();
        } else {
            ruleData.markers().add(DynamicContractChecker.fulfillMarker(eo));
            shift = Math.clamp(eo.timestampNs(), interval.getLowerBound(), interval.getUpperBound());
        }
        CInterval next = rule.getInterval().translate(shift);
        this.createMissedMarker(rule, rule.getSinglePort(), next.getUpperBound() + rule.getJitter(), ruleIdx);
        ruleData.intervals().add(next);
    }

    private void checkReaction(DynamicCheckResult.RuleData ruleData, EventOccurrence eo, int ruleIdx) {
        ContractRule rule = ruleData.rule();
        if (eo.type() == EventOccurrence.Type.MISSED_MARKER) {
            boolean fulfill;
            CInterval interval = rule.getInterval().translate(eo.timestampNs() - rule.getInterval().getDiameter() - rule.getInterval().getLowerBound());
            DynamicCheckResult.RuleData.SearchResult searchResult = ruleData.searchInterval(interval);
            boolean bl = fulfill = searchResult == DynamicCheckResult.RuleData.SearchResult.VALID || searchResult == DynamicCheckResult.RuleData.SearchResult.TOO_OFTEN;
            if (searchResult == DynamicCheckResult.RuleData.SearchResult.TOO_OFTEN) {
                this.reactionAgeTooOftenError(eo, true);
            }
            if (ruleData.hasSlidingWindow()) {
                if (!ruleData.add2SlidingWindow(fulfill)) {
                    this.reactionAgeMissedSlidingWindowError(eo, rule.getNOutOfM(), true);
                    ruleData.markers().add(eo);
                }
            } else if (!fulfill) {
                this.reactionAgeMissedError(eo, true);
                ruleData.markers().add(eo);
            }
            return;
        }
        ruleData.markers().add(DynamicContractChecker.normalMarker(eo));
        int i = 0;
        while (i < rule.getInputs().size()) {
            if (eo.eventName().endsWith(rule.getInputs().get(i))) {
                if (ruleData.triggerOccurred(eo, i)) {
                    CInterval next = rule.getInterval().translate(eo.timestampNs());
                    this.createMissedMarker(eo.eventName(), next.getUpperBound(), ruleIdx);
                    ruleData.intervals().add(next);
                }
                return;
            }
            ++i;
        }
    }

    private void checkAge(DynamicCheckResult.RuleData ruleData, EventOccurrence eo) {
        ContractRule rule = ruleData.rule();
        ruleData.markers().add(DynamicContractChecker.normalMarker(eo));
        int i = 0;
        while (i < rule.getOutputs().size()) {
            if (eo.eventName().endsWith(rule.getOutputs().get(i))) {
                if (ruleData.triggerOccurred(eo, i)) {
                    CInterval inter = rule.getInterval();
                    CInterval next = inter.translate(eo.timestampNs() - inter.getLowerBound() * 2.0 - inter.getDiameter());
                    ruleData.intervals().add(next);
                    this.checkAgeHelper(ruleData, next, eo);
                }
                return;
            }
            ++i;
        }
    }

    private void checkAgeHelper(DynamicCheckResult.RuleData ruleData, CInterval interval, EventOccurrence eo) {
        boolean fulfill;
        DynamicCheckResult.RuleData.SearchResult searchResult = ruleData.searchInterval(interval);
        boolean bl = fulfill = searchResult == DynamicCheckResult.RuleData.SearchResult.VALID || searchResult == DynamicCheckResult.RuleData.SearchResult.TOO_OFTEN;
        if (searchResult == DynamicCheckResult.RuleData.SearchResult.TOO_OFTEN) {
            this.reactionAgeTooOftenError(eo, false);
        }
        if (ruleData.hasSlidingWindow()) {
            if (!ruleData.add2SlidingWindow(fulfill)) {
                EventOccurrence mm = DynamicContractChecker.missedMarker(eo.eventName(), interval.getUpperBound());
                this.reactionAgeMissedSlidingWindowError(mm, ruleData.rule().getNOutOfM(), false);
                DynamicContractChecker.insertSorted(ruleData.markers(), mm);
            }
        } else if (!fulfill) {
            EventOccurrence mm = DynamicContractChecker.missedMarker(eo.eventName(), interval.getUpperBound());
            this.reactionAgeMissedError(mm, false);
            DynamicContractChecker.insertSorted(ruleData.markers(), mm);
        }
    }

    private void checkCausalReaction(DynamicCheckResult.RuleData ruleData, EventOccurrence eo, int ruleIdx) {
        ContractRule rule = ruleData.rule();
        if (eo.type() == EventOccurrence.Type.MISSED_MARKER) {
            if (eo.state() == EventOccurrence.State.ISSUE) {
                this.eventMissedError(eo, ContractIssue.Code.CAUSAL_REACTION_MISSED);
                ruleData.markers().add(eo);
            }
            return;
        }
        String input = rule.getInputs().getFirst();
        if (eo.eventName().endsWith(input)) {
            CInterval interval = rule.getInterval().translate(eo.timestampNs());
            EventOccurrence mm = this.createMissedMarker(rule, input, interval.getUpperBound(), ruleIdx, eo.eventID());
            if (!ruleData.rememberCausalEvent(mm)) {
                this.duplicateIDError(mm);
            }
            ruleData.intervals().add(interval);
            ruleData.markers().add(DynamicContractChecker.normalMarker(eo));
        } else {
            EventOccurrence missedM = ruleData.getAssociatedCausalEvent(eo);
            if (missedM == null) {
                ruleData.markers().add(DynamicContractChecker.normalMarker(eo));
                return;
            }
            CInterval inter = rule.getInterval();
            CInterval checkI = inter.translate(missedM.timestampNs() - inter.getDiameter() - inter.getLowerBound());
            if (!checkI.contains(eo.timestampNs())) {
                this.eventOutsideIntervalError(checkI, eo, ContractIssue.Code.CAUSAL_REACTION_TOO_EARLY, ContractIssue.Code.CAUSAL_REACTION_TOO_LATE);
                ruleData.markers().add(DynamicContractChecker.issueMarker(eo));
                if (eo.timestampNs() <= checkI.getLowerBound()) {
                    missedM.setState(EventOccurrence.State.FULFILLING);
                }
            } else {
                ruleData.markers().add(DynamicContractChecker.fulfillMarker(eo));
                missedM.setState(EventOccurrence.State.FULFILLING);
            }
        }
    }

    private void checkCausalAge(DynamicCheckResult.RuleData ruleData, EventOccurrence eo) {
        ContractRule rule = ruleData.rule();
        String input = rule.getInputs().getFirst();
        if (eo.eventName().endsWith(input)) {
            EventOccurrence marker = DynamicContractChecker.normalMarker(eo);
            if (!ruleData.rememberCausalEvent(marker)) {
                this.duplicateIDError(marker);
            }
            ruleData.markers().add(marker);
        } else {
            CInterval inter = rule.getInterval();
            CInterval checkI = inter.translate(eo.timestampNs() - inter.getLowerBound() * 2.0 - inter.getDiameter());
            ruleData.markers().add(DynamicContractChecker.normalMarker(eo));
            ruleData.intervals().add(checkI);
            EventOccurrence age = ruleData.getAssociatedCausalEvent(eo);
            if (age == null) {
                String missedEventName = DynamicContractChecker.createKey(rule, rule.getInputs().getFirst());
                EventOccurrence mm = DynamicContractChecker.missedMarker(missedEventName, checkI.getUpperBound());
                this.eventMissedError(mm, ContractIssue.Code.CAUSAL_AGE_MISSED);
                DynamicContractChecker.insertSorted(ruleData.markers(), mm);
                return;
            }
            if (!checkI.contains(age.timestampNs())) {
                if (age.timestampNs() >= checkI.getUpperBound()) {
                    EventOccurrence mm = DynamicContractChecker.missedMarker(age.eventName(), checkI.getUpperBound());
                    this.eventMissedError(mm, ContractIssue.Code.CAUSAL_AGE_MISSED);
                    DynamicContractChecker.insertSorted(ruleData.markers(), mm);
                }
                this.eventOutsideIntervalError(checkI, age, ContractIssue.Code.CAUSAL_AGE_TOO_EARLY, ContractIssue.Code.CAUSAL_AGE_TOO_LATE);
                age.setState(EventOccurrence.State.ISSUE);
            } else {
                age.setState(EventOccurrence.State.FULFILLING);
            }
        }
    }

    private static void insertSorted(List<EventOccurrence> list, EventOccurrence element) {
        int index = Collections.binarySearch(list, element);
        if (index < 0) {
            index = -index - 1;
        }
        list.add(index, element);
    }

    private void eventMissedError(EventOccurrence eo, ContractIssue.Code code) {
        this.system.error(Messages.ContractEventMissedError.formatted(eo.eventName(), Utils.nsToString((double)eo.timestampNs())), code);
    }

    private void reactionAgeMissedError(EventOccurrence eo, boolean isReaction) {
        ContractRule.Type type = isReaction ? ContractRule.Type.REACTION : ContractRule.Type.AGE;
        ContractIssue.Code code = isReaction ? ContractIssue.Code.REACTION_MISSED : ContractIssue.Code.AGE_MISSED;
        this.system.error(Messages.ContractReactionAgeMissedError.formatted(new Object[]{type, eo.eventName(), Utils.nsToString((double)eo.timestampNs())}), code);
    }

    private void reactionAgeTooOftenError(EventOccurrence eo, boolean isReaction) {
        ContractRule.Type type = isReaction ? ContractRule.Type.REACTION : ContractRule.Type.AGE;
        ContractIssue.Code code = isReaction ? ContractIssue.Code.REACTION_TOO_OFTEN : ContractIssue.Code.AGE_TOO_OFTEN;
        this.system.error(Messages.ContractReactionAgeTooOftenError.formatted(new Object[]{type, eo.eventName(), Utils.nsToString((double)eo.timestampNs())}), code);
    }

    private void reactionAgeMissedSlidingWindowError(EventOccurrence eo, ContractRule.SlidingWindow window, boolean isReaction) {
        ContractRule.Type type = isReaction ? ContractRule.Type.REACTION : ContractRule.Type.AGE;
        ContractIssue.Code code = isReaction ? ContractIssue.Code.REACTION_MISSED : ContractIssue.Code.AGE_MISSED;
        this.system.error(Messages.ContractReactionAgeSlidingWindowError.formatted(new Object[]{type, eo.eventName(), window.n(), window.outOf(), Utils.nsToString((double)eo.timestampNs())}), code);
    }

    private void eventOutsideIntervalError(CInterval interval, EventOccurrence eo, ContractIssue.Code tooEarly, ContractIssue.Code tooLate) {
        if (eo.timestampNs() <= interval.getLowerBound()) {
            this.system.error(Messages.ContractEventTooEarlyError.formatted(eo.eventName(), Utils.nsToString((double)(interval.getLowerBound() - eo.timestampNs()))), tooEarly);
        } else {
            this.system.error(Messages.ContractEventTooLateError.formatted(eo.eventName(), Utils.nsToString((double)(eo.timestampNs() - interval.getUpperBound()))), tooLate);
        }
    }

    private void duplicateIDError(EventOccurrence eo) {
        this.system.error(Messages.ContractDuplicateEventIDError.formatted(eo.eventID(), eo.eventName()), ContractIssue.Code.DUPLICATE_CAUSAL_ID);
    }

    private EventOccurrence createMissedMarker(ContractRule rule, String port, double time, int ruleIdx) {
        return this.createMissedMarker(DynamicContractChecker.createKey(rule, port), time, ruleIdx);
    }

    private EventOccurrence createMissedMarker(ContractRule rule, String port, double time, int ruleIdx, String eventID) {
        return this.createMissedMarker(DynamicContractChecker.createKey(rule, port), time, ruleIdx, eventID);
    }

    private EventOccurrence createMissedMarker(String key, double time, int ruleIdx) {
        return this.createMissedMarker(key, time, ruleIdx, null);
    }

    private EventOccurrence createMissedMarker(String key, double time, int ruleIdx, String eventID) {
        EventOccurrence eo = new EventOccurrence(key, time, EventOccurrence.Type.MISSED_MARKER, EventOccurrence.State.ISSUE, ruleIdx, eventID);
        this.queue.offer(eo);
        return eo;
    }

    private static EventOccurrence missedMarker(String name, double time) {
        return new EventOccurrence(name, time, EventOccurrence.Type.MISSED_MARKER, EventOccurrence.State.ISSUE, 0);
    }

    private static EventOccurrence normalMarker(EventOccurrence eo) {
        return new EventOccurrence(eo.eventName(), eo.timestampNs(), eo.type(), EventOccurrence.State.NOT_SET, 0, eo.eventID());
    }

    private static EventOccurrence issueMarker(EventOccurrence eo) {
        return new EventOccurrence(eo.eventName(), eo.timestampNs(), eo.type(), EventOccurrence.State.ISSUE, 0, eo.eventID());
    }

    private static EventOccurrence fulfillMarker(EventOccurrence eo) {
        return new EventOccurrence(eo.eventName(), eo.timestampNs(), eo.type(), EventOccurrence.State.FULFILLING, 0, eo.eventID());
    }
}

