/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.edit.ui.provider.DelegatingStyledCellLabelProvider;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.Messages;
import org.eclipse.fordiac.ide.model.ui.nat.TypeNode;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.osgi.framework.FrameworkUtil;

public class DataTypeTreeSelectionDialog
extends ElementTreeSelectionDialog {
    private final String pluginId = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getSymbolicName();

    public DataTypeTreeSelectionDialog(Shell parent, ITreeContentProvider contentProvider) {
        this(parent, contentProvider, new TreeNodeLabelProvider());
    }

    public DataTypeTreeSelectionDialog(Shell parent, ITreeContentProvider contentProvider, DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider) {
        super(parent, (ILabelProvider)new DelegatingStyledCellLabelProvider(labelProvider), contentProvider);
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.createContextMenu((Control)this.getTreeViewer().getTree());
        return control;
    }

    private void createContextMenu(Control control) {
        Menu openEditorMenu = new Menu(control);
        final MenuItem openItem = new MenuItem(openEditorMenu, 0);
        openItem.addListener(13, e -> {
            StructuredType sel = this.getSelectedStructuredType();
            if (sel != null) {
                this.handleShellCloseEvent();
                this.setResult(null);
                OpenStructMenu.openStructEditor(sel.getTypeEntry().getFile());
            }
        });
        openItem.setText(FordiacMessages.OPEN_TYPE_EDITOR_MESSAGE);
        openEditorMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                StructuredType type = DataTypeTreeSelectionDialog.this.getSelectedStructuredType();
                openItem.setEnabled(type != null && type != IecTypes.GenericTypes.ANY_STRUCT);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        this.setValidator(selection -> {
            void typeNode;
            Object object;
            if (selection == null || selection.length != 1 || !((object = selection[0]) instanceof TypeNode)) {
                return new Status(4, this.pluginId, Messages.DataTypeDialog_OneElement);
            }
            TypeNode typeNode2 = (TypeNode)object;
            if (!typeNode.getChildren().isEmpty()) {
                return new Status(4, this.pluginId, Messages.DataTypeDialog_NoFolder);
            }
            if (typeNode.getType() == null) {
                return new Status(4, this.pluginId, Messages.DataTypeDialog_InvalidSelection);
            }
            return new Status(0, this.pluginId, MessageFormat.format(Messages.DataTypeDialog_Selected, typeNode.getFullName()));
        });
        control.setMenu(openEditorMenu);
    }

    private StructuredType getSelectedStructuredType() {
        StructuredType structType;
        TypeNode typeNode;
        LibraryElement libraryElement;
        Object object = ((TreeSelection)this.getTreeViewer().getSelection()).getFirstElement();
        return object instanceof TypeNode && (libraryElement = (typeNode = (TypeNode)object).getType()) instanceof StructuredType ? (structType = (StructuredType)libraryElement) : null;
    }

    public static class TreeNodeLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public String getText(Object element) {
            if (element instanceof TypeNode) {
                TypeNode typeNode = (TypeNode)element;
                return typeNode.getName();
            }
            return element.toString();
        }

        public StyledString getStyledText(Object element) {
            TypeNode typeNode;
            if (element instanceof TypeNode && !(typeNode = (TypeNode)element).isDirectory() && !typeNode.getPackageName().isEmpty()) {
                return new StyledString(typeNode.getName()).append(" - " + typeNode.getPackageName(), StyledString.QUALIFIER_STYLER);
            }
            return new StyledString(this.getText(element));
        }

        public Image getImage(Object element) {
            if (element instanceof TypeNode) {
                TypeNode node = (TypeNode)element;
                if (node.isDirectory()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return FordiacImage.ICON_DATA_TYPE.getImage();
            }
            return super.getImage(element);
        }
    }
}

