/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import org.eclipse.fordiac.ide.model.data.TimeType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyDurationValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public final class TimeValue
implements AnyDurationValue {
    public static final TimeValue DEFAULT = new TimeValue(0L);
    private final long value;

    private TimeValue(long value) {
        this.value = value;
    }

    public static TimeValue toTimeValue(long value) {
        return new TimeValue(value);
    }

    public static TimeValue toTimeValue(Number value) {
        return new TimeValue(value.longValue());
    }

    public static TimeValue toTimeValue(Duration value) {
        return new TimeValue(value.toNanos());
    }

    public static TimeValue toTimeValue(String string) {
        return TimeValue.toTimeValue((Duration)TypedValueConverter.INSTANCE_TIME.toValue(string));
    }

    public static TimeValue toTimeValue(AnyMagnitudeValue value) {
        return TimeValue.toTimeValue(value.longValue());
    }

    public TimeType getType() {
        return IecTypes.ElementaryTypes.TIME;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    @Override
    public Duration toDuration() {
        return Duration.ofNanos(this.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeValue other = (TimeValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return TypedValueConverter.INSTANCE_TIME.toString((Object)this.toDuration());
    }
}

