/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkRootEditPart;
import org.eclipse.fordiac.ide.application.policies.ContainerContentLayoutPolicy;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class AbstractContainerContentEditPart
extends FBNetworkEditPart {
    private final Adapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Object feature = notification.getFeature();
            if (LibraryElementPackage.eINSTANCE.getPositionableElement_Position().equals(feature)) {
                AbstractContainerContentEditPart.this.getChildren().forEach(EditPart::refresh);
            }
            super.notifyChanged(notification);
        }
    };

    @Override
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getModel().eAdapters().add((Object)this.adapter);
        }
    }

    @Override
    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.adapter);
        }
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        if (!(editPolicy instanceof ModifiedNonResizeableEditPolicy)) {
            super.installEditPolicy(key, editPolicy);
        } else {
            super.installEditPolicy(key, (EditPolicy)new SelectionEditPolicy(){

                protected void showSelection() {
                }

                protected void hideSelection() {
                }
            });
        }
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ContainerContentLayoutPolicy());
    }

    @Override
    protected IFigure createFigure() {
        Figure figure = new Figure(){

            public void setBounds(Rectangle rect) {
                Rectangle clientArea = this.getParent().getClientArea();
                int maxAvailableHeight = clientArea.height - (rect.y - clientArea.y);
                rect.height = Math.max(rect.height, maxAvailableHeight);
                super.setBounds(rect);
            }
        };
        figure.setOpaque(true);
        figure.setLayoutManager((LayoutManager)new XYLayout());
        return figure;
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        ContainerMarqueeDragTracker dragTracker = new ContainerMarqueeDragTracker(this);
        dragTracker.setMarqueeBehavior(3);
        return dragTracker;
    }

    public abstract FBNetworkElement getContainerElement();

    private static class ContainerMarqueeDragTracker
    extends FBNetworkRootEditPart.FBNetworkMarqueeDragTracker {
        private final AbstractContainerContentEditPart host;

        public ContainerMarqueeDragTracker(AbstractContainerContentEditPart host) {
            this.host = host;
        }

        protected StructuredSelection getDefaultSelectionForRightMouseDown() {
            return new StructuredSelection((Object)this.host);
        }
    }
}

