#     <nowrap>
# Built for Eudora

# version 1.1 Juan Falgueras (98/08/07)
#   Added eudoraNicknamesFolder pref var to hold the path to the Eudora "Nicknames Folder"
#     and added this folder in the scanning for "euNicknames" array (look for # JF)
# 
# version 1.2 Juan Falgueras (98/8/21)
#   Rewrite of finishNickname using prompt::statusLineComplete and deleting substituteNickname
# TO DO
#   Take the folders (Not ended in " Folder") from the Eudora Folder (recursively) to
#   build the MailBoxes.  Not ask for it to Eudora via AE.
#     
# Class message: A message
# Elements:
# 	field by name
# Properties:
# 	body  string  -- the body of the message
# 	priority  integer  -- the priority
# 	label  integer  -- the index of the label
# 	status  unread/already read/replied/forwarded/redirected/not sendable/sendable/queued/sent/never sent  -- the message status
# 	sender  string  -- the sender as appearing in the message summary
# 	date  string  [r/o]  -- the date as appearing in the message summary
# 	subject  string  -- the subject as appearing in the message summary
# 	size  integer  [r/o]  -- the size of the message
# 	outgoing  boolean  [r/o]  -- is the message is outgoing?
# 	signature  none/standard/alternate  -- which signature the message should have
# 	QP  boolean  -- is Eudora allowed to encode text?
# 	return receipt  boolean  -- is a return receipt is requested?
# 	wrap  boolean  -- should the text be wrapped when sent?
# 	tab expansion  boolean  -- should tabs get expanded to spaces?
# 	keep copy  boolean  -- should a copy should be kept after message is sent?
# 	preserve macintosh info  boolean  -- should Macintosh information always be sent with attachments?
# 	attachment encoding  AppleDouble/AppleSingle/BinHex/uuencode  -- the type of encoding to use for attachments
# 	show all headers  boolean  -- should all headers be visible?
# 	transliteration table  integer  -- the resource id of the transliteration table
# 	will be fetched  boolean  -- will the message be [re]fetched on next check?
# 	will be deleted  boolean  -- will the message be deleted from server on next check?
# 

alpha::menu eudoraMenu 0.1.1 "138" {global Mail} {
    addMode Mail dummyMail {} {eudoraMenu}
    set unixMode(rmail) {Mail}
    set brwsGotoMatch(*MAILBOX*) mailGotoMatch
} uninstall {this-file} help {file "Eudora"}

proc eudoraMenu {} {}
proc dummyMail {} {}

namespace eval ::Mail {}

if {![info exists trashName]} {set trashName "Trash"}

newPref v prefixString {> } Mail
newPref v wordBreak {\w+} Mail
newPref v wordBreakPreface {(\W)} Mail
newPref f wordWrap {1} Mail
newPref f autoMark 0 Mail
newPref v eudoraPrefFolder  [file join [file dirname $PREFS] "Eudora Folder"] Mail
newPref file eudoraNicknames "" Mail
newPref v eudoraNicknamesFolder "" Mail
newPref f tossOnQueue 1 Mail
newPref f switchOnQueue 0 Mail

set mailKeywords {{Subject:} {To:} {From:} {Cc:} {Date:} {Sender:}}
regModeKeywords -k blue -e {>} Mail $mailKeywords

# bind tab
Bind 0x30   mailTab Mail

#===============================================================================
# Utility routines.
proc eudoraFolder {} { nameObject euMF {'TEXT'()} [nullObject] }
proc mailboxByName {name} { nameObject euMB "$name" [eudoraFolder] }
proc mailboxByIndex {ind} { indexObject euMB $ind [eudoraFolder] }
proc eudoraMessage {msg_id mailbox} { indexObject euMS $msg_id [mailboxByName $mailbox] }
proc mailboxProperty {prop mailbox} { objectProperty 'CSOm' $prop [mailboxByName $mailbox] }
proc messageProperty {prop msg_id mailbox} { objectProperty 'CSOm' $prop [eudoraMessage $msg_id $mailbox] }

# Get path-name for indicated mailbox
proc mailboxPathName {name} {
	extractPath [mailboxProperty euFS $name]
}

proc mailboxPathIndex {ind} {
	set res [objectProperty 'CSOm' euFS [mailboxByIndex $ind]]
	return [extractPath $res]
}

#===============================================================================


proc checkMailPath {} {
	set name [nameFromAppl CSOm]
	launch $name
	return [file tail $name]
}

if {![info exists eudoraBoxes]} {
	set eudoraBoxes {In Out}
}

Menu -n $eudoraMenu -p eudoraProc {
	"<SbackgroundEudora"
	"<Seudora"
	"help"
	"(-"
	"/e<U<BnewMessage"
	"cc"
	"bcc"
	"(-"
	"/f<U<Bsend"
	"/g<U<S<Breply"
	"/g<U<I<S<BreplyToAll"
	"(-"
	"/,<SfinishNickname"
	"editNicknames"
	"updateNicknames"
	"(-"
	"updateMailboxLists"
	{Menu -n open -p mailBoxProc -m {}}
	{Menu -n moveTo -p transferProc -m {}}
	"(-"
	{Menu -n tellEudora -p eudoraProc {
		"/k<UflushOutbox"
		"/l<UcheckForMail"
		"(-"
		startNotifying
		stopNotifying}}
	{Menu -n mailFlags -p mailFlagsProc {alertOnIncoming flushOnCheck immediateSend -- trashName}}
}
Menu -n open -p mailBoxProc -m [concat [list "/h<U<BOpen Mailbox" "(-"] $eudoraBoxes]
Menu -n moveTo -p transferProc -m [concat [list "/i<U<BMove To Trash" "/j<U<BMove To Mailbox" "(-"] $eudoraBoxes]

# JF 98/08/07
if {$MailmodeVars(eudoraNicknames) == ""} {
	if {[file exists [file join $MailmodeVars(eudoraPrefFolder) "Eudora Nicknames"]]} {
		set MailmodeVars(eudoraNicknames) [file join $MailmodeVars(eudoraPrefFolder) "Eudora Nicknames"]
	}
}
if {$MailmodeVars(eudoraNicknamesFolder) == ""} {
	if {[file exists [file join $MailmodeVars(eudoraPrefFolder) "Nicknames Folder"]]} {
		set MailmodeVars(eudoraNicknamesFolder) [file join $MailmodeVars(eudoraPrefFolder) "Nicknames Folder"]
	}
}



proc updateNicknames {{arg ""}} {
    global euNicknames MailmodeVars
# JF 98/08/07
    if {(![info exists MailmodeVars(eudoraNicknames)] && ![info exists MailmodeVars(eudoraNicknamesFolder)])\
	  			|| \
	  (![file exists $MailmodeVars(eudoraNicknames)] && ![file exists $MailmodeVars(eudoraNicknamesFolder)])} {
		if {![string length $arg]} {
			alertnote {Please locate the file "Eudora Nicknames" or/and folder "Nicknames Folder" using Mail mode's prefs.}
		}
		return
	}
    
	if {[file exists $MailmodeVars(eudoraNicknames)]} {
		set fd [open $MailmodeVars(eudoraNicknames)]
		foreach a [split [read $fd] "\n"] {
			if {[llength $a] && [lindex $a 0] == "alias"} {
				set euNicknames([lindex $a 1]) [lindex $a 2]
			}
		}
	    close $fd
	}
	if {[expr {$MailmodeVars(eudoraNicknamesFolder) != ""} && [file isdirectory $MailmodeVars(eudoraNicknamesFolder)]]} {
		foreach f [glob -dir $MailmodeVars(eudoraNicknamesFolder) *] {
			set fd [open "$f"]
			foreach a [split [read $fd] "\n"] {
				if {[regexp {\{\}\[\]} $a]} {
					alertnote "ERROR: Braces in $f"
					close $fd
					return
				} else {
					if {[llength $a] && [lindex $a 0] == "alias"} {
						set euNicknames([lindex $a 1]) [lindex $a 2]
					}
				}
			}
		    close $fd
		}
	}
}
updateNicknames quiet


proc finishNickname {} {
# 	I don't know well the mechanism of prompt::statusLineComplete and I needed
# 	to use a global :( preMailNick to prefix the previous entered string before each
# 	search for matchings in nicknames
# Another interesting thing should be to show the initial matched list just at
# 	starting of the command.  You need now to add a char to start to see the list

	global euNicknames preMailNick
	set pos [getPos]
	backwardWord
	if {[pos::compare [getPos] == [minPos]]} {
		set preMailNick ""
	} else {
		set preMailNick [getText [getPos] $pos]
	}

	goto $pos
	;proc pMatches {pat} {
		global euNicknames preMailNick
		set matches ""
		foreach w [array names euNicknames] {
			if {[string match "$preMailNick$pat*" $w]} {
				lappend matches $w
			}
		}
		return $matches
	}
	
	set s [prompt::statusLineComplete "Nick" pMatches -initialpatt "$preMailNick"]
	if {$preMailNick != ""} {
		backwardDeleteWord
	}
	insertText $s
}

proc editNicknames {} {
    global MailmodeVars
# JF 98/08/07
    if {![info exists MailmodeVars(eudoraNicknamesFolder)]} {
		edit -w "$MailmodeVars(eudoraNicknames)"
	} else {
		edit -w [getfile "Which of them?" "$MailmodeVars(eudoraNicknamesFolder)"]
	}
}


proc openMailbox {} {
	global eudoraBoxes eudoraLastFolder modifiedVars
	if {[info exists eudoraLastFolder]} {
		set fold $eudoraLastFolder
	} else {
		set fold [lindex $eudoraBoxes 0]
	}
	set eudoraLastFolder [sPromptChoices "Open mailbox" $fold $eudoraBoxes]
	mailBoxProc dummy $eudoraLastFolder
	lappend modifiedVars eudoraLastFolder
}


proc moveToFolderProc {curr c} {
	global eudoraBoxes
	if {$c != "\t"} {return $c}
	
	set matches {}
	foreach w $eudoraBoxes {
		if {[string match "$curr*" $w]} {
			lappend matches $w
		}
	}
	if {![llength $matches]} {
		beep
	} else {
		return [string range [largestPrefix $matches] [string length $curr] end]
	}
	return ""
}


proc moveToMailbox {} {
	global eudoraLastFolder modifiedVars trashName
	
	if {[info exists eudoraLastFolder]} {
		set fold $eudoraLastFolder
	} else {
		set fold $trashName
	}
	
	set folder [statusPrompt -f "Move to ($fold): " moveToFolderProc]
	if {[string length $folder]} {
		doFolderMove $folder
		set eudoraLastFolder $folder
		lappend modifiedVars eudoraLastFolder
	} else {
		doFolderMove $fold
	}
}


proc eudoraProc {menu item} {
	global HOME eudoraMenu

	switch -- $item {
		"eudora"		{app::launchFore CSOm}
		"backgroundEudora"		{launch [nameFromAppl CSOm]}
		"help"			{edit -r [file join $HOME Help Eudora]}
		"cc"			{eudoraCc}
		"bcc"			{eudoraBcc}
		"newMessage"	{mailNewMsg}
		"reply"			{mailReplymsg}
		"replyToAll"	{mailReplymsg 1}
		"send"			{checkMailPath; mailSendCreatedMsg}
		"flushOutbox"	{checkMailPath; mailFlushOut}
		"checkForMail"	{checkMailPath; mailCheck}
		"startNotifying" "checkMailPath; startNotifying"
		"stopNotifying"	"checkMailPath; stopNotifying"
		"moveToTrash"	{mailTrashmsg}
		"Move To Trash"	{mailTrashmsg}
		"Create New"	{eudoraNewMailbox}
		"Delete"		{eudoraDeleteMailbox}
		default			$item
	}
}

if {![info exists mailflushOnCheck]} {set mailflushOnCheck 1}
if {![info exists mailalertOnIncoming]} {set mailalertOnIncoming 1}
if {![info exists mailimmediateSend]} {set mailimmediateSend 0}
markMenuItem mailFlags flushOnCheck $mailflushOnCheck
markMenuItem mailFlags alertOnIncoming $mailalertOnIncoming
markMenuItem mailFlags immediateSend $mailimmediateSend


proc mailFlagsProc {menu flag} {
	global mail$flag modifiedVars trashName

	if {$flag == "trashName"} {
		set trashName [prompt "Trash folder name:" $trashName]
		lappend modifiedVars trashName
		return
	}
	

	set mail$flag [expr 1 - [set mail$flag]]
	lappend modifiedVars mail$flag
	markMenuItem mailFlags $flag [set mail$flag]
}


proc mailBoxProc {menu item} {
	global inboxMembers ALPHA eudoraBoxes modifiedVars
	global tileLeft tileTop tileHeight errorHeight defWidth

	if {$item == "Open Mailbox"} {
		return [openMailbox]
	}
	
	killMailboxWindow

	checkMailPath
	switchTo $ALPHA

	global trashedMsgs$item
	set trashedMsgs$item {}
	
	set inboxMembers {}
	set text {}
	set ind 1
	foreach msg [mailSenders $item] {
		set from [mailAddr [lindex $msg 0]]
		set tag {}
		while {[lsearch $inboxMembers $from$tag] >= 0} {
			if {![string length $tag]} {
				set tag { <2>}
			} else {
				regexp {[0-9]+} $tag tag
				set tag " <[expr $tag + 1]>"
			}
		}
		append text [format "%-40s : %s\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t$item$ind\r" "$from$tag" [lindex $msg 1]]
		lappend inboxMembers $from$tag
		incr ind
	}
	if {![string length $text]} {
		alertnote "No messages in '$item'!"
		return
	}
	
	new -n "* MAILBOX '$item' *" -g $tileLeft $tileTop $defWidth $errorHeight -m Brws
	insertText "(<cr> to go to message)\r-----\r$text"
	
	select [nextLineStart [nextLineStart [minPos]]] [nextLineStart [nextLineStart [nextLineStart [minPos]]]]
	winReadOnly
	message ""
}

proc eudoraNewMailbox {} {
}


proc eudoraDeleteMailbox {} {
}


proc killMailboxWindow {} {
	if {[set ind [lsearch [winNames] {*MAILBOX*}]] >= 0} {
		set win [lindex [winNames] $ind]
		bringToFront $win
		killWindow
	}
}


proc mailGotoMatch {} {
	if {[regexp {(.+)([0-9]+)} [getText [lineStart [getPos]] [nextLineStart [getPos]]] dummy folder ind]} {
		global trashedMsgs$folder
		
		set deleted 0
		for {set i 1} {$i < $ind} {incr i} {
			if {[lsearch [set trashedMsgs$folder] $i] >= 0} {
				incr deleted
			}
		}
		mailOpen $folder [expr $ind - $deleted] $ind
	}
}


proc mailAddr {name} {
	if {![regexp {<(.*)>} $name dummy addr]} {
		regexp {^[^ ]+} $name addr
	}
	return $addr
}


proc mailSenders {folder} {
	set cnt [mailCountMsgs $folder]
	set msgs {}
	for {set i 1} {$i <= $cnt} {incr i} {
		set subject {}
		if {![regexp -nocase {From: (.*)} [mailGetField from $folder $i] dummy from]} {
			error "No from field!"
		}
		regexp {Subject: (.*)} [mailGetField subject $folder $i] dummy subject
		lappend msgs [list $from $subject]
	}
	return $msgs
}	


proc eudoraCc {} {
	if {![catch {set res [search -s -f 1 -r 1 -i 1 {cc:.*} 0]}]} {
		goto [lindex $res 0]
		endOfLine
	} else {
		beginningOfBuffer
		nextLine
		insertText "Cc: \r"
		backwardChar
	}
}


proc eudoraBcc {} {
	if {![catch {set res [search -s -f 1 -r 1 -i 1 {bcc:.*} 0]}]} {
		goto [lindex $res 0]
		endOfLine
	} else {
		beginningOfBuffer
		nextLine
		insertText "Bcc: \r"
		backwardChar
	}
}


proc mailFlushOut {} {
	global MailmodeVars
	message "Telling Eudora to flush messages"

	AEBuild 'CSOm' CSOm eCon eSen bool(01) eChk bool(00)
	message ""
}


proc mailCheck {} {
	global MailmodeVars mailflushOnCheck
	message "Told Eudora to check for new mail"

	AEBuild 'CSOm' CSOm eCon eSen bool(0$mailflushOnCheck) eChk bool(01)
}


proc mailReplymsg {{toall 0}} {
	global inboxMembers

	set prefix "> "
	set res [search -s -f 1 -r 1 {^>==} [minPos]]
	set header [getText [minPos] [lindex $res 0]]
	
	set from [mailGetFrom]
	if {![regexp {Subject: ([^\r]*)} $header dummy subject]} {set subject ""}
	set body [getText [expr [lindex $res 1] + 1] [maxPos]]

	regsub -all "\r" $body "\r$prefix" body
	mailNewMsg $from "" "" "Re: $subject" "\r$prefix$body\r"
}

proc transferProc {menu item} {
	if {$item == "Move To Trash"} {
		mailTrashmsg
	} elseif {$item == "Move To Mailbox"} {
		moveToMailbox
	} else {
		doFolderMove $item
	}
}


proc mailTrashmsg {} {
	global trashName
	doFolderMove $trashName
}

proc doFolderMove {toFolder} {
	# Is this a summary or msg window?
	if {[regexp "MAILBOX" [win::CurrentTail]]} {
		if {![regexp {(.*)([0-9]+)} [getText [getPos] [nextLineStart [getPos]]] dummy folder orig]} {
			beep
			return
		}
		if {$toFolder == $folder} return
		global trashedMsgs$folder

		set deleted 0
		for {set i 1} {$i < $orig} {incr i} {
			if {[lsearch [set trashedMsgs$folder] $i] >= 0} {
				incr deleted
			}
		}
		set number [expr $orig - $deleted]
		set summary 1
	} else {
		set pos [lindex [search -f 1 -r 1 {^Msg} 0] 0]
		set text [getText $pos [nextLineStart $pos]]
		regexp {"([^"]+)" \(([0-9]+)\).*"([^"]+)"} $text dummy number orig folder
		if {$toFolder == $folder} return
		set summary 0

		global trashedMsgs$folder
	}
	
	message "Moving msg $number ($orig) of folder '$folder' to '$toFolder'"
	moveMsg $number $folder $toFolder
	if {!$summary} killWindow

	lappend trashedMsgs$folder $orig
	
	# Find summary info and delete it
	set win [win::CurrentTail]
	if {[regexp "MAILBOX" $win]} {
		setWinInfo read-only 0
	
		set inds [search -f 1 -r 1 "$folder$orig\$" 0]
		set pos [lindex $inds 0]
		deleteText [lineStart $pos] [nextLineStart $pos]
	
		if {[string length [search -n -f 1 -r 0 {} 0]]} {
			setWinInfo dirty 0
			setWinInfo read-only 1
	
			nextLine
			upBrowse
		} else {
			setWinInfo dirty 0
			killWindow
		}
	}
}

	
proc mailGetFrom {} {
	set res [search -s -f 1 -r 1 {>==} [minPos]]
	set header [getText [minPos] [lindex $res 0]]
	if {[regexp {From: ([^\r]*)} $header dummy from]} {
		return [mailAddr $from]
	}
	error "No from line"
}

	

proc mailSendCreatedMsg {} {
	global MailmodeVars mailimmediateSend
	
	set name [checkMailPath]
	set res [search -s -f 1 -r 0 {>==text follows this line==<} [minPos]]
	set header [getText [minPos] [lindex $res 0]]
	
	if {![regexp {To: ([^\r]*)} $header dummy to]} {set to ""}
	if {![regexp {[Cc]+: ([^\r]*)} $header dummy cc]} {set cc ""}
	if {![regexp {Subject: ([^\r]*)} $header dummy subject]} {set subject ""}

	set body [getText [expr [lindex $res 1] + 1] [maxPos]]
	
	mailCreateMsg
	mailSetField to $to
	mailSetField cc $cc
	mailSetField subject $subject
	mailSetField "" $body
	
	if {$MailmodeVars(tossOnQueue)} {
		setWinInfo dirty 0
		killWindow
	}

	mailQueueLast

	if {$MailmodeVars(switchOnQueue)} {
		switchTo $name
	}

	if {$mailimmediateSend} {
		mailFlushOut
	} else {
		message "Message queued"
	}
}

	
proc mailNewMsg {{to ""} {cc ""} {bcc ""} {subject ""} {body ""}} {
	new -n "New Mail" -m Mail

	insertText "To: $to\rSubject: $subject\r>==text follows this line==<\r$body"
	setWinInfo dirty 0
	goto [minPos]
	refresh
	mailTab
}


proc mailTab {} {
	global mailKeywords
	if {[catch {search -s -f 1 -r 1 -i 1 "([join $mailKeywords {|}]|^>)" [getPos]} res]} {
		insertText "\t"
		return
	}
	if {[lookAt [lindex $res 0]] == ">"} {
		select [nextLineStart [lindex $res 1]] [maxPos]
	} else {
		goto [expr [lindex $res 1] + 1]
		endLineSelect
	}
}

proc mailOpen {folder i originalNum} {
	global tileLeft tileTop tileHeight trashedMsgs$folder defWidth
	
	set from [mailGetField From $folder $i]
	set to [mailGetField To $folder $i]
	set subject [mailGetField Subject $folder $i]
	set sender [mailGetField Sender $folder $i]
	set date [mailGetField Date $folder $i]
	set cc [mailGetField cc $folder $i]
	set contents [mailGetField "" $folder $i]
	
#===============================================================================
	global tileHeight tileTop tileLeft errorHeight errorDisp defWidth
	set top $tileTop
	set geo [getGeometry]
	if {([lindex $geo 0] != $tileLeft) || ([lindex $geo 1] != $top) || ([lindex $geo 2] != $defWidth) || ([lindex $geo 3] != $errorHeight) } {
		moveWin $tileLeft $top
		sizeWin $defWidth $errorHeight
	}
	set mar 28
	incr top [expr $errorHeight + $mar]
#===============================================================================
	set name [new -n "MAIL" -g $tileLeft $top $defWidth [expr $errorDisp - 5] -m Mail]

	set text {}
	if {[string length $subject]} {append text "$subject\r"}
	if {[string length $to]} {append text "$to\r"}
	if {[string length $from]} {append text "$from\r"}
	if {[string length $date]} {append text "$date\r"}
	if {[string length $cc]} {append text "$cc\r"}
	if {[string length $sender]} {append text "$sender\r"}
	append text "Msg \"$i\" ($originalNum) of mailbox \"$folder\"     Reply     Trash\r"
	insertText "${text}>===============================================================================
$contents
"
	goto [minPos]
	goto [lindex [search -f 1 -m 0 -r 1 {^Msg "} [minPos]] 0]
	set pos [getPos]
	regexp -indices {([0-9]+).*mailbox "(.+)".*(Reply).*(Trash)} [getText $pos [nextLineStart $pos]] dummy num fold rep tra
	colorSelectPos [expr $pos + [lindex $num 0]] [expr 1 + $pos + [lindex $num 1]] bold 12
	colorSelectPos [expr $pos + [lindex $fold 0]] [expr 1 +$pos + [lindex $fold 1]] bold 12
	hyperSelectPos [expr $pos + [lindex $rep 0]] [expr 1 +$pos + [lindex $rep 1]] "mailReplymsg"
	hyperSelectPos [expr $pos + [lindex $tra 0]] [expr 1 +$pos + [lindex $tra 1]] "mailTrashmsg"

	winReadOnly
	refresh
}

proc colorSelectPos {from to ind ind2} {
	insertColorEscape $from $ind
	insertColorEscape $to $ind2
}

proc hyperSelectPos {from to text} {
	if {$from == $to} {
		beep
		return
	}
	insertColorEscape $from 3
	insertColorEscape $from 15 $text
	insertColorEscape $to 12
	insertColorEscape $to 0
}

proc mailFixMenus {} {
	global eudoraMenu
	
	set ins {}
	set outs {}
	
	set cnt [mailCountMsgs in]
	for {set i 1} {$i <= $cnt} {incr i} {
		lappend ins [mailGetField from in $i]
	}
	Menu -n in {}
	foreach item $ins {
		addMenuItem -l "" in $item
	}
	
	set cnt [mailCountMsgs out]
	for {set i 1} {$i <= $cnt} {incr i} {
		lappend outs [mailGetField from out $i]
	}
	Menu -n out {}
	foreach item $outs {
		addMenuItem -l "" out $item
	}
}


# make message at end of mailbox "out" of mail folder ""
proc mailCreateMsg {} {
	createThingAtEnd 'CSOm' [mailboxByName Out] euMS
}


# Move msg w/ specified index between folders, including to Trash.
proc moveMsg {msg infolder outfolder} {
	AEBuild -r 'CSOm' core move {----} "obj \{form:indx, want:type(euMS), seld:$msg, from:obj \{form:name, want:type(euMB), seld:$infolder, from:obj \{form:name, want:type(euMF), seld:'TEXT'(), from:'null'()\}\}\}" {insh} "insl\{kobj:obj \{form:name, want:type(euMB), seld:$outfolder, from:obj \{form:name, want:type(euMF), seld:'TEXT'(), from:'null'()\}\}, kpos:end \}"
}


# set field "fld" of message 0 to "to"
proc mailSetField {fld to} {
	AEBuild -r 'CSOm' core setd {----} "obj \{form:name, want:type(euFd), seld:$fld, from:obj \{form:indx, want:type(euMS), seld:1, from:'null'()\}\}" data "$to"
}

proc mailGetField {field folder msg} {
	if {[catch {getObjectData 'CSOm' euFd $field [eudoraMessage $msg $folder]} res]} {
		return ""
	} else {
		return $res
	}
}

# obj {want:type('prop'), from:obj {form:indx, want:type(euMS), seld:$msg, from:obj {form:name, want:type(euMB), seld:$folder, from:obj {form:name, want:type(euMF), seld:'TEXT'(), from:'null'()}}}, form:'prop', seld:type('euST')}

proc mailMsgStatus {folder msg} {
	if {[catch {AEBuild -r 'CSOm' core getd {----} "obj \{want:type('prop'), from:obj \{form:indx, want:type(euMS), seld:$msg, from:obj \{form:name, want:type(euMB), seld:$folder, from:obj \{form:name, want:type(euMF), seld:'TEXT'(), from:'null'()\}\}\}, form:'prop', seld:type('euST')\}"} text]} {
		return ""
	}
	set from [string first "" $text]
	set to [string first "" $text]
	return [string range $text [expr $from + 1] [expr $to - 1]]
}

proc mailQueueLast {} {
	AEBuild -r 'CSOm' CSOm eQue ---- {obj {form:indx, want:type(euMS), seld:1, from:'null'()}}
}

# CSOm\eAtc{'----':obj {form:indx, want:type(euMS), seld:1, from:'null'()}, eDcl:[fss (486172643A4465736B746F7020466F6C6465723A62756773)]}
proc mailAttachmentDoesntWork {name} {
	AEBuild -r 'CSOm' CSOm eAtc ---- {obj {form:indx, want:type(euMS), seld:1, from:'null'()}} eDcl [makeAlis $name]
}

# core\setd{'----':obj {form:prop, want:type(prop), seld:type(euPY), from:obj {form:indx, want:type(euMS), seld:1, from:'null'()}}, data:1}
proc mailSetNumberProperty {prop to} {
	AEBuild -r 'CSOm' core setd ---- "obj \{form:prop, want:type(prop), seld:type($prop), from:obj \{form:indx, want:type(euMS), seld:1, from:'null'()\}\}" data $to
}	


proc mailCountMsgs {mbox} {
	return [countObjects 'CSOm' [mailboxByName "$mbox"]  euMS]
}

proc mailCountMailboxes {} {
 	return [countObjects 'CSOm' [eudoraFolder] euMB]
}
	

proc updateMailboxLists {} {
	set num [mailCountMailboxes]
	for {set i 1} {$i <= $num} {incr i} {
		set name [file tail [mailboxPathIndex $i]]
		message $name
		lappend boxes $name
	}
	
	global eudoraBoxes modifiedVars
	lappend modifiedVars eudoraBoxes
	set eudoraBoxes $boxes
	Menu -n open -p mailBoxProc -m $eudoraBoxes
	Menu -n moveTo -p transferProc -m $eudoraBoxes
	message "done."
}


#===============================================================================

eventHandler CSOm eNot "eudoraHandler"
 
# a sample 'msgs': obj {want:type(euMS), from:obj {want:type(euMB), from:obj {want:type(euMF), from:'null'(), form:name, seld:'TEXT'()}, form:name, seld:In}, form:indx, seld:18}, obj {want:type(euMS), from:obj {want:type(euMB), from:obj {want:type(euMF), from:'null'(), form:name, seld:'TEXT'()}, form:name, seld:In}, form:indx, seld:19}
proc eudoraHandler {it} {
	global blah mailalertOnIncoming
	message ""
	if {[regexp {eWHp:wArv.*\[(obj.*)\], &repq} $it dum1 msgs]} {
		set ids [getMsgIDs $msgs]
		if {$mailalertOnIncoming} {
			mailBrowser In $ids
		}
	} else {
		message "No mail"
	}
}


proc mailBrowser {folder ids} {
	global inboxMembers ALPHA
	global tileLeft tileTop defWidth tileHeight errorHeight

	checkMailPath
	switchTo $ALPHA

	global trashedMsgs$folder
	set trashedMsgs$folder {}
	
	set inboxMembers {}
	set text {}

	foreach id $ids {
		regexp {From: (.*)} [mailGetField from $folder $id] dummy from
		set from [mailAddr $from]
		set subject {}
		regexp {Subject: (.*)} [mailGetField subject $folder $id] dummy subject
		set tag {}
		while {[lsearch $inboxMembers $from$tag] >= 0} {
			if {![string length $tag]} {
				set tag { <2>}
			} else {
				regexp {[0-9]+} $tag tag
				set tag " <[expr $tag + 1]>"
			}
		}
		append text [format "%-40s : %s\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn$id\r" "$from$tag" $subject]
		lappend inboxMembers $from$tag
	}
	if {![string length $text]} {
		alertnote "No messages!"
		return
	}
	
	if {[set ind [lsearch [winNames] "*Incoming MAILBOX*"]] >= 0} {
		bringToFront [lindex [winNames] $ind]
		setWinInfo read-only 0
		endOfBuffer
		insertText $text
	} else {
		killMailboxWindow
		new -n "* Incoming MAILBOX *" -g $tileLeft $tileTop $defWidth $errorHeight -m Brws

		insertText "(<cr> to go to message)\r-----\r$text"
	}
	select [nextLineStart [nextLineStart [minPos]]] [nextLineStart [nextLineStart [nextLineStart [minPos]]]]
	winReadOnly
	message ""
}


proc getMsgIDs {text} {
	if {[regexp -indices {seld:([0-9]+)} $text dummy ind]} {
		return [concat [string range $text [lindex $ind 0] [lindex $ind 1]] [getMsgIDs [string range $text [lindex $ind 1] end]]]
	}
}

proc startNotifying {} {
	global HOME ALPHA quitHooks
	
	AEBuild 'CSOm' CSOm nIns ---- [makeAlis [file join $HOME $ALPHA]]
}

proc stopNotifying {} {
	global HOME ALPHA
	
	AEBuild 'CSOm' CSOm nRem ---- [makeAlis [file join $HOME $ALPHA]]
}




