/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.Camellia;
import org.bouncycastle.jcajce.provider.ASN1AlgorithmParameters;
import org.bouncycastle.jcajce.provider.AuthParametersCreator;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BaseWrapCipher;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GcmSpecUtil;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.IVAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.IvParametersCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.SymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.WrapParameterSpec;

class ProvCamellia
extends SymmetricAlgorithmProvider {
    private Camellia.OperatorFactory operatorFactory;
    private Camellia.AEADOperatorFactory aeadOperatorFactory;
    private Camellia.KeyWrapOperatorFactory keyWrapOperatorFactory;
    private static final String PREFIX = ProvCamellia.class.getName();
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(final Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            if (parameters.getAlgorithm().equals(Camellia.KW.getAlgorithm()) || parameters.getAlgorithm().equals(Camellia.KWP.getAlgorithm())) {
                return new ParametersCreator(){

                    public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                        if (algorithmParameterSpec instanceof WrapParameterSpec) {
                            return ((Camellia.WrapParameters)parameters).withUsingInverseFunction(((WrapParameterSpec)algorithmParameterSpec).useInverseFunction());
                        }
                        return parameters;
                    }
                };
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvCamellia() {
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.aeadOperatorFactory = new Camellia.AEADOperatorFactory();
            this.keyWrapOperatorFactory = new Camellia.KeyWrapOperatorFactory();
            this.operatorFactory = new Camellia.OperatorFactory();
        }
    }

    private Camellia.OperatorFactory getGeneralOperatorFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        return this.operatorFactory;
    }

    @Override
    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        final Class[] classArray = GcmSpecUtil.getCipherSpecClasses();
        final Class[] classArray2 = new Class[]{IvParameterSpec.class};
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.CAMELLIA", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new ASN1AlgorithmParameters("Camellia");
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", "CAMELLIA", NTTObjectIdentifiers.id_camellia128_cbc, NTTObjectIdentifiers.id_camellia192_cbc, NTTObjectIdentifiers.id_camellia256_cbc);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator", NTTObjectIdentifiers.id_camellia128_cbc, PREFIX + "$AlgParamGen", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new IVAlgorithmParameterGenerator(bouncyCastleFipsProvider, "Camellia", 16);
            }
        }));
        bouncyCastleFipsProvider.addAlias("AlgorithmParameterGenerator", NTTObjectIdentifiers.id_camellia128_cbc.getId(), NTTObjectIdentifiers.id_camellia192_cbc, NTTObjectIdentifiers.id_camellia256_cbc);
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.CAMELLIA", PREFIX + "$CAMELLIAKFACT", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseSecretKeyFactory("Camellia", Camellia.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    @Override
                    public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                        int n = byArray.length * 8;
                        if (n != 128 && n != 192 && n != 256) {
                            throw new InvalidKeySpecException("Provided key data wrong size for Camellia");
                        }
                        return byArray;
                    }
                });
            }
        }));
        GuardedEngineCreator guardedEngineCreator = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return ProvCamellia.this.createFixedFactory(128);
            }
        });
        this.addSecretKeyFactoryForOIDs(bouncyCastleFipsProvider, PREFIX + "SKF", guardedEngineCreator, NTTObjectIdentifiers.id_camellia128_cbc, NTTObjectIdentifiers.id_camellia128_wrap);
        GuardedEngineCreator guardedEngineCreator2 = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return ProvCamellia.this.createFixedFactory(192);
            }
        });
        this.addSecretKeyFactoryForOIDs(bouncyCastleFipsProvider, PREFIX + "SKF", guardedEngineCreator2, NTTObjectIdentifiers.id_camellia192_cbc, NTTObjectIdentifiers.id_camellia192_wrap);
        GuardedEngineCreator guardedEngineCreator3 = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return ProvCamellia.this.createFixedFactory(256);
            }
        });
        this.addSecretKeyFactoryForOIDs(bouncyCastleFipsProvider, PREFIX + "SKF", guardedEngineCreator3, NTTObjectIdentifiers.id_camellia256_cbc, NTTObjectIdentifiers.id_camellia256_wrap);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.CAMELLIA", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Camellia.ECBwithPKCS7, Camellia.ECB, Camellia.ECBwithISO10126_2, Camellia.ECBwithISO7816_4, Camellia.ECBwithTBC, Camellia.ECBwithX923, Camellia.CBC, Camellia.CBCwithPKCS7, Camellia.CBCwithISO10126_2, Camellia.CBCwithISO7816_4, Camellia.CBCwithTBC, Camellia.CBCwithX923, Camellia.CBCwithCS1, Camellia.CBCwithCS2, Camellia.CBCwithCS3, Camellia.CFB128, Camellia.CFB8, Camellia.OpenPGPCFB, Camellia.OFB, Camellia.CTR, Camellia.GCM, Camellia.CCM, Camellia.OCB, Camellia.EAX).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.getGeneralOperatorFactory(), ProvCamellia.this.aeadOperatorFactory).withParameters(classArray).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia128_cbc, PREFIX + "$CBC128", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Camellia.CBCwithPKCS7).withParameters(classArray2).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.operatorFactory, null).withFixedKeySize(128).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia192_cbc, PREFIX + "$CBC192", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Camellia.CBCwithPKCS7).withParameters(classArray2).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.operatorFactory, null).withFixedKeySize(192).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia256_cbc, PREFIX + "$CBC256", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseCipher.Builder(bouncyCastleFipsProvider, 128, Camellia.CBCwithPKCS7).withParameters(classArray2).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.operatorFactory, null).withFixedKeySize(256).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.CAMELLIAKW", PREFIX + "$Wrap", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, Camellia.KW).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia128_wrap, PREFIX + "$Wrap128", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) throws NoSuchAlgorithmException {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, Camellia.KW).withFixedKeySize(128).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia192_wrap, PREFIX + "$Wrap192", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) throws NoSuchAlgorithmException {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, Camellia.KW).withFixedKeySize(192).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia256_wrap, PREFIX + "$Wrap256", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) throws NoSuchAlgorithmException {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, Camellia.KW).withFixedKeySize(256).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "CAMELLIAKW", "CAMELLIAWRAP");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Cipher.CAMELLIAKWP", PREFIX + "$WrapWithPad", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseWrapCipher.Builder(bouncyCastleFipsProvider, Camellia.KWP).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.keyWrapOperatorFactory).withParameters(classArray2).build();
            }
        }));
        bouncyCastleFipsProvider.addAlias("Cipher", "CAMELLIAKWP", "CAMELLIAWRAPPAD");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyGenerator.CAMELLIA", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "Camellia", 128, false, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new Camellia.KeyGenerator(n, secureRandom);
                    }
                });
            }
        }));
        GuardedEngineCreator guardedEngineCreator4 = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "Camellia", 128, true, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new Camellia.KeyGenerator(128, secureRandom);
                    }
                });
            }
        });
        this.addKeyGeneratorForOIDs(bouncyCastleFipsProvider, PREFIX, guardedEngineCreator4, NTTObjectIdentifiers.id_camellia128_cbc, NTTObjectIdentifiers.id_camellia128_wrap);
        GuardedEngineCreator guardedEngineCreator5 = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "Camellia", 192, true, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new Camellia.KeyGenerator(192, secureRandom);
                    }
                });
            }
        });
        this.addKeyGeneratorForOIDs(bouncyCastleFipsProvider, PREFIX, guardedEngineCreator5, NTTObjectIdentifiers.id_camellia192_cbc, NTTObjectIdentifiers.id_camellia192_wrap);
        GuardedEngineCreator guardedEngineCreator6 = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseKeyGenerator(bouncyCastleFipsProvider, "Camellia", 256, true, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int n, SecureRandom secureRandom) {
                        return new Camellia.KeyGenerator(256, secureRandom);
                    }
                });
            }
        });
        this.addKeyGeneratorForOIDs(bouncyCastleFipsProvider, PREFIX, guardedEngineCreator6, NTTObjectIdentifiers.id_camellia256_cbc, NTTObjectIdentifiers.id_camellia256_wrap);
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.CAMELLIAGMAC", PREFIX + "$GMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseMac(Camellia.GMAC, (MACOperatorFactory)new Camellia.MACOperatorFactory(), new AuthParametersCreator(Camellia.GMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "CAMELLIAGMAC", "CAMELLIA-GMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.CAMELLIACMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseMac(Camellia.CMAC, (MACOperatorFactory)new Camellia.MACOperatorFactory(), new AuthParametersCreator(Camellia.CMAC));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "CAMELLIACMAC", "CAMELLIA-CMAC");
        bouncyCastleFipsProvider.addAlgorithmImplementation("Mac.CAMELLIACCMMAC", PREFIX + "$CAEMLLIACCMMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                return new BaseMac(Camellia.CCM, (MACOperatorFactory)new Camellia.MACOperatorFactory(), new AuthParametersCreator((AuthenticationParametersWithIV)Camellia.CCM.withMACSize(128)));
            }
        }));
        bouncyCastleFipsProvider.addAlias("Mac", "CAMELLIACCMMAC", "CAMELLIA-CCMMAC");
    }

    private BaseSecretKeyFactory createFixedFactory(final int n) {
        return new BaseSecretKeyFactory("Camellia", Camellia.ALGORITHM, new BaseSecretKeyFactory.Validator(){

            @Override
            public byte[] validated(byte[] byArray) throws InvalidKeySpecException {
                int n2 = byArray.length * 8;
                if (n2 != n) {
                    throw new InvalidKeySpecException("Provided key data wrong size for Camellia-" + n);
                }
                return byArray;
            }
        });
    }
}

