/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.metrics.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.InitializableComponent;
import net.shibboleth.shared.component.UninitializedComponentException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;

public class HTTPReporter
extends ScheduledReporter
implements InitializableComponent {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_DT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZZ";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPReporter.class);
    @Nonnull
    private final MetricRegistry metricRegistry;
    @Nonnull
    private final MetricFilter metricFilter;
    @Nonnull
    private final TimeUnit rateUnit;
    @Nonnull
    private final TimeUnit durationUnit;
    @NonnullAfterInit
    private HttpClient httpClient;
    @NonnullAfterInit
    @NotEmpty
    private String collectorURL;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @NonnullAfterInit
    private ObjectMapper jsonMapper;
    @Nullable
    private String dateTimeFormat;
    private boolean isInitialized;

    public HTTPReporter(@Nonnull @ParameterName(name="registry") MetricRegistry registry, @Nonnull @ParameterName(name="name") @NotEmpty String name, @Nullable @ParameterName(name="filter") MetricFilter filter) {
        super(registry, name, filter, TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.metricRegistry = registry;
        this.metricFilter = filter != null ? filter : MetricFilter.ALL;
        this.rateUnit = TimeUnit.SECONDS;
        this.durationUnit = TimeUnit.SECONDS;
    }

    public HTTPReporter(@Nonnull @ParameterName(name="registry") MetricRegistry registry, @Nonnull @ParameterName(name="name") @NotEmpty String name, @Nullable @ParameterName(name="filter") MetricFilter filter, @Nonnull @ParameterName(name="rUnit") TimeUnit rUnit, @Nonnull @ParameterName(name="dUnit") TimeUnit dUnit) {
        super(registry, name, filter, rUnit, dUnit);
        this.metricRegistry = registry;
        this.metricFilter = filter != null ? filter : MetricFilter.ALL;
        this.rateUnit = rUnit;
        this.durationUnit = dUnit;
    }

    public HTTPReporter(@Nonnull @ParameterName(name="registry") MetricRegistry registry, @Nonnull @ParameterName(name="name") @NotEmpty String name, @Nullable @ParameterName(name="filter") MetricFilter filter, @Nonnull @ParameterName(name="rUnit") TimeUnit rUnit, @Nonnull @ParameterName(name="dUnit") TimeUnit dUnit, @Nonnull @ParameterName(name="executor") ScheduledExecutorService executor) {
        super(registry, name, filter, rUnit, dUnit, executor);
        this.metricRegistry = registry;
        this.metricFilter = filter != null ? filter : MetricFilter.ALL;
        this.rateUnit = rUnit;
        this.durationUnit = dUnit;
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        this.doSetterPreconditions();
        this.httpClient = Constraint.isNotNull(client, "HttpClient cannot be null");
    }

    public void setCollectorURL(@Nonnull @NotEmpty String url) {
        this.doSetterPreconditions();
        this.collectorURL = Constraint.isNotNull(StringSupport.trimOrNull(url), "Collector URL cannot be null or empty");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.doSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    public void setDateTimeFormat(@Nullable @NotEmpty String format) {
        this.doSetterPreconditions();
        this.dateTimeFormat = StringSupport.trimOrNull(format);
    }

    private final void doSetterPreconditions() {
        if (!this.isInitialized()) {
            throw new UninitializedComponentException("HTTPReported has not yet been initialized and cannot be used.");
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void initialize() throws ComponentInitializationException {
        if (!this.isInitialized) {
            if (this.httpClient == null || this.collectorURL == null) {
                throw new ComponentInitializationException("HttpClient and collection URL cannot be null");
            }
            this.jsonMapper = new ObjectMapper().registerModule((Module)new MetricsModule(this.rateUnit, this.durationUnit, true, this.metricFilter));
            this.jsonMapper.registerModule((Module)new JavaTimeModule());
            this.jsonMapper.setDateFormat((DateFormat)new SimpleDateFormat(this.dateTimeFormat != null ? this.dateTimeFormat : DEFAULT_DT_FORMAT));
            this.jsonMapper.configure(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
            this.isInitialized = true;
        }
    }

    public void stop() {
        super.stop();
        this.httpClient = null;
        this.httpClientSecurityParameters = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report() {
        HTTPReporter hTTPReporter = this;
        synchronized (hTTPReporter) {
            try {
                HttpPost httpRequest = new HttpPost(this.collectorURL);
                HttpClientContext httpContext = this.buildHttpContext((HttpRequest)httpRequest);
                ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
                ObjectWriter writer = this.jsonMapper.writer();
                writer.writeValue((OutputStream)output, (Object)this.metricRegistry);
                EntityBuilder entityBuilder = EntityBuilder.create();
                entityBuilder.setContentType(ContentType.APPLICATION_JSON);
                entityBuilder.setBinary(output.toByteArray());
                httpRequest.setEntity(entityBuilder.build());
                try (ClassicHttpResponse response = this.httpClient.executeOpen(null, (ClassicHttpRequest)httpRequest, (HttpContext)httpContext);){
                    HttpClientSecuritySupport.checkTLSCredentialEvaluated(httpContext, httpRequest.getScheme());
                    if (response.getCode() == 200) {
                        this.log.debug("Metrics delivered successfully to collector");
                    } else {
                        this.log.error("Collector responded with HTTP status {}", (Object)response.getCode());
                    }
                }
            }
            catch (IOException e) {
                this.log.error("Error sending metric registry to collection point {}", (Object)this.collectorURL, (Object)e);
            }
        }
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        throw new UnsupportedOperationException("The per-metric report method should never be called.");
    }

    @Nonnull
    private HttpClientContext buildHttpContext(@Nonnull HttpRequest request) {
        HttpClientContext clientContext = HttpClientSecuritySupport.buildHttpClientContext(this.httpClientSecurityParameters);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria(clientContext, request);
        return clientContext;
    }
}

