/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import org.ldaptive.Response;
import org.ldaptive.SearchResult;
import org.ldaptive.control.VirtualListViewRequestControl;
import org.ldaptive.control.VirtualListViewResponseControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualListViewParams {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int beforeCount;
    private final int afterCount;
    private final int targetOffset;
    private final String assertionValue;

    public VirtualListViewParams(int offset, int before, int after) {
        this.targetOffset = offset;
        this.beforeCount = before;
        this.afterCount = after;
        this.assertionValue = null;
    }

    public VirtualListViewParams(String assertion, int before, int after) {
        this.assertionValue = assertion;
        this.beforeCount = before;
        this.afterCount = after;
        this.targetOffset = 0;
    }

    public int getBeforeCount() {
        return this.beforeCount;
    }

    public int getAfterCount() {
        return this.afterCount;
    }

    public int getTargetOffset() {
        return this.targetOffset;
    }

    public String getAssertionValue() {
        return this.assertionValue;
    }

    public VirtualListViewRequestControl createRequestControl(boolean critical) {
        if (this.assertionValue != null) {
            return new VirtualListViewRequestControl(this.assertionValue, this.beforeCount, this.afterCount, critical);
        }
        return new VirtualListViewRequestControl(this.targetOffset, this.beforeCount, this.afterCount, critical);
    }

    public VirtualListViewRequestControl createRequestControl(Response<SearchResult> response, boolean critical) {
        VirtualListViewRequestControl control = this.createRequestControl(critical);
        VirtualListViewResponseControl responseControl = (VirtualListViewResponseControl)response.getControl("2.16.840.1.113730.3.4.10");
        if (responseControl != null) {
            if (this.assertionValue == null) {
                control.setContentCount(responseControl.getContentCount());
            }
            control.setContextID(responseControl.getContextID());
        }
        return control;
    }

    public String toString() {
        String s = this.assertionValue != null ? String.format("[%s@%d::assertionValue=%s, beforeCount=%s, afterCount=%s]", this.getClass().getName(), this.hashCode(), this.assertionValue, this.beforeCount, this.afterCount) : String.format("[%s@%d::targetOffset=%s, beforeCount=%s, afterCount=%s]", this.getClass().getName(), this.hashCode(), this.targetOffset, this.beforeCount, this.afterCount);
        return s;
    }
}

