/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ml.Guardrails;
import org.opensearch.client.opensearch.ml.ModelConfig;
import org.opensearch.client.opensearch.ml.RateLimiter;
import org.opensearch.client.opensearch.ml.UpdateModelResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class UpdateModelRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UpdateModelRequest> {
    @Nonnull
    private final Map<String, JsonData> connector;
    @Nullable
    private final String connectorId;
    @Nullable
    private final String description;
    @Nullable
    private final Guardrails guardrails;
    @Nonnull
    private final Map<String, JsonData> interface_;
    @Nullable
    private final Boolean isEnabled;
    @Nullable
    private final ModelConfig modelConfig;
    @Nonnull
    private final String modelId;
    @Nullable
    private final String name;
    @Nullable
    private final RateLimiter rateLimiter;
    public static final JsonpDeserializer<UpdateModelRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateModelRequest::setupUpdateModelRequestDeserializer);
    public static final Endpoint<UpdateModelRequest, UpdateModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateModelRequest, UpdateModelResponse>(request -> "PUT", request -> {
        StringBuilder buf = new StringBuilder();
        buf.append("/_plugins/_ml/models/");
        SimpleEndpoint.pathEncode(request.modelId, buf);
        return buf.toString();
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateModelResponse._DESERIALIZER);

    private UpdateModelRequest(Builder builder) {
        super(builder);
        this.connector = ApiTypeHelper.unmodifiable(builder.connector);
        this.connectorId = builder.connectorId;
        this.description = builder.description;
        this.guardrails = builder.guardrails;
        this.interface_ = ApiTypeHelper.unmodifiable(builder.interface_);
        this.isEnabled = builder.isEnabled;
        this.modelConfig = builder.modelConfig;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.name = builder.name;
        this.rateLimiter = builder.rateLimiter;
    }

    public static UpdateModelRequest of(Function<Builder, ObjectBuilder<UpdateModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, JsonData> connector() {
        return this.connector;
    }

    @Nullable
    public final String connectorId() {
        return this.connectorId;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Guardrails guardrails() {
        return this.guardrails;
    }

    @Nonnull
    public final Map<String, JsonData> interface_() {
        return this.interface_;
    }

    @Nullable
    public final Boolean isEnabled() {
        return this.isEnabled;
    }

    @Nullable
    public final ModelConfig modelConfig() {
        return this.modelConfig;
    }

    @Nonnull
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final RateLimiter rateLimiter() {
        return this.rateLimiter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.connector)) {
            generator.writeKey("connector");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.connector.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.connectorId != null) {
            generator.writeKey("connector_id");
            generator.write(this.connectorId);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.guardrails != null) {
            generator.writeKey("guardrails");
            this.guardrails.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.interface_)) {
            generator.writeKey("interface");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.interface_.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.isEnabled != null) {
            generator.writeKey("is_enabled");
            generator.write(this.isEnabled.booleanValue());
        }
        if (this.modelConfig != null) {
            generator.writeKey("model_config");
            this.modelConfig.serialize(generator, mapper);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.rateLimiter != null) {
            generator.writeKey("rate_limiter");
            this.rateLimiter.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUpdateModelRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connector, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "connector");
        op.add(Builder::connectorId, JsonpDeserializer.stringDeserializer(), "connector_id");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::guardrails, Guardrails._DESERIALIZER, "guardrails");
        op.add(Builder::interface_, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "interface");
        op.add(Builder::isEnabled, JsonpDeserializer.booleanDeserializer(), "is_enabled");
        op.add(Builder::modelConfig, ModelConfig._DESERIALIZER, "model_config");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::rateLimiter, RateLimiter._DESERIALIZER, "rate_limiter");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.connector);
        result = 31 * result + Objects.hashCode(this.connectorId);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.guardrails);
        result = 31 * result + Objects.hashCode(this.interface_);
        result = 31 * result + Objects.hashCode(this.isEnabled);
        result = 31 * result + Objects.hashCode(this.modelConfig);
        result = 31 * result + this.modelId.hashCode();
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.rateLimiter);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateModelRequest other = (UpdateModelRequest)o;
        return Objects.equals(this.connector, other.connector) && Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.description, other.description) && Objects.equals(this.guardrails, other.guardrails) && Objects.equals(this.interface_, other.interface_) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.modelConfig, other.modelConfig) && this.modelId.equals(other.modelId) && Objects.equals(this.name, other.name) && Objects.equals(this.rateLimiter, other.rateLimiter);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UpdateModelRequest> {
        @Nullable
        private Map<String, JsonData> connector;
        @Nullable
        private String connectorId;
        @Nullable
        private String description;
        @Nullable
        private Guardrails guardrails;
        @Nullable
        private Map<String, JsonData> interface_;
        @Nullable
        private Boolean isEnabled;
        @Nullable
        private ModelConfig modelConfig;
        private String modelId;
        @Nullable
        private String name;
        @Nullable
        private RateLimiter rateLimiter;

        public Builder() {
        }

        private Builder(UpdateModelRequest o) {
            super(o);
            this.connector = Builder._mapCopy(o.connector);
            this.connectorId = o.connectorId;
            this.description = o.description;
            this.guardrails = o.guardrails;
            this.interface_ = Builder._mapCopy(o.interface_);
            this.isEnabled = o.isEnabled;
            this.modelConfig = o.modelConfig;
            this.modelId = o.modelId;
            this.name = o.name;
            this.rateLimiter = o.rateLimiter;
        }

        private Builder(Builder o) {
            super(o);
            this.connector = Builder._mapCopy(o.connector);
            this.connectorId = o.connectorId;
            this.description = o.description;
            this.guardrails = o.guardrails;
            this.interface_ = Builder._mapCopy(o.interface_);
            this.isEnabled = o.isEnabled;
            this.modelConfig = o.modelConfig;
            this.modelId = o.modelId;
            this.name = o.name;
            this.rateLimiter = o.rateLimiter;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder connector(Map<String, JsonData> map) {
            this.connector = Builder._mapPutAll(this.connector, map);
            return this;
        }

        @Nonnull
        public final Builder connector(String key, JsonData value) {
            this.connector = Builder._mapPut(this.connector, key, value);
            return this;
        }

        @Nonnull
        public final Builder connectorId(@Nullable String value) {
            this.connectorId = value;
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder guardrails(@Nullable Guardrails value) {
            this.guardrails = value;
            return this;
        }

        @Nonnull
        public final Builder guardrails(Function<Guardrails.Builder, ObjectBuilder<Guardrails>> fn) {
            return this.guardrails(fn.apply(new Guardrails.Builder()).build());
        }

        @Nonnull
        public final Builder interface_(Map<String, JsonData> map) {
            this.interface_ = Builder._mapPutAll(this.interface_, map);
            return this;
        }

        @Nonnull
        public final Builder interface_(String key, JsonData value) {
            this.interface_ = Builder._mapPut(this.interface_, key, value);
            return this;
        }

        @Nonnull
        public final Builder isEnabled(@Nullable Boolean value) {
            this.isEnabled = value;
            return this;
        }

        @Nonnull
        public final Builder modelConfig(@Nullable ModelConfig value) {
            this.modelConfig = value;
            return this;
        }

        @Nonnull
        public final Builder modelConfig(Function<ModelConfig.Builder, ObjectBuilder<ModelConfig>> fn) {
            return this.modelConfig(fn.apply(new ModelConfig.Builder()).build());
        }

        @Nonnull
        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder rateLimiter(@Nullable RateLimiter value) {
            this.rateLimiter = value;
            return this;
        }

        @Nonnull
        public final Builder rateLimiter(Function<RateLimiter.Builder, ObjectBuilder<RateLimiter>> fn) {
            return this.rateLimiter(fn.apply(new RateLimiter.Builder()).build());
        }

        @Override
        @Nonnull
        public UpdateModelRequest build() {
            this._checkSingleUse();
            return new UpdateModelRequest(this);
        }
    }
}

