/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.memory.action.conversation;

import java.time.Instant;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.conversation.ConversationalIndexConstants;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.memory.ConversationalMemoryHandler;
import org.opensearch.ml.memory.action.conversation.UpdateConversationRequest;
import org.opensearch.ml.memory.index.OpenSearchConversationalMemoryHandler;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class UpdateConversationTransportAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateConversationTransportAction.class);
    Client client;
    private ConversationalMemoryHandler cmHandler;
    private volatile boolean featureIsEnabled;

    @Inject
    public UpdateConversationTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, OpenSearchConversationalMemoryHandler cmHandler, ClusterService clusterService) {
        super("cluster:admin/opensearch/ml/memory/conversation/update", transportService, actionFilters, UpdateConversationRequest::new);
        this.client = client;
        this.cmHandler = cmHandler;
        this.featureIsEnabled = (Boolean)MLCommonsSettings.ML_COMMONS_MEMORY_FEATURE_ENABLED.get(clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_MEMORY_FEATURE_ENABLED, it -> {
            this.featureIsEnabled = it;
        });
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> listener) {
        if (!this.featureIsEnabled) {
            listener.onFailure((Exception)new OpenSearchException(ConversationalIndexConstants.ML_COMMONS_MEMORY_FEATURE_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        UpdateConversationRequest updateConversationRequest = UpdateConversationRequest.fromActionRequest(request);
        String conversationId = updateConversationRequest.getConversationId();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().newStoredContext(true);){
            Map<String, Object> updateContent = updateConversationRequest.getUpdateContent();
            updateContent.putIfAbsent("updated_time", Instant.now());
            this.cmHandler.updateConversation(conversationId, updateContent, this.getUpdateResponseListener(conversationId, listener, context));
        }
        catch (Exception e) {
            log.error("Failed to update Memory with ID " + conversationId, (Throwable)e);
            listener.onFailure(e);
        }
    }

    private ActionListener<UpdateResponse> getUpdateResponseListener(String conversationId, ActionListener<UpdateResponse> actionListener, ThreadContext.StoredContext context) {
        return ActionListener.runBefore((ActionListener)ActionListener.wrap(updateResponse -> {
            if (updateResponse != null && updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                log.info("Successfully updated the Memory with ID: {}", (Object)conversationId);
                actionListener.onResponse(updateResponse);
            } else {
                log.info("Failed to update the Memory with ID: {}", (Object)conversationId);
                actionListener.onResponse(updateResponse);
            }
        }, exception -> {
            log.error("Failed to update ML Memory with ID " + conversationId, (Throwable)exception);
            actionListener.onFailure(exception);
        }), () -> ((ThreadContext.StoredContext)context).restore());
    }
}

