/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.rank_eval;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalHitItem;
import org.opensearch.client.opensearch.core.rank_eval.UnratedDocument;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RankEvalMetricDetail
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RankEvalMetricDetail> {
    @Nonnull
    private final List<RankEvalHitItem> hits;
    @Nonnull
    private final Map<String, Map<String, JsonData>> metricDetails;
    private final double metricScore;
    @Nonnull
    private final List<UnratedDocument> unratedDocs;
    public static final JsonpDeserializer<RankEvalMetricDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalMetricDetail::setupRankEvalMetricDetailDeserializer);

    private RankEvalMetricDetail(Builder builder) {
        this.hits = ApiTypeHelper.unmodifiableRequired(builder.hits, (Object)this, "hits");
        this.metricDetails = ApiTypeHelper.unmodifiableRequired(builder.metricDetails, (Object)this, "metricDetails");
        this.metricScore = ApiTypeHelper.requireNonNull(builder.metricScore, this, "metricScore");
        this.unratedDocs = ApiTypeHelper.unmodifiableRequired(builder.unratedDocs, (Object)this, "unratedDocs");
    }

    public static RankEvalMetricDetail of(Function<Builder, ObjectBuilder<RankEvalMetricDetail>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<RankEvalHitItem> hits() {
        return this.hits;
    }

    @Nonnull
    public final Map<String, Map<String, JsonData>> metricDetails() {
        return this.metricDetails;
    }

    public final double metricScore() {
        return this.metricScore;
    }

    @Nonnull
    public final List<UnratedDocument> unratedDocs() {
        return this.unratedDocs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("hits");
        generator.writeStartArray();
        for (RankEvalHitItem rankEvalHitItem : this.hits) {
            rankEvalHitItem.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("metric_details");
        generator.writeStartObject();
        for (Map.Entry entry : this.metricDetails.entrySet()) {
            generator.writeKey((String)entry.getKey());
            generator.writeStartObject();
            for (Map.Entry item1 : ((Map)entry.getValue()).entrySet()) {
                generator.writeKey((String)item1.getKey());
                ((JsonData)item1.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("metric_score");
        generator.write(this.metricScore);
        generator.writeKey("unrated_docs");
        generator.writeStartArray();
        for (UnratedDocument unratedDocument : this.unratedDocs) {
            unratedDocument.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRankEvalMetricDetailDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::hits, JsonpDeserializer.arrayDeserializer(RankEvalHitItem._DESERIALIZER), "hits");
        op.add(Builder::metricDetails, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "metric_details");
        op.add(Builder::metricScore, JsonpDeserializer.doubleDeserializer(), "metric_score");
        op.add(Builder::unratedDocs, JsonpDeserializer.arrayDeserializer(UnratedDocument._DESERIALIZER), "unrated_docs");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.hits.hashCode();
        result = 31 * result + this.metricDetails.hashCode();
        result = 31 * result + Double.hashCode(this.metricScore);
        result = 31 * result + this.unratedDocs.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankEvalMetricDetail other = (RankEvalMetricDetail)o;
        return this.hits.equals(other.hits) && this.metricDetails.equals(other.metricDetails) && this.metricScore == other.metricScore && this.unratedDocs.equals(other.unratedDocs);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RankEvalMetricDetail> {
        private List<RankEvalHitItem> hits;
        private Map<String, Map<String, JsonData>> metricDetails;
        private Double metricScore;
        private List<UnratedDocument> unratedDocs;

        public Builder() {
        }

        private Builder(RankEvalMetricDetail o) {
            this.hits = Builder._listCopy(o.hits);
            this.metricDetails = Builder._mapCopy(o.metricDetails);
            this.metricScore = o.metricScore;
            this.unratedDocs = Builder._listCopy(o.unratedDocs);
        }

        private Builder(Builder o) {
            this.hits = Builder._listCopy(o.hits);
            this.metricDetails = Builder._mapCopy(o.metricDetails);
            this.metricScore = o.metricScore;
            this.unratedDocs = Builder._listCopy(o.unratedDocs);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder hits(List<RankEvalHitItem> list) {
            this.hits = Builder._listAddAll(this.hits, list);
            return this;
        }

        @Nonnull
        public final Builder hits(RankEvalHitItem value, RankEvalHitItem ... values) {
            this.hits = Builder._listAdd(this.hits, value, values);
            return this;
        }

        @Nonnull
        public final Builder hits(Function<RankEvalHitItem.Builder, ObjectBuilder<RankEvalHitItem>> fn) {
            return this.hits(fn.apply(new RankEvalHitItem.Builder()).build(), new RankEvalHitItem[0]);
        }

        @Nonnull
        public final Builder metricDetails(Map<String, Map<String, JsonData>> map) {
            this.metricDetails = Builder._mapPutAll(this.metricDetails, map);
            return this;
        }

        @Nonnull
        public final Builder metricDetails(String key, Map<String, JsonData> value) {
            this.metricDetails = Builder._mapPut(this.metricDetails, key, value);
            return this;
        }

        @Nonnull
        public final Builder metricScore(double value) {
            this.metricScore = value;
            return this;
        }

        @Nonnull
        public final Builder unratedDocs(List<UnratedDocument> list) {
            this.unratedDocs = Builder._listAddAll(this.unratedDocs, list);
            return this;
        }

        @Nonnull
        public final Builder unratedDocs(UnratedDocument value, UnratedDocument ... values) {
            this.unratedDocs = Builder._listAdd(this.unratedDocs, value, values);
            return this;
        }

        @Nonnull
        public final Builder unratedDocs(Function<UnratedDocument.Builder, ObjectBuilder<UnratedDocument>> fn) {
            return this.unratedDocs(fn.apply(new UnratedDocument.Builder()).build(), new UnratedDocument[0]);
        }

        @Override
        @Nonnull
        public RankEvalMetricDetail build() {
            this._checkSingleUse();
            return new RankEvalMetricDetail(this);
        }
    }
}

