/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch.core.search.InnerHits;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NestedQuery
extends QueryBase
implements QueryVariant,
ToCopyableBuilder<Builder, NestedQuery> {
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final InnerHits innerHits;
    @Nonnull
    private final String path;
    @Nonnull
    private final Query query;
    @Nullable
    private final ChildScoreMode scoreMode;
    public static final JsonpDeserializer<NestedQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NestedQuery::setupNestedQueryDeserializer);

    private NestedQuery(Builder builder) {
        super(builder);
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.innerHits = builder.innerHits;
        this.path = ApiTypeHelper.requireNonNull(builder.path, this, "path");
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.scoreMode = builder.scoreMode;
    }

    public static NestedQuery of(Function<Builder, ObjectBuilder<NestedQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Nested;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public final InnerHits innerHits() {
        return this.innerHits;
    }

    @Nonnull
    public final String path() {
        return this.path;
    }

    @Nonnull
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final ChildScoreMode scoreMode() {
        return this.scoreMode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped.booleanValue());
        }
        if (this.innerHits != null) {
            generator.writeKey("inner_hits");
            this.innerHits.serialize(generator, mapper);
        }
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.scoreMode != null) {
            generator.writeKey("score_mode");
            this.scoreMode.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNestedQueryDeserializer(ObjectDeserializer<Builder> op) {
        NestedQuery.setupQueryBaseDeserializer(op);
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(Builder::innerHits, InnerHits._DESERIALIZER, "inner_hits");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::scoreMode, ChildScoreMode._DESERIALIZER, "score_mode");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.ignoreUnmapped);
        result = 31 * result + Objects.hashCode(this.innerHits);
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.query.hashCode();
        result = 31 * result + Objects.hashCode(this.scoreMode);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedQuery other = (NestedQuery)o;
        return Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped) && Objects.equals(this.innerHits, other.innerHits) && this.path.equals(other.path) && this.query.equals(other.query) && Objects.equals(this.scoreMode, other.scoreMode);
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NestedQuery> {
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private InnerHits innerHits;
        private String path;
        private Query query;
        @Nullable
        private ChildScoreMode scoreMode;

        public Builder() {
        }

        private Builder(NestedQuery o) {
            super(o);
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.innerHits = o.innerHits;
            this.path = o.path;
            this.query = o.query;
            this.scoreMode = o.scoreMode;
        }

        private Builder(Builder o) {
            super(o);
            this.ignoreUnmapped = o.ignoreUnmapped;
            this.innerHits = o.innerHits;
            this.path = o.path;
            this.query = o.query;
            this.scoreMode = o.scoreMode;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        @Nonnull
        public final Builder innerHits(@Nullable InnerHits value) {
            this.innerHits = value;
            return this;
        }

        @Nonnull
        public final Builder innerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.innerHits(fn.apply(new InnerHits.Builder()).build());
        }

        @Nonnull
        public final Builder path(String value) {
            this.path = value;
            return this;
        }

        @Nonnull
        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Nonnull
        public final Builder scoreMode(@Nullable ChildScoreMode value) {
            this.scoreMode = value;
            return this;
        }

        @Override
        @Nonnull
        public NestedQuery build() {
            this._checkSingleUse();
            return new NestedQuery(this);
        }
    }
}

