/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.embedding;

import ai.djl.modality.nlp.embedding.EmbeddingException;
import ai.djl.modality.nlp.embedding.TextEmbedding;
import ai.djl.modality.nlp.embedding.WordEmbedding;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.NDList;
import java.util.ArrayList;
import java.util.List;

public class SimpleTextEmbedding
implements TextEmbedding {
    private WordEmbedding wordEmbedding;

    public SimpleTextEmbedding(WordEmbedding wordEmbedding) {
        this.wordEmbedding = wordEmbedding;
    }

    @Override
    public long[] preprocessTextToEmbed(List<String> text) {
        long[] result = new long[text.size()];
        for (int i = 0; i < text.size(); ++i) {
            result[i] = this.wordEmbedding.preprocessWordToEmbed(text.get(i));
        }
        return result;
    }

    @Override
    public NDArray embedText(NDArray textIndices) throws EmbeddingException {
        NDList result = new NDList();
        int i = 0;
        while ((long)i < textIndices.size()) {
            result.add(this.wordEmbedding.embedWord(textIndices.get(i)));
            ++i;
        }
        return NDArrays.stack(result);
    }

    @Override
    public List<String> unembedText(NDArray textEmbedding) {
        NDList split = textEmbedding.split(textEmbedding.getShape().get(0));
        ArrayList<String> result = new ArrayList<String>(split.size());
        for (NDArray token : split) {
            result.add(this.wordEmbedding.unembedWord(token.get(0L)));
        }
        return result;
    }
}

