/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.inference.streaming;

import ai.djl.ndarray.BytesSupplier;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class PublisherBytesSupplier
implements BytesSupplier {
    private Consumer<byte[]> subscriber;
    private CountDownLatch latch = new CountDownLatch(1);
    private CompletableFuture<Void> future = new CompletableFuture();

    public void appendContent(byte[] data, boolean lastChunk) {
        if (this.subscriber == null) {
            try {
                if (!this.latch.await(2L, TimeUnit.MINUTES)) {
                    throw new IllegalStateException("Wait for subscriber timeout.");
                }
                if (this.subscriber == null) {
                    throw new IllegalStateException("subscriber is not set.");
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Append content interrupted.", e);
            }
        }
        this.subscriber.accept(data);
        if (lastChunk) {
            this.subscriber.accept(null);
            this.future.complete(null);
        }
    }

    public CompletableFuture<Void> subscribe(Consumer<byte[]> subscriber) {
        if (this.subscriber != null) {
            throw new IllegalStateException("The PublisherBytesSupplier only allows a single Subscriber");
        }
        this.subscriber = subscriber;
        this.latch.countDown();
        return this.future;
    }

    @Override
    public ByteBuffer toByteBuffer() {
        throw new UnsupportedOperationException("Not supported.");
    }
}

