/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.algorithms.remote.streaming;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.engine.algorithms.remote.streaming.StreamPredictActionListener;
import org.opensearch.ml.engine.algorithms.remote.streaming.StreamingHandler;

public abstract class BaseStreamingHandler
implements StreamingHandler {
    protected void sendContentResponse(String content, boolean isLast, StreamPredictActionListener<MLTaskResponse, ?> actionListener) {
        ArrayList<ModelTensor> modelTensors = new ArrayList<ModelTensor>();
        Map<String, Boolean> dataMap = Map.of("content", content, "is_last", isLast);
        modelTensors.add(ModelTensor.builder().name("response").dataAsMap(dataMap).build());
        ModelTensorOutput output = ModelTensorOutput.builder().mlModelOutputs(List.of(ModelTensors.builder().mlModelTensors(modelTensors).build())).build();
        MLTaskResponse response = MLTaskResponse.builder().output((MLOutput)output).build();
        actionListener.onStreamResponse(response, isLast);
    }

    protected void sendCompletionResponse(AtomicBoolean isStreamClosed, StreamPredictActionListener<MLTaskResponse, ?> actionListener) {
        if (isStreamClosed.compareAndSet(false, true)) {
            this.sendContentResponse("", true, actionListener);
        }
    }
}

