/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.action;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import lombok.Generated;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.geospatial.ip2geo.jobscheduler.Datasource;

public class GetDatasourceResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField FIELD_NAME_DATASOURCES = new ParseField("datasources", new String[0]);
    private static final ParseField FIELD_NAME_NAME = new ParseField("name", new String[0]);
    private static final ParseField FIELD_NAME_STATE = new ParseField("state", new String[0]);
    private static final ParseField FIELD_NAME_ENDPOINT = new ParseField("endpoint", new String[0]);
    private static final ParseField FIELD_NAME_UPDATE_INTERVAL = new ParseField("update_interval_in_days", new String[0]);
    private static final ParseField FIELD_NAME_NEXT_UPDATE_AT = new ParseField("next_update_at_in_epoch_millis", new String[0]);
    private static final ParseField FIELD_NAME_NEXT_UPDATE_AT_READABLE = new ParseField("next_update_at", new String[0]);
    private static final ParseField FIELD_NAME_DATABASE = new ParseField("database", new String[0]);
    private static final ParseField FIELD_NAME_UPDATE_STATS = new ParseField("update_stats", new String[0]);
    private List<Datasource> datasources;

    public GetDatasourceResponse(List<Datasource> datasources) {
        this.datasources = datasources;
    }

    public GetDatasourceResponse(StreamInput in) throws IOException {
        this.datasources = in.readList(Datasource::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.datasources);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(FIELD_NAME_DATASOURCES.getPreferredName());
        for (Datasource datasource : this.datasources) {
            builder.startObject();
            builder.field(FIELD_NAME_NAME.getPreferredName(), datasource.getName());
            builder.field(FIELD_NAME_STATE.getPreferredName(), (Object)datasource.getState());
            builder.field(FIELD_NAME_ENDPOINT.getPreferredName(), datasource.getEndpoint());
            builder.field(FIELD_NAME_UPDATE_INTERVAL.getPreferredName(), datasource.getUserSchedule().getInterval());
            builder.timeField(FIELD_NAME_NEXT_UPDATE_AT.getPreferredName(), FIELD_NAME_NEXT_UPDATE_AT_READABLE.getPreferredName(), datasource.getUserSchedule().getNextExecutionTime(Instant.now()).toEpochMilli());
            builder.field(FIELD_NAME_DATABASE.getPreferredName(), (ToXContent)datasource.getDatabase());
            builder.field(FIELD_NAME_UPDATE_STATS.getPreferredName(), (ToXContent)datasource.getUpdateStats());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Generated
    public List<Datasource> getDatasources() {
        return this.datasources;
    }

    @Generated
    public void setDatasources(List<Datasource> datasources) {
        this.datasources = datasources;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetDatasourceResponse)) {
            return false;
        }
        GetDatasourceResponse other = (GetDatasourceResponse)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<Datasource> this$datasources = this.getDatasources();
        List<Datasource> other$datasources = other.getDatasources();
        return !(this$datasources == null ? other$datasources != null : !((Object)this$datasources).equals(other$datasources));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GetDatasourceResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Datasource> $datasources = this.getDatasources();
        result = result * 59 + ($datasources == null ? 43 : ((Object)$datasources).hashCode());
        return result;
    }
}

